require intel-iss-vtune-target-common.inc

SUMMARY = "Intel(R) VTune(TM) for Systems target package"
DESCRIPTION = "Intel(R) VTune(TM) for Systems target package"

# VTune features provided: SEP, Power and PIN-based collectors
PROVIDES += "virtual/intel-iss-vtune-sep virtual/intel-iss-vtune-tpss"

VTUNE_ISS_TARGET_FILE="vtune_amplifier_target_#ARCH#.tgz"


do_compile() {

	local sep_driver_dir power_driver_dir
	cd ${S}/${VTUNE_ISS_TARGET_DIR}

	sep_driver_dir="sepdk/src"
	power_driver_dir="powerdk/src"

	# Compiling SEP drivers
	mkdir -p "${VTUNE_ISS_INSTALLBUILD_DIR}/${sep_driver_dir}"
	run_build_driver "${sep_driver_dir}" "${VTUNE_ISS_INSTALLBUILD_DIR}/${sep_driver_dir}"

	# Compiling POWERDK drivers
#	mkdir -p "${VTUNE_ISS_INSTALLBUILD_DIR}/${power_driver_dir}"
#	run_build_driver "${power_driver_dir}" "${VTUNE_ISS_INSTALLBUILD_DIR}/${power_driver_dir}"
}
