# upstream_tracking.inc - This file contains data that tracks the
# upstream project associated with a given recipe. This list is needed
# for recipes that version information can not be automagically discovered.
# As we automate this checking, this file will slowed be reduced.
#
# This data is used by the package reporting system (packages.yoctoproject.org)
#
# The format is as a bitbake variable override for each recipe
#
#       RECIPE_UPSTREAM_VERSION_pn-<recipe name> = "<version>"
#       RECIPE_UPSTREAM_DATE_pn-<recipe name> = "Mmm dd, YYYY"
#	 - This is the latest upstream version and date
#       RECIPE_NO_UPDATE_REASON_pn-<recipe name> = "<free form text>"
#        - Used to note why a recipe should not be upgraded to a newer versoin
#       CHECK_DATE_pn-<recipe name> = "Mmm dd, YYYY"
#        - This is the date that upstream was last manually checked over time
#          this should be removed as we automate this checking
#
# These entries will slowly be removed as we can automatically determine
# the information in this file.  So for existing recipes that we can get 
# from the package reporting system, the entries here can be removed.
#
# Please keep this list in alphabetical order.
#
RECIPE_UPSTREAM_VERSION_pn-adt-installer = "1.1"
CHECK_DATE_pn-adt-installer = "Sep 11, 2012"
RECIPE_UPSTREAM_DATE_pn-avahi-ui = "Oct 01, 2010"
RECIPE_UPSTREAM_VERSION_pn-avahi = "0.6.31"
RECIPE_UPSTREAM_DATE_pn-avahi = "Oct 01, 2010"
RECIPE_UPSTREAM_VERSION_pn-bash = "4.2"
RECIPE_UPSTREAM_DATE_pn-bash = "Dec 01, 2009"
RECIPE_UPSTREAM_VERSION_pn-bc = "1.06"
CHECK_DATA_pn-bc = "Jul 27, 2012"
RECIPE_UPSTREAM_DATE_pn-bc = "Nov 01, 2000"
RECIPE_UPSTREAM_VERSION_pn-bdwgc = "gc-7.2d"
CHECK_DATE_pn-bdwgc = "Aug 27, 2012"
RECIPE_NO_UPDATE_REASON_pn-bluez4 = "BlueZ 5.x is not backward-compatible; components that interact with bluez not updated"
RECIPE_NO_UPDATE_REASON_pn-build-appliance = "Always reports behind"
RECIPE_NO_UPDATE_REASON_pn-cdrtools = "v3.x uses incompatible CDDL license"
RECIPE_UPSTREAM_VERSION_pn-clutter = "1.10.0"
RECIPE_UPSTREAM_DATE_pn-clutter = "Mar 22, 2012"
CHECK_DATE_pn-clutter = "Aug 28, 2012"
RECIPE_UPSTREAM_VERSION_pn-core-image-minimal = "1.0"
RECIPE_NO_UPDATE_REASON_pn-createrepo = "Versions after 0.9.* use YUM, so we hold at 0.4.11"
RECIPE_UPSTREAM_VERSION_pn-cups = "1.6.2"
RECIPE_UPSTREAM_DATE_pn-cups = "Mar 18, 2013"
CHECK_DATE_pn-cups = "Jun 11, 2013"
RECIPE_NO_UPDATE_REASON_pn-db= "API compatibility issue"
RECIPE_NO_UPDATE_REASON_pn-dbus = "D-BUS 1.7.x is the development version, not stable."
RECIPE_NO_UPDATE_REASON_pn-docbook-sgml-dtd-3.1-native = "PRS Reports Incorrectly"
RECIPE_NO_UPDATE_REASON_pn-docbook-sgml-dtd-4.1-native = "PRS Reports Incorrectly"
RECIPE_NO_UPDATE_REASON_pn-docbook-sgml-dtd-4.5-native = "PRS Reports Incorrectly"
RECIPE_UPSTREAM_VERSION_pn-eee-acpi-scripts = "1.1.12+9d4cdedca25b396405f8587f9c4fbf8229e041c2"
RECIPE_UPSTREAM_DATE_pn-eee-acpi-scripts = "Oct 3, 2011"
CHECK_DATE_pn-eee-acpi-scripts = "Aug 28, 2012"
RECIPE_UPSTREAM_VERSION_pn-formfactor = "0.0"
RECIPE_UPSTREAM_DATE_pn-formfactor = "n/a"
RECIPE_UPSTREAM_VERSION_pn-fstests="0.0+svnr426"
CHECK_DATE_pn-fstests = "Jul 06, 2011"
RECIPE_UPSTREAM_VERSION_pn-gaku="0.0+svnr399"
RECIPE_NO_UPDATE_REASON_pn-gawk = "Version 4.1.0 requires Automake 1.13, but have 1.12.6"
RECIPE_UPSTREAM_DATE_pn-gaku="Jul 03, 2008"
CHECK_DATE_pn-gaku = "Aug 29, 2012"
RECIPE_UPSTREAM_VERSION_pn-gdk-pixbuf = "2.27.2"
RECIPE_UPSTREAM_DATE_pn-gdk-pixbuf = "Mar 3, 2013"
CHECK_DATE_pn-gdk-pixbuf = "Mar 5, 2013"
RECIPE_NO_UPDATE_REASON_pn-gdk-pixbuf = "2.27.2 is unstable"
RECIPE_UPSTREAM_VERSION_pn-glibc = "2.11.2"
RECIPE_UPSTREAM_DATE_pn-glibc = "May 01, 2010"
RECIPE_NO_UPDATE_REASON_pn-glibc = "two glibc plugins are based on 2.10.1"
RECIPE_NO_UPDATE_REASON_pn-glib-networking = "Pending Glib-2.0 Update"
RECIPE_UPSTREAM_VERSION_pn-gnome-desktop = "3.7.90"
RECIPE_UPSTREAM_DATE_pn-gnome-desktop = "Feb 19, 2013"
CHECK_DATE_pn-gnome-desktop = "Mar 5, 2013"
RECIPE_NO_UPDATE_REASON_pn-gnome-desktop = "waiting for the sato gtk3 port"
RECIPE_UPSTREAM_VERSION_pn-gnome-icon-theme = "3.7.4"
RECIPE_UPSTREAM_DATE_pn-gnome-icon-theme = "Jan 17, 2013"
CHECK_DATE_pn-gnome-icon-theme = "Mar 5, 2013"
RECIPE_NO_UPDATE_REASON_pn-gnome-icon-theme = "waiting for the sato gtk3 port"
RECIPE_UPSTREAM_VERSION_pn-gnome-keyring = "3.7.91"
RECIPE_UPSTREAM_DATE_pn-gnome-keyring = "Mar 4, 2013"
CHECK_DATE_pn-gnome-keyring = "Mar 5, 2013"
RECIPE_NO_UPDATE_REASON_pn-gnome-keyring = "waiting for the sato gtk3 port"
RECIPE_NO_UPDATE_REASON_pn-gobject_introspection = "Does not cross-compile"
RECIPE_NO_UPDATE_REASON_pn-groff = "1.18.1.4 is latest GPLv2 Version no 1.21"
RECIPE_NO_UPDATE_REASON_pn-grub="grub2 is a different thing"
RECIPE_UPSTREAM_DATE_pn-gst-meta-base="n/a"
RECIPE_NO_UPDATE_REASON_pn-gst-plugins-base = "not compatible with gst-fluendo 0.10.x"
RECIPE_NO_UPDATE_REASON_pn-gst-ffmpeg = "not compatible with gst-fluendo 0.10.x"
RECIPE_NO_UPDATE_REASON_pn-gst-plugins-bad = "not compatible with gst-fluendo 0.10.x"
RECIPE_NO_UPDATE_REASON_pn-gst-plugins-good = "not compatible with gst-fluendo 0.10.x"
RECIPE_NO_UPDATE_REASON_pn-gst-plugins-ugly = "not compatible with gst-fluendo 0.10.x"
RECIPE_NO_UPDATE_REASON_pn-gstreamer=" not compatible with gst-fluendo 0.10.x "
RECIPE_NO_UPDATE_REASON_pn-gtk+ = "Do not upgrade to version: 2.99.2 because prefer stable tree"
RECIPE_NO_UPDATE_REASON_pn-gtk-doc-stub = "PRS Reports Incorrectly"
RECIPE_UPSTREAM_VERSION_pn-gtk-engines = "2.91.1"
RECIPE_UPSTREAM_DATE_pn-gtk-engines = "Oct 9, 2010"
CHECK_DATE_pn-gtk-engines = "Mar 5, 2013"
RECIPE_NO_UPDATE_REASON_pn-gtk-engines = "2.91.1 is a 3.0 beta release"
RECIPE_UPSTREAM_VERSION_pn-icu = "4.8.1.1"
RECIPE_UPSTREAM_DATE_pn-icu = "Oct 10, 2011"
CHECK_DATE_pn-icu = "Aug 29, 2012"
RECIPE_UPSTREAM_VERSION_pn-initscripts = "9.40"
RECIPE_UPSTREAM_DATE_pn-initscripts = "Aug 06, 2012"
CHECK_DATE_pn-initscripts = "Aug 29, 2012"
RECIPE_UPSTREAM_VERSION_pn-inputproto = "2.2.99.1"
RECIPE_UPSTREAM_DATE_pn-inputproto = "Jan 5, 2013"
CHECK_DATE_pn-inputproto = "Mar 5, 2013"
RECIPE_NO_UPDATE_REASON_pn-inputproto = "2.2.99.1 is unstable"
RECIPE_UPSTREAM_VERSION_pn-jpeg = "9"
RECIPE_UPSTREAM_DATE_pn-jpeg = "Jan 13, 2013"
CHECK_DATE_pn-jpeg = "Mar 5, 2013"
RECIPE_NO_UPDATE_REASON_pn-jpeg = "webkit-gtk 1.8.3 doesn't work with jpeg 9"
RECIPE_NO_UPDATE_REASON_pn-kconfig-frontends = "PRS Reports Incorrectly"
RECIPE_NO_UPDATE_REASON_pn-kernelshark = "0.2 is the latest version."
RECIPE_UPSTREAM_VERSION_pn-keymaps = "1.0"
RECIPE_UPSTREAM_DATE_pn-keymaps = "n/a"
RECIPE_UPSTREAM_VERSION_pn-kmod = "9"
RECIPE_UPSTREAM_DATE_pn-kmod = "Jun 19, 2012"
CHECK_DATE_pn-kmod = "Jul 27, 2012"
CHECK_DATE_pn-latencytop = "Jul 30, 2014"
RECIPE_NO_UPDATE_REASON_pn-liberation-fonts = "2.00.0 - fontforge package required "
RECIPE_UPSTREAM_VERSION_pn-libgnome-keyring = "3.7.91"
RECIPE_UPSTREAM_DATE_pn-libgnome-keyring = "Mar 4, 2013"
CHECK_DATE_pn-libgnome-keyring = "Mar 5, 2013"
RECIPE_NO_UPDATE_REASON_pn-libgnome-keyring = "waiting for the sato gtk3 port"
RECIPE_UPSTREAM_VERSION_pn-libiconv = "1.14"
RECIPE_UPSTREAM_DATE_pn-libiconv = "Aug 07, 2011"
CHECK_DATE_pn-libiconv = "Aug 30, 2012"
RECIPE_NO_UPDATE_REASON_pn-libnl = "libnl-3.2.2 is incompatible with libnl2, so no Upgrade"
RECIPE_UPSTREAM_VERSION_pn-libsoup = "2.41.90"
RECIPE_UPSTREAM_VERSION_pn-libpng = "1.6.6"
RECIPE_UPSTREAM_DATE_pn-libpng = "Sep 16, 2013"
CHECK_DATE_pn-libpng = "Oct 02, 2013"
RECIPE_UPSTREAM_VERSION_pn-libpng12 = "1.2.50"
RECIPE_UPSTREAM_DATE_pn-libpng12 = "Jul 10, 2012"
CHECK_DATE_pn-libpng12 = "Oct 02, 2013"
RECIPE_UPSTREAM_DATE_pn-libsoup = "Feb 19, 2013"
CHECK_DATE_pn-libsoup = "Mar 5, 2013"
RECIPE_NO_UPDATE_REASON_pn-libsoup = "2.41.90 is unstable"
RECIPE_NO_UPDATE_REASON_pn-libtheora = "1.1.1 is latest stable release not 1.2.0alpha1"
RECIPE_NO_UPDATE_REASON_pn-libunique = "Do not upgrade to version: 2.91.4 because it requires gtk+ >= 2.90.0 and the stable version of gtk+ used by poky is 2.20.1"
RECIPE_UPSTREAM_VERSION_pn-liburcu = "0.7.0"
RECIPE_UPSTREAM_DATE_pn-liburcu = "May 25, 2012"
CHECK_DATE_pn-liburcu = "Aug 30, 2012"
RECIPE_UPSTREAM_VERSION_pn-libusb = "1.0.9"
RECIPE_UPSTREAM_DATE_pn-libusb = "Apr 20, 2012"
CHECK_DATE_pn-libusb = "Aug 30, 2012"
RECIPE_UPSTREAM_DATE_pn-linuxdoc-tools-native = "Nov 22, 2009"
RECIPE_UPSTREAM_VERSION_pn-linuxdoc-tools-native = "0.9.66"
CHECK_DATE_pn-linuxdoc-tools-native = "Aug 31, 2012"
RECIPE_NO_UPDATE_REASON-libxml2 = "only release candidates available "
RECIPE_UPSTREAM_VERSION_pn-lsbtest = "1.0"
CHECK_DATE_pn-lsof = "Jul 30, 2014"
RECIPE_UPSTREAM_VERSION_pn-lz4 = "122"
RECIPE_UPSTREAM_DATE_pn-lz4 = "Aug 28, 2014"
CHECK_DATE_pn-lz4 = "Aug 30, 2014"
RECIPE_UPSTREAM_VERSION_pn-meta-ide-support = "check"
RECIPE_UPSTREAM_VERSION_pn-minicom = "2.6.2"
RECIPE_UPSTREAM_DATE_pn-minicom = "Feb 06, 2013"
CHECK_DATE_pn-minicom = "Oct 22, 2013"
RECIPE_UPSTREAM_DATE_pn-module-init-tools = "Jun 02, 2011"
RECIPE_UPSTREAM_VERSION_pn-module-init-tools = "3.15"
CHECK_DATE_pn-module-init-tools = "Aug 31, 2012"
RECIPE_UPSTREAM_DATE_pn-modutils-initscripts = "n/a"
RECIPE_NO_UPDATE_REASON_pn-mpeg2dec = "Why are we currently at 0.4.1?"
RECIPE_NO_UPDATE_REASON_pn-mx-1.0 = "PRS 1.99 is dev version"
CHECK_DATE_pn-nettle = "Aug 21, 2014"
RECIPE_NO_UPDATE_REASON_pn-nettle = "3.0.0 breaks gnutls, api changes"
RECIPE_UPSTREAM_VERSION_pn-ofono = "1.6"
RECIPE_UPSTREAM_DATE_pn-ofono="Apr 20, 2012"
CHECK_DATE_pn-ofono = "Aug 31, 2012"
RECIPE_NO_UPDATE_REASON_pn-openssl = "1.0.1 is beta 1.0.0c is latest"
RECIPE_UPSTREAM_DATE_pn-opkg-collateral = "n/a"
RECIPE_UPSTREAM_VERSION_pn-opkg = "0.1.8"
RECIPE_NO_UPDATE_REASON_pn-oprofileui-server = "PRS Reports Incorrectly"
CHECK_DATE_pn-opkg = "Aug 31, 2012"
RECIPE_UPSTREAM_DATE_pn-opkg = "Feb 01, 2010"
RECIPE_NO_UPDATE_REASON_pn-pkgconfig = "removes glib-conf, adds circular depends"
RECIPE_UPSTREAM_VERSION_pn-pointercal = "0.0"
RECIPE_UPSTREAM_DATE_pn-pointercal = "n/a"
RECIPE_UPSTREAM_DATE_pn-poky-feed-config-opkg = "n/a"
RECIPE_UPSTREAM_DATE_pn-polkit = "Jan 09, 2013"
RECIPE_UPSTREAM_VERSION_pn-polkit = "0.110"
CHECK_DATE_pn-polkit = "Mar 14, 2013"
RECIPE_NO_UPDATE_REASON_pn-polkit = "requires spidermonkey 1.8.5, not available in poky"
RECIPE_UPSTREAM_VERSION_pn-pong-clock = "1.0"
RECIPE_NO_UPDATE_REASON_pn-powertop = "Do not upgrade to version 1.97 since it's a beta release of the comming PowerTOP 2.0"
RECIPE_UPSTREAM_VERSION_pn-ppp-dialin = "check"
RECIPE_UPSTREAM_VERSION_pn-prelink="1.0+git1+9552f214c7faa816fdb55b289a457f0cab034f00"
RECIPE_NO_UPDATE_REASON_pn-python-distribute = "0.7.3 only upgrades 0.6.32, can't install on its own, also obsolete"
RECIPE_UPSTREAM_VERSION_pn-python-distribute = "0.7.3"
RECIPE_NO_UPDATE_REASON_pn-python-pygobject = "Newer versions of python-pygobject depend on gobject-introspection which doesn't cross-compile"
RECIPE_UPSTREAM_VERSION_pn-python-pygobject = "3.13.3"
CHECK_DATE_pn-prelink = "Aug 31, 2012"
RECIPE_UPSTREAM_DATE_pn-qemu-helper-native = "n/a"
RECIPE_NO_UPDATE_REASON_pn-qemugl = "Do not upgrade to version: 33466cd8 because the upstream is broken in x86_64 build"
RECIPE_UPSTREAM_VERSION_pn-rpm = "5.4.10"
RECIPE_UPSTREAM_DATE_pn-rpm = "Jul 06, 2012"
CHECK_DATE_pn-rpm = "Sep 03, 2012"
RECIPE_UPSTREAM_VERSION_pn-run-postinsts = "check"
RECIPE_NO_UPDATE_REASON_pn-sato-screenshot = "PRS Reports Incorrectly"
RECIPE_NO_UPDATE_REASON_pn-socat = "2.0.0 is beta"
RECIPE_UPSTREAM_VERSION_pn-sqlite3 = "3.8.0.2"
RECIPE_UPSTREAM_DATE_pn-sqlite3 = "Sep 03, 2013"
CHECK_DATE_pn-sqlite3= "Oct 02, 2013"
RECIPE_UPSTREAM_VERSION_pn-squashfs-tools = "4.2"
RECIPE_UPSTREAM_DATE_pn-squashfs-tools = "Feb 28, 2011"
CHECK_DATE_pn-squashfs-tools = "Nov 09, 2012"
RECIPE_NO_UPDATE_REASON_pn-syslinux="Waiting for 4.06 for 3.3 kernel headers support"
RECIPE_NO_UPDATE_REASON_pn-texinfo = "Checking script parses directory wrong"
RECIPE_UPSTREAM_VERSION_pn-tinylogin = "1.4"
CHECK_DATE_pn-tinylogin = "Sep 03, 2012"
RECIPE_UPSTREAM_DATE_pn-tinylogin = "Jan 03, 2003"
RECIPE_NO_UPDATE_REASON_pn-tinylogin = "TinyLogin was merged into BusyBox."
RECIPE_UPSTREAM_VERSION_pn-tremor="20120122"
RECIPE_UPSTREAM_DATE_pn-tremor="Jan 22, 2012"
CHECK_DATE_pn-tremor = "Mar 11, 2013"
RECIPE_NO_UPDATE_REASON_pn-tremor = "Same revision on different SVN modules"
RECIPE_UPSTREAM_VERSION_pn-ubootchart = "0.0+r12"
CHECK_DATE_pn-ubootchart = "Sep 11, 2012"
RECIPE_UPSTREAM_DATE_pn-udev-extraconf = "n/a"
RECIPE_UPSTREAM_VERSION_pn-unifdef-native="2.6.18+git"
RECIPE_UPSTREAM_DATE_pn-unifdef-native = "Feb 05, 2011"
CHECK_DATE_pn-unifdef-native = "Sep 03, 2012"
RECIPE_UPSTREAM_VERSION_pn-unzip = "6.0"
RECIPE_UPSTREAM_DATE_pn-unzip = "Apr 25, 2009"
CHECK_DATE_pn-unzip = "Sep 03, 2012"
RECIPE_UPSTREAM_VERSION_pn-usbinit = "n/a"
RECIPE_UPSTREAM_VERSION_pn-usbutils = "006"
RECIPE_UPSTREAM_DATE_pn-usbutils = "Jul 06, 2012"
CHECK_DATE_pn-usbutils = "Sep 03, 2012"
RECIPE_NO_UPDATE_REASON_pn-vte = "Pending Glib-2.0 Update"
RECIPE_UPSTREAM_VERSION_pn-webkit-gtk = "1.10.2"
RECIPE_UPSTREAM_DATE_pn-webkit-gtk = "Dec 12, 2012"
CHECK_DATE_pn-webkit-gtk = "Mar 5, 2013"
RECIPE_NO_UPDATE_REASON_pn-webkit-gtk = ">= 1.10.2 needs ruby"
RECIPE_UPSTREAM_DATE_pn-x11-common="Sep 22, 2008"
RECIPE_UPSTREAM_VERSION_pn-x11-common = "1:7.6"
CHECK_DAte_pn-x11-common = "Sep 03, 2012"
RECIPE_NO_UPDATE_REASON_pn-xdg-utils = "only release candidates available "
RECIPE_UPSTREAM_VERSION_pn-xev = "1.0.4"
RECIPE_UPSTREAM_DATE_pn-xev = "Oct 13, 2009"
CHECK_DATE_pn-xev = "Sep 04, 2012"
CHECK_DATE_pn-xinetd = "Jul 30, 2014"
RECIPE_UPSTREAM_DATE_pn-xorg-minimal-fonts = "n/a"
RECIPE_UPSTREAM_DATE_pn-xserver-nodm-init=""
RECIPE_UPSTREAM_VERSION_pn-xz = "5.0.4"
RECIPE_UPSTREAM_DATE_pn-xz = "unknown"
CHECK_DATE_pn-xz = "Sep 04, 2012"
RECIPE_NO_UPDATE_REASON_pn-zaurusd = "SVN rev 426 is last Stable release"
RECIPE_UPSTREAM_VERSION_pn-zip = "3.0"
RECIPE_UPSTREAM_DATE_pn-zip = "Sep 01, 2009"
CHECK_DATE_pn-zip = "Sep 04, 2012"
