/*
 * Decompiled with CFR 0.152.
 */
package com.wittams.gritty;

import com.wittams.gritty.CharacterUtils;
import com.wittams.gritty.ControlSequence;
import com.wittams.gritty.Mode;
import com.wittams.gritty.RequestOrigin;
import com.wittams.gritty.StoredCursor;
import com.wittams.gritty.TerminalWriter;
import com.wittams.gritty.TtyChannel;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.log4j.Logger;

public class Emulator {
    private static final Logger logger = Logger.getLogger(Emulator.class);
    private final TerminalWriter tw;
    protected final TtyChannel channel;
    StoredCursor storedCursor = null;

    public Emulator(TerminalWriter tw, TtyChannel channel) {
        this.channel = channel;
        this.tw = tw;
    }

    public void sendBytes(byte[] bytes) throws IOException {
        this.channel.sendBytes(bytes);
    }

    public void start() {
        this.go();
    }

    public byte[] getCode(int key) {
        return CharacterUtils.getCode(key);
    }

    void go() {
        try {
            while (true) {
                this.singleIteration();
            }
        }
        catch (InterruptedIOException e) {
            logger.info((Object)"Terminal exiting");
        }
        catch (Exception e) {
            logger.error((Object)"Caught exception in terminal thread", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postResize(Dimension dimension, RequestOrigin origin) {
        Dimension pixelSize;
        TerminalWriter terminalWriter = this.tw;
        synchronized (terminalWriter) {
            pixelSize = this.tw.resize(dimension, origin);
        }
        this.channel.postResize(dimension, pixelSize);
    }

    void singleIteration() throws IOException {
        byte b = this.channel.getChar();
        switch (b) {
            case 0: {
                break;
            }
            case 27: {
                b = this.channel.getChar();
                this.handleESC(b);
                break;
            }
            case 7: {
                this.tw.beep();
                break;
            }
            case 8: {
                this.tw.backspace();
                break;
            }
            case 9: {
                this.tw.horizontalTab();
                break;
            }
            case 13: {
                this.tw.carriageReturn();
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                this.tw.newLine();
                break;
            }
            default: {
                if (b <= 31) {
                    if (!logger.isInfoEnabled()) break;
                    StringBuffer sb = new StringBuffer("Unhandled control character:");
                    CharacterUtils.appendChar(sb, CharacterUtils.CharacterType.NONE, (char)b);
                    logger.info((Object)sb.toString());
                    break;
                }
                if (b > 127) {
                    byte[] bytesOfChar = new byte[]{b, this.channel.getChar()};
                    this.tw.writeDoubleByte(bytesOfChar);
                    break;
                }
                this.channel.pushChar(b);
                int availableChars = this.channel.advanceThroughASCII(this.tw.distanceToLineEnd());
                this.tw.writeASCII(this.channel.buf, this.channel.offset - availableChars, availableChars);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleESC(byte initByte) throws IOException {
        byte b = initByte;
        if (b == 91) {
            this.doControlSequence();
        } else {
            byte[] intermediate = new byte[10];
            int intCount = 0;
            while (b >= 32 && b <= 47) {
                intermediate[++intCount - 1] = b;
                b = this.channel.getChar();
            }
            if (b >= 48 && b <= 126) {
                TerminalWriter terminalWriter = this.tw;
                synchronized (terminalWriter) {
                    switch (b) {
                        case 77: {
                            this.tw.reverseIndex();
                            break;
                        }
                        case 68: {
                            this.tw.index();
                            break;
                        }
                        case 69: {
                            this.tw.nextLine();
                            break;
                        }
                        case 55: {
                            this.saveCursor();
                            break;
                        }
                        case 56: {
                            if (intCount > 0 && intermediate[0] == 35) {
                                this.tw.fillScreen('E');
                                break;
                            }
                            this.restoreCursor();
                            break;
                        }
                        default: {
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("Unhandled escape sequence : " + this.escapeSequenceToString(intermediate, intCount, b)));
                        }
                    }
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Malformed escape sequence, pushing back to buffer: " + this.escapeSequenceToString(intermediate, intCount, b)));
                }
                int i = intCount - 1;
                while (i >= 0) {
                    byte ib = intermediate[i];
                    this.channel.pushChar(ib);
                    --i;
                }
                this.channel.pushChar(b);
            }
        }
    }

    private void saveCursor() {
        if (this.storedCursor == null) {
            this.storedCursor = new StoredCursor();
        }
        this.tw.storeCursor(this.storedCursor);
    }

    private void restoreCursor() {
        this.tw.restoreCursor(this.storedCursor);
    }

    private String escapeSequenceToString(byte[] intermediate, int intCount, byte b) {
        StringBuffer sb = new StringBuffer("ESC ");
        int i = 0;
        while (i < intCount) {
            byte ib = intermediate[i];
            sb.append(' ');
            sb.append((char)ib);
            ++i;
        }
        sb.append(' ');
        sb.append((char)b);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doControlSequence() throws IOException {
        ControlSequence cs = new ControlSequence(this.channel);
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("Control sequence\n");
            sb.append("parsed                        :");
            cs.appendToBuffer(sb);
            sb.append('\n');
            sb.append("bytes read                    :ESC[");
            cs.appendActualBytesRead(sb, this.channel);
            logger.debug((Object)sb.toString());
        }
        if (cs.pushBackReordered(this.channel)) {
            return;
        }
        TerminalWriter terminalWriter = this.tw;
        synchronized (terminalWriter) {
            switch (cs.getFinalChar()) {
                case 109: {
                    this.tw.setCharacterAttributes(cs);
                    break;
                }
                case 114: {
                    this.tw.setScrollingRegion(cs);
                    break;
                }
                case 65: {
                    this.tw.cursorUp(cs);
                    break;
                }
                case 66: {
                    this.tw.cursorDown(cs);
                    break;
                }
                case 67: {
                    this.tw.cursorForward(cs);
                    break;
                }
                case 68: {
                    this.tw.cursorBackward(cs);
                    break;
                }
                case 72: 
                case 102: {
                    this.tw.cursorPosition(cs);
                    break;
                }
                case 75: {
                    this.tw.eraseInLine(cs);
                    break;
                }
                case 74: {
                    this.tw.eraseInDisplay(cs);
                    break;
                }
                case 104: {
                    this.setModes(cs, true);
                    break;
                }
                case 108: {
                    this.setModes(cs, false);
                    break;
                }
                case 99: {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Identifying to remote system as VT102");
                    }
                    this.channel.sendBytes(CharacterUtils.deviceAttributesResponse);
                    break;
                }
                default: {
                    if (!logger.isInfoEnabled()) break;
                    StringBuffer sb = new StringBuffer();
                    sb.append("Unhandled Control sequence\n");
                    sb.append("parsed                        :");
                    cs.appendToBuffer(sb);
                    sb.append('\n');
                    sb.append("bytes read                    :ESC[");
                    cs.appendActualBytesRead(sb, this.channel);
                    logger.info((Object)sb.toString());
                }
            }
        }
    }

    private void setModes(ControlSequence args, boolean on) throws IOException {
        int argCount = args.getCount();
        Mode[] modeTable = args.getModeTable();
        int i = 0;
        while (i < argCount) {
            int num = args.getArg(i, -1);
            Mode mode = null;
            if (num >= 0 && num < modeTable.length) {
                mode = modeTable[num];
            }
            if (mode == null) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Unknown mode " + num));
                }
            } else if (on) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Modes: adding " + (Object)((Object)mode)));
                }
                this.tw.setMode(mode);
            } else {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Modes: removing " + (Object)((Object)mode)));
                }
                this.tw.unsetMode(mode);
            }
            ++i;
        }
    }
}

