/*
 * Decompiled with CFR 0.152.
 */
package com.wittams.gritty.swing;

import com.wittams.gritty.Emulator;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ConnectedKeyHandler
implements KeyListener {
    private static Logger logger = Logger.getLogger(ConnectedKeyHandler.class);
    private final Emulator emulator;

    public ConnectedKeyHandler(Emulator emu) {
        this.emulator = emu;
    }

    public void keyPressed(KeyEvent e) {
        try {
            int keycode = e.getKeyCode();
            byte[] code = this.emulator.getCode(keycode);
            if (code != null) {
                this.emulator.sendBytes(code);
            } else {
                char keychar = e.getKeyChar();
                byte[] obuffer = new byte[1];
                if ((keychar & 0xFF00) == 0) {
                    obuffer[0] = (byte)e.getKeyChar();
                    this.emulator.sendBytes(obuffer);
                }
            }
        }
        catch (IOException ex) {
            logger.error((Object)"Error sending key to emulator", (Throwable)ex);
        }
    }

    public void keyTyped(KeyEvent e) {
        char keychar = e.getKeyChar();
        if ((keychar & 0xFF00) != 0) {
            char[] foo = new char[]{keychar};
            try {
                byte[] bytes = new String(foo).getBytes("EUC-JP");
                this.emulator.sendBytes(bytes);
            }
            catch (IOException ex) {
                logger.error((Object)"Error sending key to emulator", (Throwable)ex);
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }
}

