/*
 * Decompiled with CFR 0.152.
 */
package com.wittams.gritty.swing;

import com.wittams.gritty.Questioner;
import com.wittams.gritty.TerminalWriter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class PreConnectHandler
implements Questioner,
KeyListener {
    private Object sync = new Object();
    private TerminalWriter tw;
    private StringBuffer answer;
    private boolean visible;

    PreConnectHandler(TerminalWriter tw) {
        this.tw = tw;
        this.visible = true;
    }

    public String questionHidden(String question) {
        this.visible = false;
        String answer = this.questionVisible(question, null);
        this.visible = true;
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String questionVisible(String question, String defValue) {
        Object object = this.sync;
        synchronized (object) {
            this.tw.writeUnwrappedString(question);
            this.answer = new StringBuffer();
            if (defValue != null) {
                this.answer.append(defValue);
                this.tw.writeUnwrappedString(defValue);
            }
            try {
                this.sync.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            String answerStr = this.answer.toString();
            this.answer = null;
            return answerStr;
        }
    }

    public void showMessage(String message) {
        this.tw.writeUnwrappedString(message);
        this.tw.nextLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyPressed(KeyEvent e) {
        if (this.answer == null) {
            return;
        }
        Object object = this.sync;
        synchronized (object) {
            boolean release = false;
            switch (e.getKeyCode()) {
                case 8: {
                    if (this.answer.length() <= 0) break;
                    this.tw.backspace();
                    this.tw.eraseInLine(0);
                    this.answer.deleteCharAt(this.answer.length() - 1);
                    break;
                }
                case 10: {
                    this.tw.nextLine();
                    release = true;
                }
            }
            if (release) {
                this.sync.notifyAll();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        if (this.answer == null) {
            return;
        }
        char c = e.getKeyChar();
        if (Character.getType(c) != 15) {
            if (this.visible) {
                this.tw.writeString(Character.toString(c));
            }
            this.answer.append(c);
        }
    }
}

