/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api;

import java.io.Serializable;

public class CertsDescription
implements Serializable {
    private static final long serialVersionUID = 1923500609559782312L;
    private String keyStoreFile;
    private String trustStoreFile;
    private transient char[] keyStorePwd;
    private transient char[] trustStorePwd;

    public CertsDescription() {
    }

    public CertsDescription(String keyStoreFile, String trustStoreFile) {
        this.keyStoreFile = keyStoreFile;
        this.trustStoreFile = trustStoreFile;
    }

    public void setKeyStore(String file, char[] pwd) {
        this.keyStoreFile = file;
        this.keyStorePwd = pwd;
    }

    public void setTrustStore(String file, char[] pwd) {
        this.trustStoreFile = file;
        this.trustStorePwd = pwd;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStorePwd(char[] keyStorePwd) {
        this.keyStorePwd = keyStorePwd;
    }

    public char[] getKeyStorePwd() {
        return this.keyStorePwd;
    }

    public void setTrustStoreFile(String trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
    }

    public String getTrustStoreFile() {
        return this.trustStoreFile;
    }

    public void setTrustStorePwd(char[] trustStorePwd) {
        this.trustStorePwd = trustStorePwd;
    }

    public char[] getTrustStorePwd() {
        return this.trustStorePwd;
    }

    public void clearKeyPwd() {
        this.clearPwd(this.keyStorePwd);
        this.keyStorePwd = null;
    }

    public void clearTrustPwd() {
        this.clearPwd(this.trustStorePwd);
        this.trustStorePwd = null;
    }

    public void clearPwds() {
        this.clearKeyPwd();
        this.clearTrustPwd();
    }

    public boolean hasPwds() {
        boolean hasPwds = this.keyStorePwd != null && this.keyStorePwd.length > 0 && this.trustStorePwd != null && this.trustStorePwd.length > 0;
        return hasPwds;
    }

    private void clearPwd(char[] pwd) {
        if (pwd != null) {
            for (int i = 0; i < pwd.length; ++i) {
                pwd[i] = '\u0000';
            }
        }
    }

    public boolean isEmpty() {
        return this.keyStoreFile == null || this.keyStoreFile.isEmpty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.keyStoreFile == null ? 0 : this.keyStoreFile.hashCode());
        result = 31 * result + (this.trustStoreFile == null ? 0 : this.trustStoreFile.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CertsDescription other = (CertsDescription)obj;
        if (this.keyStoreFile == null ? other.keyStoreFile != null : !this.keyStoreFile.equals(other.keyStoreFile)) {
            return false;
        }
        return !(this.trustStoreFile == null ? other.trustStoreFile != null : !this.trustStoreFile.equals(other.trustStoreFile));
    }

    public String toString() {
        return "CertsDescription [keyStoreFile=" + this.keyStoreFile + ", trustStoreFile=" + this.trustStoreFile + "]";
    }
}

