/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api;

public class StringUtils {
    public static String byteHexString(byte value) {
        return String.format("0x%02x", value);
    }

    public static String shortHexString(short value) {
        return String.format("0x%04x", value);
    }

    public static String intHexString(int value) {
        return String.format("0x%08x", value);
    }

    public static String longHexString(long value) {
        return String.format("0x%016x", value);
    }

    public static String getErrorMessage(Throwable error) {
        if (error == null) {
            return null;
        }
        while (error.getCause() != null) {
            error = error.getCause();
        }
        String msg = error.getLocalizedMessage();
        if (msg == null || msg.isEmpty()) {
            msg = error.getClass().getSimpleName();
        }
        return msg;
    }

    public static String getIpV4Addr(byte[] ipBytes) {
        if (ipBytes == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ipBytes.length; ++i) {
            int value = ipBytes[i] & 0xFF;
            if (i == 0) {
                sb.append(value);
                continue;
            }
            sb.append("." + value);
        }
        return sb.toString();
    }

    public static String getIpV6Addr(byte[] ipBytes) {
        if (ipBytes == null) {
            return null;
        }
        int compressSize = 0;
        int compressStart = -1;
        for (int i = 0; i < ipBytes.length; i += 2) {
            int numZeroGroups = 0;
            int j = i;
            while (j < ipBytes.length && ipBytes[j] == 0 && ipBytes[j + 1] == 0) {
                j += 2;
                ++numZeroGroups;
            }
            if (numZeroGroups <= compressSize) continue;
            compressSize = numZeroGroups;
            compressStart = i;
        }
        StringBuffer buff = new StringBuffer(40);
        if (compressSize < 2) {
            StringUtils.bytesToHex(buff, ipBytes, 0, ipBytes.length);
        } else {
            StringUtils.bytesToHex(buff, ipBytes, 0, compressStart);
            buff.append("::");
            StringUtils.bytesToHex(buff, ipBytes, compressStart + compressSize * 2, ipBytes.length);
        }
        return buff.toString();
    }

    private static void bytesToHex(StringBuffer buff, byte[] src, int start, int end) {
        String groupSeparator = "";
        for (int i = start; i < end; i += 2) {
            buff.append(groupSeparator);
            int group = src[i] << 8 & 0xFF00 | src[i + 1] & 0xFF;
            buff.append(Integer.toHexString(group));
            groupSeparator = ":";
        }
    }
}

