/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.configuration;

import com.intel.stl.api.configuration.EventClass;
import com.intel.stl.api.notice.NoticeSeverity;
import com.intel.stl.api.notice.TrapType;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum EventType {
    SM_TOPO_CHANGE(0, EventClass.SUBNET_EVENTS, NoticeSeverity.ERROR),
    PORT_ACTIVE(1, EventClass.SUBNET_EVENTS, NoticeSeverity.INFO),
    PORT_INACTIVE(2, EventClass.SUBNET_EVENTS, NoticeSeverity.WARNING),
    FE_CONNECTION_LOST(3, EventClass.MISCELLANEOUS_EVENTS, NoticeSeverity.CRITICAL),
    FE_CONNECTION_ESTABLISH(4, EventClass.MISCELLANEOUS_EVENTS, NoticeSeverity.INFO),
    SM_CONNECTION_LOST(5, EventClass.MISCELLANEOUS_EVENTS, NoticeSeverity.CRITICAL),
    SM_CONNECTION_ESTABLISH(6, EventClass.MISCELLANEOUS_EVENTS, NoticeSeverity.INFO);

    private static final Map<String, EventType> eventTypeMap;
    private static Logger log;
    private int id;
    private EventClass eventClass;
    private NoticeSeverity defaultSeverity;

    private EventType(int id, EventClass eventClass, NoticeSeverity severity) {
        this.id = id;
        this.eventClass = eventClass;
        this.defaultSeverity = severity;
    }

    public static EventType getEventType(TrapType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case GID_NOW_IN_SERVICE: {
                return PORT_ACTIVE;
            }
            case GID_OUT_OF_SERVICE: {
                return PORT_INACTIVE;
            }
            case LINK_PORT_CHANGE_STATE: {
                return SM_TOPO_CHANGE;
            }
            case SM_CONNECTION_LOST: {
                return SM_CONNECTION_LOST;
            }
            case SM_CONNECTION_ESTABLISH: {
                return SM_CONNECTION_ESTABLISH;
            }
            case FE_CONNECTION_LOST: {
                return FE_CONNECTION_LOST;
            }
            case FE_CONNECTION_ESTABLISH: {
                return FE_CONNECTION_ESTABLISH;
            }
        }
        throw new IllegalArgumentException("Unsupported TrapType " + (Object)((Object)type));
    }

    public static EventType getEventType(short type) {
        return EventType.getEventType(TrapType.getTrapType(type));
    }

    public int getId() {
        return this.id;
    }

    public EventClass getEventClass() {
        return this.eventClass;
    }

    public NoticeSeverity getDefaultSeverity() {
        return this.defaultSeverity;
    }

    public static EventType getEventType(String eventTypeName) {
        return eventTypeMap.get(eventTypeName);
    }

    static {
        eventTypeMap = new HashMap<String, EventType>();
        for (EventType evtType : EventType.values()) {
            eventTypeMap.put(evtType.name(), evtType);
        }
        log = LoggerFactory.getLogger(EventType.class);
    }
}

