/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.configuration;

import com.intel.stl.api.StringUtils;
import java.util.HashMap;
import java.util.Map;

public enum FocusFlag {
    OK(0),
    PMA_IGNORE(1),
    PMA_NORESP(2),
    TOPO_NORESP(3);

    private static final Map<Byte, FocusFlag> focusFlagMap;
    private final byte code;

    private FocusFlag(byte code) {
        this.code = code;
    }

    public byte getCode() {
        return this.code;
    }

    public static FocusFlag getFocusFlag(byte code) {
        FocusFlag res = focusFlagMap.get(code);
        if (res != null) {
            return res;
        }
        throw new IllegalArgumentException("Unsupported FocusFlag " + StringUtils.byteHexString(code));
    }

    static {
        focusFlagMap = new HashMap<Byte, FocusFlag>(){
            private static final long serialVersionUID = 1L;
            {
                for (FocusFlag ff : FocusFlag.values()) {
                    this.put(ff.code, ff);
                }
            }
        };
    }
}

