/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.configuration;

import com.intel.stl.api.StringUtils;
import java.util.HashMap;
import java.util.Map;

public enum LinkDownReason {
    NONE(0),
    RCV_ERROR_0(1),
    BAD_PKT_LEN(2),
    PKT_TOO_LONG(3),
    PKT_TOO_SHORT(4),
    BAD_SLID(5),
    BAD_DLID(6),
    BAD_L2(7),
    BAD_SC(8),
    RCV_ERROR_8(9),
    BAD_MID_TAIL(10),
    RCV_ERROR_10(11),
    PREEMPT_ERROR(12),
    PREEMPT_VL15(13),
    BAD_VL_MARKER(14),
    RCV_ERROR_14(15),
    RCV_ERROR_15(16),
    BAD_HEAD_DIST(17),
    BAD_TAIL_DIST(18),
    BAD_CTRL_DIST(19),
    BAD_CREDIT_ACK(20),
    UNSUPPORTED_VL_MARKER(21),
    BAD_PREEMPT(22),
    BAD_CONTROL_FLIT(23),
    EXCEED_MULTICAST_LIMIT(24),
    RCV_ERROR_24(25),
    RCV_ERROR_25(26),
    RCV_ERROR_26(27),
    RCV_ERROR_27(28),
    RCV_ERROR_28(29),
    RCV_ERROR_29(30),
    RCV_ERROR_30(31),
    EXCESSIVE_BUFFER_OVERRUN(32),
    UNKNOWN(33),
    REBOOT(35),
    NEIGHBOR_UNKNOWN(36),
    FM_BOUNCE(39),
    SPEED_POLICY(40),
    WIDTH_POLICY(41),
    DISCONNECTED(49),
    LOCAL_MEDIA_NOT_INSTALLED(50),
    NOT_INSTALLED(51),
    CHASSIS_CONFIG(52),
    END_TO_END_NOT_INSTALLED(54),
    POWER_POLICY(56),
    LINKSPEED_POLICY(57),
    LINKWIDTH_POLICY(58),
    SWITCH_MGMT(60),
    SMA_DISABLED(61),
    TRANSIENT(63);

    private static final Map<Byte, LinkDownReason> linkDownReasonMap;
    private final byte code;

    private LinkDownReason(byte code) {
        this.code = code;
    }

    public byte getCode() {
        return this.code;
    }

    public static LinkDownReason getLinkDownReason(byte code) {
        LinkDownReason res = linkDownReasonMap.get(code);
        if (res != null) {
            return res;
        }
        throw new IllegalArgumentException("Unsupported LinkDownReason " + StringUtils.byteHexString(code));
    }

    static {
        linkDownReasonMap = new HashMap<Byte, LinkDownReason>(){
            private static final long serialVersionUID = 1L;
            {
                for (LinkDownReason ldr : LinkDownReason.values()) {
                    this.put(ldr.code, ldr);
                }
            }
        };
    }
}

