/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.configuration;

import com.intel.stl.api.StringUtils;
import java.util.HashMap;
import java.util.Map;

public enum PortState {
    NO_ST_CHANGE(0),
    DOWN(1),
    INITIALIZE(2),
    ARMED(3),
    ACTIVE(4);

    private static final Map<Byte, PortState> _map;
    private final byte id;

    private PortState(byte id) {
        this.id = id;
    }

    public byte getId() {
        return this.id;
    }

    public static PortState getPortState(byte id) {
        PortState res = _map.get(id);
        if (res != null) {
            return res;
        }
        throw new IllegalArgumentException("Unsupported PortState " + StringUtils.byteHexString(id));
    }

    static {
        _map = new HashMap<Byte, PortState>(){
            private static final long serialVersionUID = 1L;
            {
                for (PortState type : PortState.values()) {
                    this.put(type.id, type);
                }
            }
        };
    }
}

