/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.configuration.impl;

import com.intel.stl.api.DatabaseException;
import com.intel.stl.api.ICertsAssistant;
import com.intel.stl.api.IMessage;
import com.intel.stl.api.StringUtils;
import com.intel.stl.api.configuration.AppInfo;
import com.intel.stl.api.configuration.ConfigurationException;
import com.intel.stl.api.configuration.EventNotFoundException;
import com.intel.stl.api.configuration.EventRule;
import com.intel.stl.api.configuration.IConfigurationApi;
import com.intel.stl.api.configuration.LoggingConfiguration;
import com.intel.stl.api.configuration.MailProperties;
import com.intel.stl.api.configuration.UserNotFoundException;
import com.intel.stl.api.configuration.UserSettings;
import com.intel.stl.api.configuration.impl.LogbackConfigurationHelper;
import com.intel.stl.api.configuration.impl.MailManager;
import com.intel.stl.api.notice.IEmailEventListener;
import com.intel.stl.api.notice.NoticeBean;
import com.intel.stl.api.performance.PMConfigBean;
import com.intel.stl.api.subnet.SubnetConnectionException;
import com.intel.stl.api.subnet.SubnetDataNotFoundException;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.common.STLMessages;
import com.intel.stl.configuration.AppConfigurationException;
import com.intel.stl.configuration.AppSettings;
import com.intel.stl.datamanager.DatabaseManager;
import com.intel.stl.fecdriver.IResponse;
import com.intel.stl.fecdriver.IStatement;
import com.intel.stl.fecdriver.adapter.IAdapter;
import com.intel.stl.fecdriver.messages.command.pa.FVCmdGetPMConfig;
import com.intel.stl.fecdriver.messages.response.FVResponse;
import com.intel.stl.fecdriver.session.ISession;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationApi
implements IConfigurationApi {
    private static Logger log = LoggerFactory.getLogger(ConfigurationApi.class);
    private final int PING_TIMEOUT_MS = 2000;
    private final IAdapter adapter;
    private final DatabaseManager dbMgr;
    private final MailManager mailMgr;
    private final String appDataPath;
    private ICertsAssistant certsAssistant;

    public ConfigurationApi(IAdapter adapter, DatabaseManager dbMgr, MailManager mailMgr, AppSettings appSettings) throws AppConfigurationException {
        this.adapter = adapter;
        this.dbMgr = dbMgr;
        this.mailMgr = mailMgr;
        this.appDataPath = appSettings.getConfigOption("app.data.path");
    }

    @Override
    public void registerCertsAssistant(ICertsAssistant assistant) {
        if (this.certsAssistant != null) {
            throw new IllegalStateException("Certs Assistant " + this.certsAssistant + "alreday exists");
        }
        this.certsAssistant = assistant;
        this.adapter.registerCertsAssistant(assistant);
    }

    @Override
    public boolean tryToConnect(SubnetDescription subnet) throws SubnetConnectionException {
        boolean isConnected = false;
        try (ISession session = null;){
            session = this.adapter.createTemporarySession(subnet.getCurrentFE(), null);
            IStatement statement = session.createStatement();
            FVCmdGetPMConfig cmd = new FVCmdGetPMConfig();
            statement.execute(cmd);
            ((FVResponse)cmd.getResponse()).get();
            isConnected = true;
        }
        return isConnected;
    }

    @Override
    public String getHostIp(String hostName) throws SubnetConnectionException {
        InetAddress inet = null;
        try {
            inet = InetAddress.getByName(hostName);
        }
        catch (Exception e) {
            SubnetConnectionException sce = new SubnetConnectionException((IMessage)STLMessages.STL50008_SUBNET_CONNECTION_ERROR, (Throwable)e, hostName, StringUtils.getErrorMessage(e));
            throw sce;
        }
        return inet != null ? inet.getHostAddress() : null;
    }

    @Override
    public boolean isHostReachable(String hostName) {
        boolean reachable = false;
        try {
            InetAddress inet = InetAddress.getByName(hostName);
            reachable = inet.isReachable(2000);
        }
        catch (UnknownHostException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return reachable;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isHostConnectable(SubnetDescription subnet) throws ConfigurationException {
        SocketChannel socketChannel = null;
        String host = subnet.getCurrentFE().getHost();
        int port = subnet.getCurrentFE().getPort();
        boolean connectable = false;
        try {
            Selector selector = Selector.open();
            socketChannel = SocketChannel.open();
            socketChannel.configureBlocking(false);
            socketChannel.register(selector, 8);
            socketChannel.connect(new InetSocketAddress(host, port));
            selector.select();
            connectable = socketChannel.finishConnect();
        }
        catch (IOException e) {
            try {
                if (socketChannel == null) return connectable;
                socketChannel.close();
                return connectable;
            }
            catch (IOException e2) {
                ConfigurationException ce = new ConfigurationException(STLMessages.STL50012_SOCKET_CLOSE_FAILURE, (Throwable)e2, new Object[]{subnet.getName(), StringUtils.getErrorMessage(e2)});
                log.error(StringUtils.getErrorMessage(ce), (Throwable)e2);
                throw ce;
            }
            catch (ClosedSelectorException e3) {
                try {
                    if (socketChannel == null) return connectable;
                    socketChannel.close();
                    return connectable;
                }
                catch (IOException e4) {
                    ConfigurationException ce = new ConfigurationException(STLMessages.STL50012_SOCKET_CLOSE_FAILURE, (Throwable)e4, new Object[]{subnet.getName(), StringUtils.getErrorMessage(e4)});
                    log.error(StringUtils.getErrorMessage(ce), (Throwable)e4);
                    throw ce;
                }
                catch (UnresolvedAddressException e5) {
                    try {
                        ConfigurationException ce = new ConfigurationException(STLMessages.STL50008_SUBNET_CONNECTION_ERROR, (Throwable)e5, new Object[]{subnet.getName(), StringUtils.getErrorMessage(e5)});
                        log.error(StringUtils.getErrorMessage(ce), (Throwable)e5);
                        throw ce;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (socketChannel == null) throw throwable;
                            socketChannel.close();
                            throw throwable;
                        }
                        catch (IOException e6) {
                            ConfigurationException ce = new ConfigurationException(STLMessages.STL50012_SOCKET_CLOSE_FAILURE, (Throwable)e6, new Object[]{subnet.getName(), StringUtils.getErrorMessage(e6)});
                            log.error(StringUtils.getErrorMessage(ce), (Throwable)e6);
                            throw ce;
                        }
                    }
                }
            }
        }
        try {
            if (socketChannel == null) return connectable;
            socketChannel.close();
            return connectable;
        }
        catch (IOException e) {
            ConfigurationException ce = new ConfigurationException(STLMessages.STL50012_SOCKET_CLOSE_FAILURE, (Throwable)e, new Object[]{subnet.getName(), StringUtils.getErrorMessage(e)});
            log.error(StringUtils.getErrorMessage(ce), (Throwable)e);
            throw ce;
        }
    }

    @Override
    public PMConfigBean getPMConfig(SubnetDescription subnet) {
        PMConfigBean config = null;
        try (ISession session = null;){
            session = this.adapter.createTemporarySession(subnet.getCurrentFE(), null);
            IStatement statement = session.createStatement();
            FVCmdGetPMConfig cmd = new FVCmdGetPMConfig();
            statement.execute(cmd);
            IResponse response = cmd.getResponse();
            List results = ((FVResponse)response).get();
            if (results != null && !results.isEmpty()) {
                session.close();
                PMConfigBean pMConfigBean = (PMConfigBean)results.get(0);
                return pMConfigBean;
            }
        }
        return config;
    }

    @Override
    public AppInfo getAppInfo() {
        return this.dbMgr.getAppInfo();
    }

    @Override
    public void saveAppInfo(AppInfo appInfo) {
        this.dbMgr.saveAppProperties(appInfo.getPropertiesMap());
    }

    @Override
    public List<SubnetDescription> getSubnets() {
        List<SubnetDescription> subnets = null;
        try {
            subnets = this.dbMgr.getSubnets();
        }
        catch (Exception e) {
            ConfigurationException ce = this.getConfigException(STLMessages.STL30038_ERROR_GETTING_SUBNETS, e, new Object[0]);
            throw ce;
        }
        return subnets;
    }

    @Override
    public UserSettings getUserSettings(String subnetName, String userName) throws UserNotFoundException {
        try {
            return this.dbMgr.getUserSettings(subnetName, userName);
        }
        catch (DatabaseException e) {
            ConfigurationException ce = this.getConfigException(STLMessages.STL30039_ERROR_GETTING_USER, e, new Object[0]);
            throw ce;
        }
    }

    @Override
    public void saveUserSettings(String subnetName, UserSettings userSettings) {
        try {
            this.dbMgr.saveUserSettings(subnetName, userSettings);
        }
        catch (DatabaseException e) {
            ConfigurationException ce = this.getConfigException(STLMessages.STL30040_ERROR_SAVING_USER, e, new Object[0]);
            throw ce;
        }
    }

    @Override
    public String getLogPropertyPath() {
        return System.getProperty("fmgui.logs.dir");
    }

    public void setLogPropertyPath(String logPropertyPath) {
        System.setProperty("fmgui.logs.dir", logPropertyPath);
    }

    @Override
    public SubnetDescription defineSubnet(SubnetDescription subnet) {
        try {
            return this.dbMgr.defineSubnet(subnet);
        }
        catch (DatabaseException e) {
            ConfigurationException ce = this.getConfigException(STLMessages.STL30041_ERROR_SAVING_SUBNET, e, new Object[0]);
            throw ce;
        }
    }

    @Override
    public void updateSubnet(SubnetDescription subnet) throws SubnetDataNotFoundException {
        this.dbMgr.updateSubnet(subnet);
        this.adapter.refreshSubnetDescription(subnet);
    }

    @Override
    public void removeSubnet(long subnetId) throws SubnetDataNotFoundException {
        this.dbMgr.removeSubnet(subnetId);
    }

    @Override
    public SubnetDescription getSubnet(String subnetName) throws SubnetDataNotFoundException {
        return this.dbMgr.getSubnet(subnetName);
    }

    @Override
    public SubnetDescription getSubnet(long subnetId) {
        SubnetDescription subnet = this.dbMgr.getSubnet(subnetId);
        if (subnet == null) {
            ConfigurationException ce = new ConfigurationException(STLMessages.STL30022_SUBNET_NOT_FOUND, subnetId);
            throw ce;
        }
        return subnet;
    }

    @Override
    public List<EventRule> getEventRules() throws EventNotFoundException {
        try {
            return this.dbMgr.getEventRules();
        }
        catch (DatabaseException e) {
            ConfigurationException ce = this.getConfigException(STLMessages.STL30042_ERROR_GETTING_EVENT, e, new Object[0]);
            throw ce;
        }
    }

    @Override
    public void saveEventRules(List<EventRule> rules) {
        try {
            this.dbMgr.saveEventRules(rules);
        }
        catch (DatabaseException e) {
            ConfigurationException ce = this.getConfigException(STLMessages.STL30043_ERROR_SAVING_EVENT, e, new Object[0]);
            throw ce;
        }
    }

    @Override
    public LoggingConfiguration getLoggingConfig() throws ConfigurationException {
        return LogbackConfigurationHelper.getLoggingConfiguration(this.appDataPath);
    }

    @Override
    public void saveLoggingConfiguration(LoggingConfiguration config) throws ConfigurationException {
        LogbackConfigurationHelper.updateLoggingConfiguration(this.appDataPath, config);
    }

    @Override
    public void updateMailProperties(MailProperties properties) {
        this.mailMgr.updateMailProperties(properties);
    }

    @Override
    public MailProperties getMailProperties() {
        return this.mailMgr.getMailProperties();
    }

    @Override
    public void submitMessage(String subject, String body, List<String> recipients) {
        this.mailMgr.submitMessage(subject, body, recipients);
    }

    @Override
    public void sendTestMail(MailProperties properties, String recipient, String messageSubject, String messageBody) {
        this.mailMgr.sendTestMail(properties, recipient, messageSubject, messageBody);
    }

    @Override
    public void addEmailEventListener(IEmailEventListener<NoticeBean> listener) {
        this.mailMgr.addEmailEventListener(listener);
    }

    @Override
    public void removeEmailListener(IEmailEventListener<NoticeBean> listener) {
        this.mailMgr.removeEmailListener(listener);
    }

    @Override
    public void startSimulatedFailover(String subnetName) {
        this.adapter.startSimulatedFailover(subnetName);
    }

    private ConfigurationException getConfigException(STLMessages msg, Exception e, Object ... arguments) {
        ConfigurationException ce = new ConfigurationException(msg, (Throwable)e, arguments);
        log.error(StringUtils.getErrorMessage(ce), (Throwable)e);
        return ce;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public boolean isSmtpSettingsValid() {
        return this.mailMgr.isSmtpSettingsValid();
    }

    @Override
    public boolean isEmailValid(String email) {
        return this.mailMgr.isEmailValid(email);
    }
}

