/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.configuration.impl;

import com.intel.stl.api.StringUtils;
import com.intel.stl.api.configuration.ConfigurationException;
import com.intel.stl.api.configuration.ConsoleAppender;
import com.intel.stl.api.configuration.ILogConfigFactory;
import com.intel.stl.api.configuration.LoggingThreshold;
import com.intel.stl.api.configuration.RollingFileAppender;
import com.intel.stl.api.configuration.impl.SupportedAppenderType;
import com.intel.stl.common.STLMessages;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LogbackConfigFactory
implements ILogConfigFactory {
    private static Logger log = LoggerFactory.getLogger(LogbackConfigFactory.class);
    protected static DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    protected static XPathFactory xPathFactory = XPathFactory.newInstance();
    protected static TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private static final String XPATH_ALL_APPENDERS = "/configuration/appender";
    private static final String XPATH_ROOT_LOG = "configuration/root";
    private static final String XPATH_ROOT_LOG_LEVEL = "level";
    private static final String XML_APPENDER = "appender";
    private static final String XPATH_APPENDER_PATTERN = "encoder/pattern";
    private static final String XPATH_APPENDER_LEVEL = "filter/level";
    private static final String XPATH_FILEAPPENDER_FILE = "File";
    private static final String XPATH_FILEAPPENDER_MAXFILESIZE = "triggeringPolicy/MaxFileSize";
    private static final String XPATH_FILEAPPENDER_MAXINDEX = "rollingPolicy/maxIndex";
    private static final String XPATH_FILEAPPENDER_NAMEPATTERN = "rollingPolicy/FileNamePattern";
    private static final String XPATH_ALL_LOGGERS = "/configuration/logger";
    private static final String LOGBACK_FILTER_CLASS = "ch.qos.logback.classic.filter.ThresholdFilter";
    private static final String LOGBACK_ROLLINGPOLICY_CLASS = "ch.qos.logback.core.rolling.FixedWindowRollingPolicy";
    private static final String LOGBACK_TRIGGERINGPOLICY_CLASS = "ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy";
    private static final String LOGDIR_SYS_PROP = "${fmgui.logs.dir}";
    private final XPath xPath;
    private final File configFile;
    private Document config;

    public LogbackConfigFactory(File configFile) {
        this.configFile = configFile;
        this.xPath = xPathFactory.newXPath();
    }

    @Override
    public Document getConfig() {
        if (this.config == null) {
            try {
                DocumentBuilder db = documentBuilderFactory.newDocumentBuilder();
                this.config = db.parse(this.configFile);
            }
            catch (Exception e) {
                ConfigurationException ce = new ConfigurationException(STLMessages.STL50001_ERROR_PARSING_LOGGING_CONFIG, StringUtils.getErrorMessage(e));
                log.error(ce.getMessage(), (Throwable)e);
                throw ce;
            }
        }
        return this.config;
    }

    @Override
    public NodeList getAppenders() {
        Document config = this.getConfig();
        try {
            return (NodeList)this.xPath.evaluate(XPATH_ALL_APPENDERS, config, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            ConfigurationException ce = new ConfigurationException(STLMessages.STL50011_INVALID_XPATH_EXPRESSION, XPATH_ALL_APPENDERS);
            log.error(ce.getMessage(), (Throwable)e);
            throw ce;
        }
    }

    @Override
    public NodeList getLoggers() {
        Document config = this.getConfig();
        try {
            return (NodeList)this.xPath.evaluate(XPATH_ALL_LOGGERS, config, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            ConfigurationException ce = new ConfigurationException(STLMessages.STL50011_INVALID_XPATH_EXPRESSION, XPATH_ALL_LOGGERS);
            log.error(ce.getMessage(), (Throwable)e);
            throw ce;
        }
    }

    @Override
    public Node getRootLogLevel() {
        Document config = this.getConfig();
        try {
            Node rootNode = (Node)this.xPath.evaluate(XPATH_ROOT_LOG, config, XPathConstants.NODE);
            return rootNode.getAttributes().getNamedItem(XPATH_ROOT_LOG_LEVEL);
        }
        catch (XPathExpressionException e) {
            ConfigurationException ce = new ConfigurationException(STLMessages.STL50011_INVALID_XPATH_EXPRESSION, XPATH_ROOT_LOG);
            log.error(ce.getMessage(), (Throwable)e);
            throw ce;
        }
    }

    @Override
    public void setRootLogLevel(String value) {
        Document config = this.getConfig();
        try {
            Node rootNode = (Node)this.xPath.evaluate(XPATH_ROOT_LOG, config, XPathConstants.NODE);
            rootNode.setNodeValue(value);
            rootNode.getAttributes().getNamedItem(XPATH_ROOT_LOG_LEVEL).setNodeValue(value);
        }
        catch (XPathExpressionException e) {
            ConfigurationException ce = new ConfigurationException(STLMessages.STL50011_INVALID_XPATH_EXPRESSION, XPATH_ROOT_LOG);
            log.error(ce.getMessage(), (Throwable)e);
            throw ce;
        }
    }

    @Override
    public void saveConfig(File configFile) {
        Document config = this.getConfig();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(config);
            StreamResult result = new StreamResult(configFile);
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateNode(Node node, ConsoleAppender appender) {
        Element element = this.getElement(node);
        this.setLoggingThreshold(element, appender.getThreshold());
        this.setConversionPattern(element, appender.getConversionPattern());
    }

    @Override
    public void updateNode(Node node, RollingFileAppender appender) {
        Element element = this.getElement(node);
        LoggingThreshold threshold = appender.getThreshold();
        if (threshold != null) {
            this.setLoggingThreshold(element, appender.getThreshold());
        }
        this.setConversionPattern(element, appender.getConversionPattern());
        this.setFileLocation(element, appender.getFileLocation());
        this.setFileNamePattern(element, appender.getFileNamePattern());
        this.setMaxFileSize(element, appender.getMaxFileSize());
        this.setMaxNumOfBackup(element, appender.getMaxNumOfBackUp());
    }

    @Override
    public Node createNode(ConsoleAppender appender) {
        Document document = this.getConfig();
        Element newElement = this.createAppenderNode(document, appender.getName(), SupportedAppenderType.CONSOLE_APPENDER);
        Element pattern = this.createPatternNode(document, appender.getConversionPattern());
        Element level = this.createLevelNode(document, appender.getThreshold());
        newElement.appendChild(pattern);
        newElement.appendChild(level);
        return newElement;
    }

    @Override
    public Node createNode(RollingFileAppender appender) {
        Document document = this.getConfig();
        Element newElement = this.createAppenderNode(document, appender.getName(), SupportedAppenderType.ROLLINGFILE_APPENDER);
        Element file = this.createFileNode(document, appender.getFileLocation());
        Element pattern = this.createPatternNode(document, appender.getConversionPattern());
        Element level = this.createLevelNode(document, appender.getThreshold());
        Element maxIndex = this.createMaxIndexNode(document, appender.getMaxNumOfBackUp(), appender.getFileNamePattern());
        Element maxFileSize = this.createMaxFileSizeNode(document, appender.getMaxFileSize());
        newElement.appendChild(file);
        newElement.appendChild(pattern);
        newElement.appendChild(level);
        newElement.appendChild(maxIndex);
        newElement.appendChild(maxFileSize);
        return newElement;
    }

    @Override
    public void populateFromNode(Node node, ConsoleAppender appender) {
        Element element = this.getElement(node);
        appender.setName(this.getName(element));
        appender.setThreshold(this.getLoggingThreshold(element));
        appender.setConversionPattern(this.getConversionPattern(element));
    }

    @Override
    public void populateFomNode(Node node, RollingFileAppender appender) {
        Element element = this.getElement(node);
        appender.setName(this.getName(element));
        appender.setThreshold(this.getLoggingThreshold(element));
        appender.setConversionPattern(this.getConversionPattern(element));
        appender.setFileLocation(this.getFileLocation(element));
        appender.setFileNamePattern(this.getFileNamePatern(element));
        appender.setMaxFileSize(this.getMaxFileSize(element));
        appender.setMaxNumOfBackUp(this.getMaxNumOfBackup(element));
    }

    private Element createAppenderNode(Document document, String name, SupportedAppenderType type) {
        Element appenderNode = document.createElement(XML_APPENDER);
        appenderNode.setAttribute("name", name);
        appenderNode.setAttribute("class", type.getAppenderClass());
        return appenderNode;
    }

    private Element createPatternNode(Document document, String pattern) {
        Element encoderNode = document.createElement("encoder");
        Element patternNode = document.createElement("pattern");
        patternNode.setTextContent(pattern);
        encoderNode.appendChild(patternNode);
        return encoderNode;
    }

    private Element createLevelNode(Document document, LoggingThreshold threshold) {
        Element filterNode = document.createElement("filter");
        filterNode.setAttribute("class", LOGBACK_FILTER_CLASS);
        Element levelNode = document.createElement(XPATH_ROOT_LOG_LEVEL);
        levelNode.setTextContent(threshold.name());
        filterNode.appendChild(levelNode);
        return filterNode;
    }

    private Element createFileNode(Document document, String fileLocation) {
        Element fileNode = document.createElement(XPATH_FILEAPPENDER_FILE);
        fileNode.setTextContent(fileLocation);
        return fileNode;
    }

    private Element createMaxIndexNode(Document document, String maxIndex, String fileNamePattern) {
        Element policyNode = document.createElement("rollingPolicy");
        policyNode.setAttribute("class", LOGBACK_ROLLINGPOLICY_CLASS);
        Element maxIndexNode = document.createElement("maxIndex");
        maxIndexNode.setTextContent(new Integer(maxIndex).toString());
        Element namePatternNode = document.createElement("FileNamePattern");
        namePatternNode.setTextContent(fileNamePattern);
        policyNode.appendChild(maxIndexNode);
        policyNode.appendChild(namePatternNode);
        return policyNode;
    }

    private Element createMaxFileSizeNode(Document document, String maxFileSize) {
        Element policyNode = document.createElement("triggeringPolicy");
        policyNode.setAttribute("class", LOGBACK_TRIGGERINGPOLICY_CLASS);
        Element maxFileSizeNode = document.createElement("MaxFileSize");
        maxFileSizeNode.setTextContent(maxFileSize);
        policyNode.appendChild(maxFileSizeNode);
        return policyNode;
    }

    private Element getElement(Node node) {
        Element element = (Element)node;
        if (!XML_APPENDER.equals(element.getTagName())) {
            RuntimeException rte = new RuntimeException("Invalid node");
            throw rte;
        }
        return element;
    }

    private String getName(Element appenderElement) {
        return appenderElement.getAttribute("name");
    }

    private String getConversionPattern(Element appenderElement) {
        Element pattern = this.getPatternElement(appenderElement);
        return pattern.getTextContent();
    }

    private void setConversionPattern(Element appenderElement, String conversionPattern) {
        Element pattern = this.getPatternElement(appenderElement);
        pattern.setTextContent(conversionPattern);
    }

    private LoggingThreshold getLoggingThreshold(Element appenderElement) {
        Element level = this.getLevelElement(appenderElement);
        if (level == null) {
            return null;
        }
        String strLevel = level.getTextContent();
        return LoggingThreshold.valueOf(strLevel);
    }

    private void setLoggingThreshold(Element appenderElement, LoggingThreshold threshold) {
        Element level = this.getLevelElement(appenderElement);
        level.setTextContent(threshold.name());
    }

    private String getFileLocation(Element appenderElement) {
        Element file = this.getFileElement(appenderElement);
        return file.getTextContent();
    }

    private void setFileLocation(Element appenderElement, String fileLocation) {
        String logDir = System.getProperty("fmgui.logs.dir");
        Element file = this.getFileElement(appenderElement);
        if (fileLocation.startsWith(logDir)) {
            File logFile = new File(fileLocation);
            String fileName = logFile.getName();
            String logFileLocation = "${fmgui.logs.dir}/" + fileName;
            file.setTextContent(logFileLocation);
        } else {
            file.setTextContent(fileLocation);
        }
    }

    private String getFileNamePatern(Element appenderElement) {
        Element namePattern = this.getFileNamePatternElement(appenderElement);
        return namePattern.getTextContent();
    }

    private void setFileNamePattern(Element appenderElement, String fileNamePattern) {
        Element namePattern = this.getFileNamePatternElement(appenderElement);
        namePattern.setTextContent(fileNamePattern);
    }

    private String getMaxFileSize(Element appenderElement) {
        Element maxFileSize = this.getMaxFileSizeElement(appenderElement);
        return maxFileSize.getTextContent();
    }

    private void setMaxFileSize(Element appenderElement, String maxFileSize) {
        Element maxFileSizeEle = this.getMaxFileSizeElement(appenderElement);
        maxFileSizeEle.setTextContent(maxFileSize);
    }

    private String getMaxNumOfBackup(Element appenderElement) {
        Element maxNumBackups = this.getMaxIndexElement(appenderElement);
        return maxNumBackups.getTextContent();
    }

    private void setMaxNumOfBackup(Element appenderElement, String maxNumOfBackup) {
        Element maxIndex = this.getMaxIndexElement(appenderElement);
        maxIndex.setTextContent(maxNumOfBackup);
    }

    private Element getPatternElement(Element appenderElement) {
        try {
            return (Element)this.xPath.evaluate(XPATH_APPENDER_PATTERN, appenderElement, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            ConfigurationException ce = new ConfigurationException(STLMessages.STL50011_INVALID_XPATH_EXPRESSION, XPATH_APPENDER_PATTERN);
            log.error(ce.getMessage(), (Throwable)e);
            throw ce;
        }
    }

    private Element getLevelElement(Element appenderElement) {
        try {
            return (Element)this.xPath.evaluate(XPATH_APPENDER_LEVEL, appenderElement, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            ConfigurationException ce = new ConfigurationException(STLMessages.STL50011_INVALID_XPATH_EXPRESSION, XPATH_APPENDER_LEVEL);
            log.error(ce.getMessage(), (Throwable)e);
            throw ce;
        }
    }

    private Element getFileElement(Element appenderElement) {
        try {
            return (Element)this.xPath.evaluate(XPATH_FILEAPPENDER_FILE, appenderElement, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            ConfigurationException ce = new ConfigurationException(STLMessages.STL50011_INVALID_XPATH_EXPRESSION, XPATH_FILEAPPENDER_FILE);
            log.error(ce.getMessage(), (Throwable)e);
            throw ce;
        }
    }

    private Element getFileNamePatternElement(Element appenderElement) {
        try {
            return (Element)this.xPath.evaluate(XPATH_FILEAPPENDER_NAMEPATTERN, appenderElement, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            ConfigurationException ce = new ConfigurationException(STLMessages.STL50011_INVALID_XPATH_EXPRESSION, XPATH_FILEAPPENDER_NAMEPATTERN);
            log.error(ce.getMessage(), (Throwable)e);
            throw ce;
        }
    }

    private Element getMaxFileSizeElement(Element appenderElement) {
        try {
            return (Element)this.xPath.evaluate(XPATH_FILEAPPENDER_MAXFILESIZE, appenderElement, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            ConfigurationException ce = new ConfigurationException(STLMessages.STL50011_INVALID_XPATH_EXPRESSION, XPATH_FILEAPPENDER_MAXFILESIZE);
            log.error(ce.getMessage(), (Throwable)e);
            throw ce;
        }
    }

    private Element getMaxIndexElement(Element appenderElement) {
        try {
            return (Element)this.xPath.evaluate(XPATH_FILEAPPENDER_MAXINDEX, appenderElement, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            ConfigurationException ce = new ConfigurationException(STLMessages.STL50011_INVALID_XPATH_EXPRESSION, XPATH_FILEAPPENDER_MAXINDEX);
            log.error(ce.getMessage(), (Throwable)e);
            throw ce;
        }
    }
}

