/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.configuration.impl;

import com.intel.stl.api.StringUtils;
import com.intel.stl.api.configuration.AppenderConfig;
import com.intel.stl.api.configuration.ConfigurationException;
import com.intel.stl.api.configuration.ConsoleAppender;
import com.intel.stl.api.configuration.LoggerConfig;
import com.intel.stl.api.configuration.LoggingConfiguration;
import com.intel.stl.api.configuration.LoggingThreshold;
import com.intel.stl.api.configuration.RollingFileAppender;
import com.intel.stl.api.configuration.impl.LogbackConfigFactory;
import com.intel.stl.api.configuration.impl.SupportedAppenderType;
import com.intel.stl.common.AppDataUtils;
import com.intel.stl.common.STLMessages;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LogbackConfigurationHelper {
    private static Logger log = LoggerFactory.getLogger(LogbackConfigurationHelper.class);
    private static final String FMGUI_APPENDER = "RollingFile-1";
    private static final String LOGDIR_SYS_PROP = "${fmgui.logs.dir}";
    protected static String logbackConfigFileName = "logconfig.xml";
    protected static String LOGCONFIG_TEMP_XML = "logconfignew.xml";
    private static final Set<String> internalLogs;

    public static LoggingConfiguration getLoggingConfiguration(String appDataPath) {
        String logConfigurationFilePath = appDataPath + File.separatorChar + logbackConfigFileName;
        File configFile = LogbackConfigurationHelper.getConfigFile(logConfigurationFilePath);
        return LogbackConfigurationHelper.getLoggingConfiguration(configFile);
    }

    public static void updateLoggingConfiguration(String appDataPath, LoggingConfiguration config) {
        String logConfigurationFilePath = appDataPath + File.separatorChar + logbackConfigFileName;
        File configFile = LogbackConfigurationHelper.getConfigFile(logConfigurationFilePath);
        LogbackConfigurationHelper.saveLoggingConfiguration(config, configFile, appDataPath);
    }

    public static LoggingConfiguration getLoggingConfiguration(File logConfig) {
        Element e;
        int i;
        LoggingConfiguration loggingConfig = new LoggingConfiguration();
        ArrayList<AppenderConfig> appenders = new ArrayList<AppenderConfig>();
        ArrayList<LoggerConfig> loggers = new ArrayList<LoggerConfig>();
        LogbackConfigFactory factory = new LogbackConfigFactory(logConfig);
        Node node = factory.getRootLogLevel();
        LoggingThreshold rootLogLevel = LoggingThreshold.valueOf(node.getNodeValue());
        LoggerConfig rootLogger = new LoggerConfig("Root", rootLogLevel);
        loggingConfig.setRootLogger(rootLogger);
        NodeList nodes = factory.getAppenders();
        for (i = 0; i < nodes.getLength(); ++i) {
            e = (Element)nodes.item(i);
            String appenderName = e.getAttribute("name");
            if (internalLogs.contains(appenderName)) continue;
            String appenderClass = e.getAttribute("class");
            SupportedAppenderType type = SupportedAppenderType.getSupportedAppenderTypeFor(appenderClass);
            if (type == null) {
                log.error(STLMessages.STL50004_UNSUPPORTED_APPENDER_TYPE.getDescription(appenderClass), (Object)e);
                continue;
            }
            AppenderConfig appender = null;
            switch (type) {
                case CONSOLE_APPENDER: {
                    ConsoleAppender consoleAppender = new ConsoleAppender();
                    consoleAppender.populateFromNode(e, factory);
                    appender = consoleAppender;
                    break;
                }
                case ROLLINGFILE_APPENDER: {
                    RollingFileAppender fileAppender = new RollingFileAppender();
                    fileAppender.populateFromNode(e, factory);
                    LogbackConfigurationHelper.resetFileLocationIfNeeded(fileAppender);
                    appender = fileAppender;
                    break;
                }
            }
            appenders.add(appender);
        }
        loggingConfig.setAppenders(appenders);
        nodes = factory.getLoggers();
        for (i = 0; i < nodes.getLength(); ++i) {
            e = (Element)nodes.item(i);
            String loggerName = e.getAttribute("name");
            String loggerLevel = e.getAttribute("level");
            LoggerConfig logger = new LoggerConfig(loggerName, LoggingThreshold.valueOf(loggerLevel));
            loggers.add(logger);
        }
        loggingConfig.setLoggers(loggers);
        return loggingConfig;
    }

    public static void saveLoggingConfiguration(LoggingConfiguration config, File logConfig, String appDataPath) {
        LogbackConfigFactory factory = new LogbackConfigFactory(logConfig);
        LogbackConfigurationHelper.updateDocument(factory, config, appDataPath);
        String parentFolder = logConfig.getParent();
        String tempLogConfig = parentFolder + File.separatorChar + LOGCONFIG_TEMP_XML;
        File tempFile = new File(tempLogConfig);
        factory.saveConfig(tempFile);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd_HH-mm-SS");
        Date now = new Date();
        String reName = "logconfig.xml." + formatter.format(now);
        String logConfigBackup = parentFolder + File.separatorChar + reName;
        File backupFile = new File(logConfigBackup);
        try {
            boolean renameOK = logConfig.renameTo(backupFile);
            renameOK = tempFile.renameTo(logConfig);
        }
        catch (SecurityException se) {
            ConfigurationException ce = new ConfigurationException(STLMessages.STL50005_ERROR_UPDATING_LOGGING_CONFIG, (Throwable)se, new Object[]{StringUtils.getErrorMessage(se)});
            log.error(StringUtils.getErrorMessage(ce), (Throwable)se);
            throw ce;
        }
    }

    protected static void updateDocument(LogbackConfigFactory factory, LoggingConfiguration config, String appDataPath) {
        String appenderName;
        if (config == null) {
            return;
        }
        NodeList nodes = factory.getAppenders();
        HashMap<String, AppenderConfig> appenders = new HashMap<String, AppenderConfig>();
        for (AppenderConfig appender : config.getAppenders()) {
            appenderName = appender.getName();
            appenders.put(appenderName, appender);
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e = (Element)nodes.item(i);
            appenderName = e.getAttribute("name");
            if (!FMGUI_APPENDER.equals(appenderName)) continue;
            AppenderConfig appender = (AppenderConfig)appenders.get(appenderName);
            if (appender == null) break;
            LogbackConfigurationHelper.resetLogDir((RollingFileAppender)appender, appDataPath);
            factory.setRootLogLevel(config.getRootLogger().getLevel().name());
            break;
        }
        Element lastUserAppender = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e = (Element)nodes.item(i);
            String appenderName2 = e.getAttribute("name");
            if (internalLogs.contains(appenderName2)) continue;
            lastUserAppender = e;
            AppenderConfig appender = (AppenderConfig)appenders.get(appenderName2);
            if (appender == null) {
                Node parent = e.getParentNode();
                parent.removeChild(e);
                log.info("Removing appender '" + appenderName2 + "' from logging configuration.");
                continue;
            }
            appender.updateNode(e, factory);
            appenders.remove(appenderName2);
        }
        if (appenders.size() > 0 && lastUserAppender != null) {
            for (String name : appenders.keySet()) {
                AppenderConfig newAppender = (AppenderConfig)appenders.get(name);
                Node newElement = newAppender.createNode(factory);
                lastUserAppender.getParentNode().insertBefore(newElement, lastUserAppender.getNextSibling());
            }
        }
    }

    private static void resetFileLocationIfNeeded(RollingFileAppender appender) {
        String namePattern;
        String location = appender.getFileLocation();
        String logDir = System.getProperty("fmgui.logs.dir");
        if (location != null && location.contains(LOGDIR_SYS_PROP)) {
            location = location.replace(LOGDIR_SYS_PROP, logDir);
            location = location.replace("/", File.separator);
            appender.setFileLocation(location);
        }
        if ((namePattern = appender.getFileNamePattern()) != null && namePattern.contains(LOGDIR_SYS_PROP)) {
            namePattern = namePattern.replace(LOGDIR_SYS_PROP, logDir);
            namePattern = namePattern.replace("/", File.separator);
            appender.setFileNamePattern(namePattern);
        }
    }

    private static void resetLogDir(RollingFileAppender appender, String appDataPath) {
        File logFile = new File(appender.getFileLocation());
        String logDir = System.getProperty("fmgui.logs.dir");
        String filePath = logFile.getParent();
        if (!filePath.equals(logDir)) {
            try {
                Properties customSettings = AppDataUtils.getCustomSettings(appDataPath);
                customSettings.put("app.log.folder", filePath);
                AppDataUtils.saveCustomSettings(customSettings, appDataPath);
                System.setProperty("fmgui.logs.dir", filePath.replace(File.separator, "/"));
            }
            catch (Exception e) {
                ConfigurationException ce = new ConfigurationException(STLMessages.STL50007_ERROR_UPDATING_CUSTOMSETTINGS, (Throwable)e, new Object[]{StringUtils.getErrorMessage(e)});
                log.error(StringUtils.getErrorMessage(ce), (Throwable)e);
                throw ce;
            }
        }
    }

    private static File getConfigFile(String configFilePath) {
        File configFile = new File(configFilePath);
        if (!configFile.exists()) {
            ConfigurationException ce = new ConfigurationException(STLMessages.STL50002_ERROR_READING_LOG4JPROPERTIES, 0, "File not found");
            log.error(StringUtils.getErrorMessage(ce));
            throw ce;
        }
        return configFile;
    }

    public static void setLogbackConfigFileName(String logbackConfigFileName) {
        LogbackConfigurationHelper.logbackConfigFileName = logbackConfigFileName;
    }

    static {
        HashSet<String> logs = new HashSet<String>();
        logs.add("HibernateSql");
        logs.add("DbMgr");
        logs.add("FecDriver");
        internalLogs = Collections.unmodifiableSet(logs);
    }
}

