/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.configuration.impl;

import com.intel.stl.api.ISubnetEventListener;
import com.intel.stl.api.SubnetContext;
import com.intel.stl.api.SubnetEvent;
import com.intel.stl.api.configuration.IConfigurationApi;
import com.intel.stl.api.configuration.UserNotFoundException;
import com.intel.stl.api.configuration.UserSettings;
import com.intel.stl.api.configuration.impl.AppContextImpl;
import com.intel.stl.api.logs.ILogApi;
import com.intel.stl.api.logs.impl.LogApi;
import com.intel.stl.api.management.IManagementApi;
import com.intel.stl.api.management.impl.ManagementApi;
import com.intel.stl.api.notice.INoticeApi;
import com.intel.stl.api.notice.NoticeBean;
import com.intel.stl.api.notice.NoticeWrapper;
import com.intel.stl.api.notice.impl.NoticeApi;
import com.intel.stl.api.notice.impl.NoticeProcessTask;
import com.intel.stl.api.notice.impl.NoticeSimulator;
import com.intel.stl.api.performance.IPerformanceApi;
import com.intel.stl.api.performance.impl.PerformanceApi;
import com.intel.stl.api.subnet.ISubnetApi;
import com.intel.stl.api.subnet.SMRecordBean;
import com.intel.stl.api.subnet.SubnetConnectionException;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.api.subnet.impl.SubnetApi;
import com.intel.stl.configuration.BaseCache;
import com.intel.stl.configuration.CacheManager;
import com.intel.stl.configuration.CacheManagerImpl;
import com.intel.stl.configuration.ResultHandler;
import com.intel.stl.configuration.SerialProcessingService;
import com.intel.stl.datamanager.DatabaseManager;
import com.intel.stl.fecdriver.ApplicationEvent;
import com.intel.stl.fecdriver.adapter.ISMEventListener;
import com.intel.stl.fecdriver.session.ISession;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubnetContextImpl
implements SubnetContext,
ISMEventListener {
    private static Logger log = LoggerFactory.getLogger(SubnetContextImpl.class);
    public static final String PROGRESS_AMOUNT_PROPERTY = "ProgressAmount";
    public static final String PROGRESS_NOTE_PROPERTY = "ProgressNote";
    private ISubnetApi subnetApi;
    private IPerformanceApi perfApi;
    private IManagementApi managementApi;
    private ILogApi logApi;
    private boolean initialized = false;
    private boolean valid = true;
    private boolean closed = false;
    private boolean deleted = false;
    private Throwable lastError;
    private UserSettings userSettings;
    private ISession session;
    private final List<ISubnetEventListener> subnetEventListeners = new CopyOnWriteArrayList<ISubnetEventListener>();
    private NoticeSimulator simulator;
    private Long randomSeed;
    private final AtomicBoolean topologyUpdateTaskStarted = new AtomicBoolean(false);
    private INoticeApi noticeApi;
    private final CacheManagerImpl cacheMgr;
    private final PropertyChangeSupport failoverProgress;
    private final AppContextImpl appContext;
    private final SubnetDescription subnet;

    public SubnetContextImpl(SubnetDescription subnet, AppContextImpl appContext) {
        this.subnet = subnet;
        this.appContext = appContext;
        this.failoverProgress = new PropertyChangeSupport(this);
        this.cacheMgr = new CacheManagerImpl(this);
    }

    @Override
    public IConfigurationApi getConfigurationApi() {
        return this.appContext.getConfigurationApi();
    }

    @Override
    public ISubnetApi getSubnetApi() {
        return this.subnetApi;
    }

    @Override
    public IPerformanceApi getPerformanceApi() {
        return this.perfApi;
    }

    @Override
    public INoticeApi getNoticeApi() {
        return this.noticeApi;
    }

    @Override
    public ILogApi getLogApi() {
        return this.logApi;
    }

    @Override
    public IManagementApi getManagementApi() {
        return this.managementApi;
    }

    public SerialProcessingService getProcessingService() {
        return this.appContext.getProcessingService();
    }

    public DatabaseManager getDatabaseManager() {
        return this.appContext.getDatabaseManager();
    }

    public CacheManager getCacheManager() {
        return this.cacheMgr;
    }

    public ISession getSession() {
        return this.session;
    }

    @Override
    public String getAppSetting(String settingName, String defaultValue) {
        return this.appContext.getAppSetting(settingName, defaultValue);
    }

    @Override
    public UserSettings getUserSettings(String userName) throws UserNotFoundException {
        if (this.userSettings == null) {
            this.refreshUserSettings(userName);
        }
        return this.userSettings;
    }

    @Override
    public void refreshUserSettings(String userName) throws UserNotFoundException {
        this.userSettings = this.getConfigurationApi().getUserSettings(this.subnet.getName(), userName);
        this.noticeApi.setUserSettings(this.userSettings);
    }

    @Override
    public void setRandom(boolean random) {
        if (random) {
            if (this.simulator == null) {
                this.simulator = new NoticeSimulator(this.cacheMgr);
                if (this.randomSeed != null) {
                    this.simulator.setSeed(this.randomSeed);
                }
            }
            this.simulator.addEventListener(this);
            this.simulator.run();
        } else if (this.simulator != null) {
            this.simulator.removeEventListener(this);
            this.simulator.stop();
        }
    }

    @Override
    public SubnetDescription getSubnetDescription() {
        return this.subnet;
    }

    @Override
    public void addSubnetEventListener(ISubnetEventListener listener) {
        this.subnetEventListeners.add(listener);
    }

    @Override
    public void removeSubnetEventListener(ISubnetEventListener listener) {
        this.subnetEventListeners.remove(listener);
    }

    @Override
    public void addFailoverProgressListener(PropertyChangeListener listener) {
        this.failoverProgress.addPropertyChangeListener(listener);
    }

    @Override
    public void removeFailoverProgressListener(PropertyChangeListener listener) {
        this.failoverProgress.removePropertyChangeListener(listener);
    }

    @Override
    public void cancelFailover() {
        this.session.cancelFailover();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        try {
            PropertyChangeListener[] listeners;
            for (PropertyChangeListener listener : listeners = this.failoverProgress.getPropertyChangeListeners()) {
                this.failoverProgress.removePropertyChangeListener(listener);
            }
            this.subnetEventListeners.clear();
            if (this.userSettings != null && !this.deleted) {
                try {
                    this.getConfigurationApi().saveUserSettings(this.subnet.getName(), this.userSettings);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                this.getConfigurationApi().cleanup();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this.subnetApi.cleanup();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this.perfApi.cleanup();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this.logApi.cleanup();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.managementApi.cleanup();
            }
        }
        finally {
            try {
                if (this.simulator != null) {
                    this.simulator.stop();
                }
                this.noticeApi.cleanup();
            }
            finally {
                if (!this.closed) {
                    this.session.close();
                }
                this.closed = true;
                try {
                    this.cacheMgr.cleanup();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public synchronized void initialize() throws SubnetConnectionException {
        if (this.initialized) {
            return;
        }
        this.session = this.appContext.createSession(this.subnet, this);
        this.cacheMgr.initialize();
        this.submitTopologyUpdateTaskIfNeeded();
        this.subnetApi = new SubnetApi(this);
        this.perfApi = new PerformanceApi(this);
        this.noticeApi = new NoticeApi(this);
        this.managementApi = new ManagementApi(this.subnet);
        this.logApi = new LogApi(this);
        List<SMRecordBean> smList = this.subnetApi.getSMs();
        this.subnet.setSMList(smList);
        this.fireSubnetManagerConnectedEvent();
        this.initialized = true;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public void reset() {
        this.subnetApi.reset();
        this.perfApi.reset();
        this.cacheMgr.reset();
        this.cacheMgr.startTopologyUpdateTask();
    }

    public void onNewEvent(NoticeBean[] notices) {
        for (NoticeBean notice : notices) {
            log.info("Get " + notice);
        }
        this.processNotices(notices);
    }

    @Override
    public void onFailoverStart(ApplicationEvent event) {
        SubnetEvent subnetEvent = new SubnetEvent(this);
        for (ISubnetEventListener listener : this.subnetEventListeners) {
            try {
                listener.onSubnetManagerConnectionLost(subnetEvent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void onFailoverEnd(ApplicationEvent event) {
        Throwable cause = event.getReason();
        SubnetEvent subnetEvent = new SubnetEvent(event.getSource(), cause);
        if (cause == null) {
            for (ISubnetEventListener listener : this.subnetEventListeners) {
                try {
                    listener.onFailoverCompleted(subnetEvent);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.fireSubnetManagerConnectedEvent();
        } else {
            this.valid = false;
            for (ISubnetEventListener listener : this.subnetEventListeners) {
                listener.onFailoverFailed(subnetEvent);
            }
        }
    }

    @Override
    public void onFailoverProgress(ApplicationEvent event) {
        Object obj = event.getSource();
        if (obj instanceof String) {
            String note = (String)obj;
            this.failoverProgress.firePropertyChange(PROGRESS_NOTE_PROPERTY, null, note);
        } else if (obj instanceof Double) {
            Double progress = (Double)obj;
            this.failoverProgress.firePropertyChange(PROGRESS_AMOUNT_PROPERTY, null, progress);
        }
    }

    public Throwable getLastConnectionError() {
        return this.lastError;
    }

    private void fireSubnetManagerConnectedEvent() {
        SubnetEvent subnetEvent = new SubnetEvent(this.subnet);
        for (ISubnetEventListener listener : this.subnetEventListeners) {
            try {
                listener.onSubnetManagerConnected(subnetEvent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void processNotices(NoticeBean[] notices) {
        this.submitTopologyUpdateTaskIfNeeded();
        final NoticeProcessTask noticeProcessTask = new NoticeProcessTask(this.subnet.getName(), this.appContext.getDatabaseManager(), this.cacheMgr);
        this.getProcessingService().submitSerial(noticeProcessTask, new ResultHandler<Future<Boolean>>(){

            @Override
            public void onTaskCompleted(Future<Future<Boolean>> processResult) {
                try {
                    Future<Boolean> dbFuture = processResult.get();
                    if (dbFuture != null) {
                        Boolean topologyChanged = dbFuture.get();
                        if (topologyChanged.booleanValue()) {
                            ((BaseCache)((Object)SubnetContextImpl.this.cacheMgr.acquireNodeCache())).setCacheReady(false);
                            log.info("Topology changed as a result of processing notices");
                        }
                        List<NoticeWrapper> noticeWrappers = noticeProcessTask.getNoticeWrappers();
                        SubnetContextImpl.this.noticeApi.addNewEventDescriptions(noticeWrappers.toArray(new NoticeWrapper[0]));
                    }
                }
                catch (InterruptedException e) {
                    log.error("notice process task was interrupted", (Throwable)e);
                }
                catch (ExecutionException e) {
                    Exception executionException = (Exception)e.getCause();
                    log.error("Exception caught during notice process task", (Throwable)executionException);
                }
                catch (Exception e) {
                    log.error("Exception caught during notice process task", (Throwable)e);
                }
            }
        });
    }

    private void submitTopologyUpdateTaskIfNeeded() {
        if (!this.topologyUpdateTaskStarted.get() && this.topologyUpdateTaskStarted.compareAndSet(false, true)) {
            this.cacheMgr.startTopologyUpdateTask();
        }
    }
}

