/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.failure;

import com.intel.stl.api.failure.FailureType;
import com.intel.stl.api.failure.IFailureEvaluator;

public class BaseFailureEvaluator
implements IFailureEvaluator {
    private Class<?>[] recoverableErros;
    private Class<?>[] unrecoverableErros;

    public void setRecoverableErrors(Class<?> ... recoverableErros) {
        this.recoverableErros = recoverableErros;
    }

    public void setUnrecoverableErrors(Class<?> ... unrecoverableErros) {
        this.unrecoverableErros = unrecoverableErros;
    }

    @Override
    public FailureType getType(Throwable error) {
        if (error == null) {
            return FailureType.IGNORE;
        }
        if (this.hasError(error, this.unrecoverableErros)) {
            return FailureType.UNRECOVERABLE;
        }
        if (this.hasError(error, this.recoverableErros)) {
            return FailureType.RECOVERABLE;
        }
        return FailureType.IGNORE;
    }

    protected boolean hasError(Throwable target, Class<?>[] ref) {
        if (ref == null) {
            return false;
        }
        Class<?> targetKlass = target.getClass();
        for (Class<?> klass : ref) {
            if (klass == null || !klass.isAssignableFrom(targetKlass)) continue;
            return true;
        }
        return false;
    }
}

