/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.logs;

import java.util.HashMap;
import java.util.Map;

public enum LogErrorType {
    LOG_OK(0),
    LOG_FILE_NOT_FOUND(1),
    RESPONSE_TIMEOUT(2),
    SSH_HOST_CONNECT_ERROR(3),
    INVALID_LOG_USER(4),
    SYSLOG_ACCESS_ERROR(5),
    UNEXPECTED_LOGIN_FAILURE(6),
    FILE_ACCESS_DENIED(7),
    EMPTY_LOG_FILE(8),
    INVALID_RESPONSE_FORMAT(9);

    private static final Map<Byte, LogErrorType> logErrorMap;
    private final byte id;

    private LogErrorType(byte id) {
        this.id = id;
    }

    public byte getId() {
        return this.id;
    }

    public static LogErrorType getLogErrorType(byte id) {
        return logErrorMap.get(id);
    }

    static {
        logErrorMap = new HashMap<Byte, LogErrorType>(){
            private static final long serialVersionUID = 1L;
            {
                for (LogErrorType type : LogErrorType.values()) {
                    this.put(type.id, type);
                }
            }
        };
    }
}

