/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.logs;

import com.intel.stl.api.SubnetContext;
import com.intel.stl.api.logs.FMConfigParser;
import com.intel.stl.api.logs.FileInfoBean;
import com.intel.stl.api.logs.ILogErrorListener;
import com.intel.stl.api.logs.ILogPageListener;
import com.intel.stl.api.logs.ILogStateListener;
import com.intel.stl.api.logs.IResponseListener;
import com.intel.stl.api.logs.LogCommandProcessor;
import com.intel.stl.api.logs.LogCommander;
import com.intel.stl.api.logs.LogConfigType;
import com.intel.stl.api.logs.LogErrorType;
import com.intel.stl.api.logs.LogInitBean;
import com.intel.stl.api.logs.LogMessageType;
import com.intel.stl.api.logs.LogResponse;
import com.intel.stl.api.logs.LogStatusTask;
import com.intel.stl.api.management.FMConfHelper;
import com.intel.stl.api.management.IManagementApi;
import com.intel.stl.api.subnet.HostInfo;
import com.intel.stl.api.subnet.SshLoginBean;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.fecdriver.network.ssh.SshKeyType;
import com.intel.stl.fecdriver.network.ssh.impl.JSchSession;
import com.intel.stl.fecdriver.network.ssh.impl.JSchSessionFactory;
import com.jcraft.jsch.JSchException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogHelper
implements IResponseListener,
ILogErrorListener,
ILogPageListener {
    private static final Logger log = LoggerFactory.getLogger(LogHelper.class);
    public final String DEFAULT_LOG_FILE = "/var/log/messages";
    private final boolean DEBUG_LOG = false;
    private final boolean DEBUG_RESPONSE = false;
    private static final int RESPONSE_TIMEOUT = 10000;
    private boolean usingDefaultLogFile = false;
    private final LogHelper helper = this;
    private boolean logRunning = false;
    private ILogStateListener logStateListener;
    private final SubnetDescription subnet;
    private final FMConfHelper fmConfigHelper;
    private final FMConfigParser fmConfigParser;
    private final IManagementApi managementApi;
    private LogStatusTask logStatusTask;
    private LogErrorType errorCode;
    private LogCommandProcessor userCommandProcessor;
    private final LogCommander logCommander;
    private FileInfoBean fileInfo;
    private String logFilePath;
    private JSchSession jschSession;
    private boolean initInProgress;
    private String logHost;
    private LogConfigType configType;

    public LogHelper(SubnetContext subnetContext) {
        this.subnet = subnetContext.getSubnetDescription();
        this.managementApi = subnetContext.getManagementApi();
        this.fmConfigHelper = FMConfHelper.getInstance(this.subnet);
        this.fmConfigParser = new FMConfigParser(this.fmConfigHelper);
        this.fileInfo = new FileInfoBean("/var/log/messages", 0L, 0L, 0L);
        this.logCommander = new LogCommander(this.fileInfo);
        this.logCommander.setPageMonitorListener(this);
    }

    protected synchronized void initializationTask(final LogInitBean logInitBean, final char[] password) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LogHelper.this.initInProgress = true;
                    LogHelper.this.errorCode = LogErrorType.LOG_OK;
                    LogHelper.this.helper.logHost = logInitBean.getLogHost();
                    LogHelper.this.errorCode = LogHelper.this.initializeSsh(logInitBean, password);
                    if (LogHelper.this.errorCode == LogErrorType.LOG_OK) {
                        LogHelper.this.userCommandProcessor = new LogCommandProcessor(LogHelper.this.jschSession, 10000, LogHelper.this.helper.getClass().getSimpleName());
                        LogHelper.this.userCommandProcessor.setResponseListener(LogHelper.this.helper);
                        if (LogHelper.this.configType.equals((Object)LogConfigType.CUSTOM_CONFIG)) {
                            LogHelper.this.helper.logFilePath = logInitBean.getLogFilePath();
                        } else {
                            LogHelper.this.helper.logFilePath = LogHelper.this.initLogFilePath(logInitBean, password);
                        }
                        LogHelper.this.fileInfo.setFileName(LogHelper.this.logFilePath);
                        LogHelper.this.checkForFile();
                    } else {
                        LogHelper.this.logStateListener.onError(LogHelper.this.errorCode, LogHelper.this.logHost);
                    }
                }
                catch (Exception e) {
                    LogHelper.this.logStateListener.onError(LogErrorType.UNEXPECTED_LOGIN_FAILURE, e.getMessage());
                    LogHelper.this.stopLog();
                }
            }
        }).start();
    }

    protected String initLogFilePath(LogInitBean logInitBean, char[] password) {
        try {
            this.logFilePath = this.fmConfigParser.getLogFilePath(password);
            if (this.logFilePath == null) {
                this.logFilePath = "/var/log/messages";
            }
            this.fileInfo.setFileName(this.logFilePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.logFilePath;
    }

    protected void startLogStatusTask(long delay, long timeBetweenExecutions) {
        this.logStatusTask = new LogStatusTask(this.logFilePath, LogMessageType.NUM_LINES, this.jschSession, this.fileInfo);
        this.logStatusTask.setResponseListener(this.helper);
        this.logStatusTask.setErrorListener(this.helper);
        this.logStatusTask.start(delay, timeBetweenExecutions);
    }

    protected void debug(String ... msgs) {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        System.out.print(formatter.format(new Date()) + ": ");
        for (int i = 0; i < msgs.length; ++i) {
            System.out.print(msgs[i]);
            if (i > 0 && i % msgs.length != 0) {
                System.out.print(", ");
                continue;
            }
            System.out.print(" ");
        }
        System.out.println();
    }

    public String getLogFilePath() {
        return this.fileInfo.getFileName();
    }

    public String getDefaultLogFilePath() {
        return "/var/log/messages";
    }

    public long getFileSize() {
        return this.fileInfo.getFileSize();
    }

    protected synchronized String getScriptCmd(LogMessageType msgType, long numLinesRequested) {
        this.logCommander.setFileInfo(this.fileInfo);
        String cmd = this.logCommander.getCommand(msgType, numLinesRequested);
        return cmd;
    }

    public void getNumLines() {
        String cmd = this.getScriptCmd(LogMessageType.NUM_LINES, 0L);
        this.userCommandProcessor.executeCommand(LogMessageType.NUM_LINES, cmd);
    }

    public long getCurrentLine() {
        return this.fileInfo.getCurrentLine();
    }

    public long getTotalLines() {
        return this.fileInfo.getTotalNumLines();
    }

    public void checkForFile() {
        String cmd = this.getScriptCmd(LogMessageType.CHECK_FOR_FILE, 0L);
        this.userCommandProcessor.executeCommand(LogMessageType.CHECK_FOR_FILE, cmd);
    }

    public void checkFileAccess() {
        String cmd = this.getScriptCmd(LogMessageType.CHECK_FILE_ACCESS, 0L);
        this.userCommandProcessor.executeCommand(LogMessageType.CHECK_FILE_ACCESS, cmd);
    }

    public synchronized void schedulePreviousPage(long numLinesRequested) {
        String cmd = this.getScriptCmd(LogMessageType.PREVIOUS_PAGE, numLinesRequested);
        this.userCommandProcessor.executeCommand(LogMessageType.PREVIOUS_PAGE, cmd);
    }

    public synchronized void scheduleNextPage(long numLinesRequested) {
        String cmd = this.getScriptCmd(LogMessageType.NEXT_PAGE, numLinesRequested);
        this.userCommandProcessor.executeCommand(LogMessageType.NEXT_PAGE, cmd);
    }

    public synchronized void scheduleLastLines(long numLinesRequested) {
        String cmd = this.getScriptCmd(LogMessageType.LAST_LINES, numLinesRequested);
        this.userCommandProcessor.executeCommand(LogMessageType.LAST_LINES, cmd);
    }

    public void setLogStateListener(ILogStateListener listener) {
        this.logStateListener = listener;
    }

    public SubnetDescription getSubnetDescription() {
        return this.managementApi.getSubnetDescription();
    }

    protected LogErrorType initializeSsh(LogInitBean logInitBean, char[] password) {
        LogErrorType error = LogErrorType.LOG_OK;
        try {
            HostInfo hostInfo = this.subnet.getCurrentFE();
            SshLoginBean sshLoginBean = new SshLoginBean(this.subnet.getSubnetId(), this.subnet.getName(), logInitBean.getUserName(), logInitBean.getLogHost(), hostInfo.getPort(), this.subnet.getCurrentFE().getCertsDescription());
            SubnetDescription sNet = new SubnetDescription(sshLoginBean);
            this.jschSession = JSchSessionFactory.getSession(sNet, logInitBean.isStrictHostKey(), password, SshKeyType.LOG_KEY.getKey(this.subnet.getSubnetId()));
        }
        catch (JSchException e) {
            error = LogErrorType.SSH_HOST_CONNECT_ERROR;
            log.error(e.getMessage(), (Throwable)e);
        }
        return error;
    }

    public boolean isRunning() {
        return this.logRunning;
    }

    public boolean hasSession(SubnetDescription subnet) {
        boolean connectionStatus = false;
        JSchSession session = JSchSessionFactory.getSessionFromMap(SshKeyType.LOG_KEY.getKey(subnet.getSubnetId()));
        if (session != null) {
            connectionStatus = session.isConnected();
        }
        return connectionStatus;
    }

    protected void onFinish(LogErrorType errorCode, Object ... data) {
        if (errorCode.getId() == LogErrorType.LOG_OK.getId()) {
            this.logRunning = true;
            this.logStateListener.onReady();
            this.startLogStatusTask(0L, 10000L);
        } else {
            this.logRunning = false;
            this.logStateListener.onError(errorCode, data);
            this.stopLog();
        }
    }

    public void startLog(LogInitBean logInitBean, char[] password) {
        if (!this.logRunning) {
            this.debug("Start Log...");
            this.configType = logInitBean.getConfigType();
            this.initializationTask(logInitBean, password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopLog() {
        block14: {
            try {
                if (!this.logRunning) break block14;
                if (this.userCommandProcessor != null) {
                    try {
                        this.userCommandProcessor.stop();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (this.logStatusTask != null) {
                    try {
                        this.logStatusTask.stop();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.debug("Log Stopped...");
            }
            finally {
                try {
                    JSchSessionFactory.closeSession(SshKeyType.LOG_KEY.getKey(this.subnet.getSubnetId()));
                }
                finally {
                    this.logRunning = false;
                }
            }
        }
    }

    @Override
    public synchronized void onResponseReceived(LogResponse response) {
        switch (response.getMsgType()) {
            case CHECK_FOR_FILE: {
                String fileName = response.getEntries().get(0);
                if (!fileName.contains(this.logFilePath)) break;
                this.logStateListener.onResponse(response);
                this.checkFileAccess();
                break;
            }
            case CHECK_FILE_ACCESS: {
                boolean fileAccessible;
                int returnCode = Integer.valueOf(response.getEntries().get(0));
                boolean bl = fileAccessible = returnCode == 0;
                if (fileAccessible) {
                    this.logStateListener.onResponse(response);
                    this.onFinish(this.errorCode, this.logFilePath);
                    break;
                }
                this.onResponseError(LogErrorType.FILE_ACCESS_DENIED, LogMessageType.CHECK_FILE_ACCESS, new Object[0]);
                break;
            }
            case PREVIOUS_PAGE: 
            case NEXT_PAGE: 
            case FILE_SIZE: {
                this.logStateListener.onResponse(response);
                break;
            }
            case NUM_LINES: {
                if (response.getEntries().size() <= 0) break;
                List<String> entries = response.getEntries();
                long fileSize = Long.parseLong(entries.get(0));
                long totalNumLines = Long.parseLong(entries.get(1));
                this.fileInfo.update(fileSize, totalNumLines);
                if (this.initInProgress && totalNumLines > 0L) {
                    this.fileInfo.setCurrentLine(totalNumLines);
                    this.initInProgress = false;
                }
                entries.remove(0);
                this.logStateListener.onResponse(response);
                break;
            }
            case LAST_LINES: {
                if (response.getEntries().size() <= 0) break;
                List<String> entries = response.getEntries();
                long fileSize = Long.parseLong(entries.get(0).split("=")[1]);
                long numNewLines = Long.parseLong(entries.get(1).split("=")[1]);
                long currentTotal = this.fileInfo.getTotalNumLines();
                long totalNumLines = currentTotal + numNewLines;
                this.fileInfo.update(fileSize, totalNumLines);
                this.debugResponse(currentTotal, numNewLines, totalNumLines);
                entries.remove(0);
                entries.set(0, String.valueOf(totalNumLines));
                this.logStateListener.onResponse(response);
                break;
            }
            case EXIT: {
                break;
            }
            case UNKNOWN: {
                break;
            }
        }
    }

    public void debugResponse(long currentTotal, long numLines, long totalNumLines) {
    }

    @Override
    public synchronized void onResponseError(LogErrorType errorCode, LogMessageType msgType, Object ... data) {
        switch (errorCode) {
            case LOG_OK: {
                break;
            }
            case SSH_HOST_CONNECT_ERROR: 
            case INVALID_LOG_USER: 
            case UNEXPECTED_LOGIN_FAILURE: {
                break;
            }
            case LOG_FILE_NOT_FOUND: {
                if (this.configType == LogConfigType.AUTO_CONFIG) {
                    if (this.usingDefaultLogFile) {
                        this.logStateListener.onError(errorCode, this.logFilePath, "/var/log/messages");
                        break;
                    }
                    this.logFilePath = "/var/log/messages";
                    this.fileInfo = new FileInfoBean(this.logFilePath, 0L, 0L, 0L);
                    this.fileInfo.setFileName(this.logFilePath);
                    this.usingDefaultLogFile = true;
                    this.checkForFile();
                    return;
                }
                this.logStateListener.onError(errorCode, this.logFilePath, "N/A");
                break;
            }
            case FILE_ACCESS_DENIED: 
            case EMPTY_LOG_FILE: {
                this.logStateListener.onError(errorCode, this.logFilePath);
                break;
            }
            case SYSLOG_ACCESS_ERROR: {
                this.logStateListener.onError(errorCode, this.logHost);
                break;
            }
            case RESPONSE_TIMEOUT: {
                this.logStateListener.onError(errorCode, this.logHost);
                break;
            }
            case INVALID_RESPONSE_FORMAT: {
                this.logStateListener.onError(errorCode, data);
                break;
            }
        }
        this.stopLog();
    }

    @Override
    public void setFirstPage(boolean b) {
        this.logStateListener.setFirstPage(b);
    }

    @Override
    public void setLastPage(boolean b) {
        this.logStateListener.setLastPage(b);
    }

    @Override
    public void setStartLine(long lineNum) {
        this.logStateListener.setStartLine(lineNum);
    }

    @Override
    public void setEndLine(long lineNum) {
        this.logStateListener.setEndLine(lineNum);
    }
}

