/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.management;

import java.io.File;
import java.util.Date;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLUtils {
    public static Node getNodeByName(Node parent, String name) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public static void writeDoc(Document doc, File file) throws Exception {
        TransformerFactory transformerFactory = SAXTransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(file);
        transformer.transform(source, result);
    }

    public static void appendNode(Document doc, Node parent, Node node) {
        Text txt = doc.createTextNode("\n    ");
        parent.appendChild(txt);
        Comment comment = doc.createComment(" Created by FM GUI @ " + new Date() + " ");
        parent.appendChild(comment);
        doc.adoptNode(node);
        parent.appendChild(node);
        XMLUtils.formatNode(doc, parent, node);
        txt = doc.createTextNode("\n\n  ");
        parent.appendChild(txt);
    }

    public static void removeNode(Document doc, Node parent, Node node, String nodeName) {
        Comment comment = doc.createComment(" '" + nodeName + "' was removed by FM GUI @ " + new Date() + " ");
        parent.insertBefore(comment, node);
        parent.removeChild(node);
    }

    public static void replaceNode(Document doc, Node parent, Node oldNode, Node newNode) {
        Comment comment = doc.createComment(" Updated by FM GUI @ " + new Date() + " ");
        parent.insertBefore(comment, oldNode);
        parent.replaceChild(newNode, oldNode);
        XMLUtils.formatNode(doc, parent, newNode);
    }

    private static void formatNode(Document doc, Node parent, Node node) {
        Text txt = doc.createTextNode("\n    ");
        parent.insertBefore(txt, node);
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            txt = doc.createTextNode("\n      ");
            node.insertBefore(txt, children.item(i));
            ++i;
        }
        txt = doc.createTextNode("\n    ");
        node.appendChild(txt);
    }
}

