/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.management.applications;

import com.intel.stl.api.management.applications.AppSelect;
import com.intel.stl.api.management.applications.AppSelectAdapter;
import com.intel.stl.api.management.applications.IncludeApplication;
import com.intel.stl.api.management.applications.MGID;
import com.intel.stl.api.management.applications.MGIDMasked;
import com.intel.stl.api.management.applications.MGIDRange;
import com.intel.stl.api.management.applications.ServiceID;
import com.intel.stl.api.management.applications.ServiceIDMasked;
import com.intel.stl.api.management.applications.ServiceIDRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="Application")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Application {
    @XmlElement(name="Name")
    private String name;
    @XmlElements(value={@XmlElement(name="ServiceID", type=ServiceID.class), @XmlElement(name="ServiceIDRange", type=ServiceIDRange.class), @XmlElement(name="ServiceIDMasked", type=ServiceIDMasked.class)})
    private List<ServiceID> serviceIDs;
    @XmlElements(value={@XmlElement(name="MGID", type=MGID.class), @XmlElement(name="MGIDRange", type=MGIDRange.class), @XmlElement(name="MGIDMasked", type=MGIDMasked.class)})
    private List<MGID> mgids;
    @XmlElement(name="Select", type=String.class)
    @XmlJavaTypeAdapter(value=AppSelectAdapter.class)
    private List<AppSelect> selects;
    @XmlElement(name="IncludeApplication", type=IncludeApplication.class)
    private List<IncludeApplication> includeApplications;

    public Application() {
    }

    public Application(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addServiceID(ServiceID id) {
        if (id == null) {
            throw new IllegalArgumentException("null ServiceID is not allowed.");
        }
        if (this.serviceIDs == null) {
            this.serviceIDs = new ArrayList<ServiceID>();
        }
        this.serviceIDs.add(id);
    }

    public List<ServiceID> getServiceIDs() {
        return this.serviceIDs;
    }

    public void addMGID(MGID id) {
        if (id == null) {
            throw new IllegalArgumentException("null MGID is not allowed.");
        }
        if (this.mgids == null) {
            this.mgids = new ArrayList<MGID>();
        }
        this.mgids.add(id);
    }

    public List<MGID> getMgids() {
        return this.mgids;
    }

    public void addSelect(AppSelect sel) {
        if (sel == null) {
            throw new IllegalArgumentException("null Select is not allowed.");
        }
        if (this.selects == null) {
            this.selects = new ArrayList<AppSelect>();
        }
        this.selects.add(sel);
    }

    public List<AppSelect> getSelects() {
        return this.selects;
    }

    public void addIncludeApplication(IncludeApplication name) {
        if (name == null) {
            throw new IllegalArgumentException("null IncludedApplication is not allowed.");
        }
        if (name.getValue().equals(this.name)) {
            throw new IllegalArgumentException("Can not reference to itself.");
        }
        if (this.includeApplications == null) {
            this.includeApplications = new ArrayList<IncludeApplication>();
        }
        this.includeApplications.add(name);
    }

    public void addIncludeApplication(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null IncludedApplication is not allowed.");
        }
        if (name.equals(this.name)) {
            throw new IllegalArgumentException("Can not reference to itself.");
        }
        if (this.includeApplications == null) {
            this.includeApplications = new ArrayList<IncludeApplication>();
        }
        this.includeApplications.add(new IncludeApplication(name));
    }

    public void removeIncludeApplication(String name) {
        IncludeApplication ia = new IncludeApplication(name);
        if (this.includeApplications != null) {
            this.includeApplications.remove(ia);
        }
    }

    public void insertIncludeApplication(int index, String name) {
        if (this.includeApplications != null) {
            this.includeApplications.add(index, new IncludeApplication(name));
        }
    }

    public int indexOfIncludeApplication(String name) {
        IncludeApplication ia = new IncludeApplication(name);
        if (this.includeApplications != null) {
            return this.includeApplications.indexOf(ia);
        }
        return -1;
    }

    public boolean doesIncludeApplication(String name) {
        IncludeApplication ia = new IncludeApplication(name);
        if (this.includeApplications != null) {
            return this.includeApplications.contains(ia);
        }
        return false;
    }

    public List<IncludeApplication> getIncludeApplications() {
        if (this.includeApplications == null) {
            return null;
        }
        return Collections.unmodifiableList(this.includeApplications);
    }

    public void clear() {
        if (this.serviceIDs != null) {
            this.serviceIDs.clear();
        }
        if (this.mgids != null) {
            this.mgids.clear();
        }
        if (this.selects != null) {
            this.selects.clear();
        }
        if (this.includeApplications != null) {
            this.includeApplications.clear();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.includeApplications == null ? 0 : this.includeApplications.hashCode());
        result = 31 * result + (this.mgids == null ? 0 : this.mgids.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.selects == null ? 0 : this.selects.hashCode());
        result = 31 * result + (this.serviceIDs == null ? 0 : this.serviceIDs.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Application other = (Application)obj;
        if (this.includeApplications == null ? other.includeApplications != null : !this.includeApplications.equals(other.includeApplications)) {
            return false;
        }
        if (this.mgids == null ? other.mgids != null : !this.mgids.equals(other.mgids)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.selects == null ? other.selects != null : !this.selects.equals(other.selects)) {
            return false;
        }
        return !(this.serviceIDs == null ? other.serviceIDs != null : !this.serviceIDs.equals(other.serviceIDs));
    }

    public Application copy() {
        Application res = new Application(this.name);
        if (this.serviceIDs != null) {
            res.serviceIDs = new ArrayList<ServiceID>(this.serviceIDs.size());
            for (ServiceID sid : this.serviceIDs) {
                res.serviceIDs.add(sid.copy());
            }
        }
        if (this.mgids != null) {
            res.mgids = new ArrayList<MGID>(this.mgids.size());
            for (MGID mgid : this.mgids) {
                res.mgids.add(mgid.copy());
            }
        }
        if (this.selects != null) {
            res.selects = new ArrayList<AppSelect>(this.selects);
        }
        if (this.includeApplications != null) {
            res.includeApplications = new ArrayList<IncludeApplication>(this.includeApplications.size());
            for (IncludeApplication ia : this.includeApplications) {
                res.includeApplications.add(ia.copy());
            }
        }
        return res;
    }

    public String toString() {
        return "Application [name=" + this.name + ", serviceIDs=" + this.serviceIDs + ", mgids=" + this.mgids + ", selects=" + this.selects + ", includeApplications=" + this.includeApplications + "]";
    }
}

