/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.management.applications;

import com.intel.stl.api.StringUtils;
import com.intel.stl.api.Utils;
import com.intel.stl.api.management.applications.MGID;

public class MGIDMasked
extends MGID {
    private static final long serialVersionUID = -2856166700407224171L;
    private long maskLower;
    private long maskUpper;

    public MGIDMasked() {
        this(0L, 0L, 0L, 0L);
    }

    public MGIDMasked(long lower, long upper, long maskLower, long maskUpper) {
        super("MGIDMasked", lower, upper);
        this.maskLower = maskLower;
        this.maskUpper = maskUpper;
    }

    public long getMaskLower() {
        return this.maskLower;
    }

    public long getMaskUpper() {
        return this.maskUpper;
    }

    @Override
    public void setVal(String val) {
        String[] segs = val.split("\\*");
        super.setVal(segs[0]);
        if (segs.length > 0) {
            segs = segs[1].split(":");
            this.maskLower = Utils.toLong(segs[0]);
            if (segs.length > 0) {
                this.maskUpper = Utils.toLong(segs[1]);
            }
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.maskLower ^ this.maskLower >>> 32);
        result = 31 * result + (int)(this.maskUpper ^ this.maskUpper >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MGIDMasked other = (MGIDMasked)obj;
        if (this.maskLower != other.maskLower) {
            return false;
        }
        return this.maskUpper == other.maskUpper;
    }

    @Override
    public MGIDMasked copy() {
        return new MGIDMasked(this.lower, this.upper, this.maskLower, this.maskUpper);
    }

    @Override
    public String toString() {
        return super.toString() + "*" + StringUtils.longHexString(this.maskLower) + ":" + StringUtils.longHexString(this.maskUpper);
    }
}

