/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.management.virtualfabrics;

import com.intel.stl.api.configuration.MTUSize;
import com.intel.stl.api.management.WrapperNode;
import com.intel.stl.api.management.virtualfabrics.VirtualFabric;

public class MaxMtu
extends WrapperNode<MTUSize> {
    private static final long serialVersionUID = 4236692336423150546L;

    public MaxMtu() {
        this(MTUSize.INVALID);
    }

    public MaxMtu(MTUSize value) {
        super("MaxMTU", value);
    }

    @Override
    protected MTUSize valueOf(String str) {
        if (str.equalsIgnoreCase("Unlimited")) {
            return MTUSize.INVALID;
        }
        return MTUSize.getMTUSize(str);
    }

    @Override
    protected String valueString(MTUSize value) {
        if (value == MTUSize.INVALID) {
            return "Unlimited";
        }
        return value.getName();
    }

    @Override
    public MaxMtu copy() {
        return new MaxMtu((MTUSize)((Object)this.value));
    }

    public String toString() {
        return "MaxMtu [type=" + this.type + ", value=" + this.value + "]";
    }

    @Override
    public void installVirtualFabric(VirtualFabric vf) {
        vf.setMaxMtu(this);
    }

    public static MaxMtu[] values() {
        MTUSize[] mtus = MTUSize.values();
        MaxMtu[] res = new MaxMtu[mtus.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = new MaxMtu(mtus[i]);
        }
        return res;
    }
}

