/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.performance;

import com.intel.stl.api.ITimestamped;
import com.intel.stl.api.Utils;
import com.intel.stl.api.performance.ErrBucketBean;
import com.intel.stl.api.performance.ErrStatBean;
import com.intel.stl.api.performance.ErrSummaryBean;
import com.intel.stl.api.performance.ImageIdBean;
import com.intel.stl.api.performance.UtilStatsBean;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class GroupInfoBean
implements ITimestamped,
Serializable {
    private static final long serialVersionUID = 1L;
    private String groupName;
    private ImageIdBean imageId;
    private long timestamp;
    private int imageInterval;
    private long numInternalPorts;
    private long numExternalPorts;
    private UtilStatsBean internalUtilStats;
    private UtilStatsBean sendUtilStats;
    private UtilStatsBean recvUtilStats;
    private ErrSummaryBean internalErrorMaximums;
    private List<ErrBucketBean> internalErrorPorts;
    private ErrSummaryBean externalErrorMaximums;
    private List<ErrBucketBean> externalErrorPorts;
    private byte maxInternalRate;
    private byte minInternalRate;
    private byte maxExternalRate;
    private byte minExternalRate;
    private int maxInternalMBps;
    private int maxExternalMBps;

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        if (groupName.length() > 64) {
            throw new IllegalArgumentException("Invalid string length: " + groupName.length() + " > " + 64);
        }
        this.groupName = groupName;
    }

    public ImageIdBean getImageId() {
        return this.imageId;
    }

    public void setImageId(ImageIdBean imageId) {
        this.imageId = imageId;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(long sweepTimestamp) {
        this.timestamp = sweepTimestamp;
    }

    @Override
    public Date getTimestampDate() {
        return Utils.convertFromUnixTime(this.timestamp);
    }

    @Override
    public int getImageInterval() {
        return this.imageInterval;
    }

    @Override
    public void setImageInterval(int imageInterval) {
        this.imageInterval = imageInterval;
    }

    public long getNumInternalPorts() {
        return this.numInternalPorts;
    }

    public void setNumInternalPorts(long numInternalPorts) {
        this.numInternalPorts = numInternalPorts;
    }

    public void setNumInternalPorts(int numInternalPorts) {
        this.numInternalPorts = Utils.unsignedInt(numInternalPorts);
    }

    public long getNumExternalPorts() {
        return this.numExternalPorts;
    }

    public void setNumExternalPorts(long numExternalPorts) {
        this.numExternalPorts = numExternalPorts;
    }

    public void setNumExternalPorts(int numExternalPorts) {
        this.numExternalPorts = Utils.unsignedInt(numExternalPorts);
    }

    public UtilStatsBean getInternalUtilStats() {
        return this.internalUtilStats;
    }

    public void setInternalUtilStats(UtilStatsBean internalUtilStats) {
        this.internalUtilStats = internalUtilStats;
    }

    public UtilStatsBean getSendUtilStats() {
        return this.sendUtilStats;
    }

    public void setSendUtilStats(UtilStatsBean sendUtilStats) {
        this.sendUtilStats = sendUtilStats;
    }

    public UtilStatsBean getRecvUtilStats() {
        return this.recvUtilStats;
    }

    public void setRecvUtilStats(UtilStatsBean recvUtilStats) {
        this.recvUtilStats = recvUtilStats;
    }

    public ErrStatBean getInternalErrors() {
        ErrStatBean internalErrors = new ErrStatBean();
        internalErrors.setErrorMaximums(this.internalErrorMaximums);
        internalErrors.setPorts(this.getInternalErrorPortsAsArray());
        return internalErrors;
    }

    public void setInternalErrors(ErrStatBean internalErrors) {
        this.internalErrorMaximums = internalErrors.getErrorMaximums();
        this.setInternalErrorPorts(internalErrors.getPorts());
    }

    public ErrSummaryBean getInternalErrorMaximums() {
        return this.internalErrorMaximums;
    }

    public void setInternalErrorMaximums(ErrSummaryBean internalErrorMaximums) {
        this.internalErrorMaximums = internalErrorMaximums;
    }

    public ErrBucketBean[] getInternalErrorPortsAsArray() {
        if (this.internalErrorPorts == null) {
            this.internalErrorPorts = new ArrayList<ErrBucketBean>();
        }
        ErrBucketBean[] ebArray = new ErrBucketBean[this.internalErrorPorts.size()];
        return this.internalErrorPorts.toArray(ebArray);
    }

    public void setInternalErrorPorts(ErrBucketBean[] internalErrorPorts) {
        ArrayList<ErrBucketBean> ebList = new ArrayList<ErrBucketBean>(Arrays.asList(internalErrorPorts));
        this.internalErrorPorts = ebList;
    }

    public List<ErrBucketBean> getInternalErrorPorts() {
        return this.internalErrorPorts;
    }

    public void setInternalErrorPorts(List<ErrBucketBean> internalErrorPorts) {
        this.internalErrorPorts = internalErrorPorts;
    }

    public ErrStatBean getExternalErrors() {
        ErrStatBean externalErrors = new ErrStatBean();
        externalErrors.setErrorMaximums(this.externalErrorMaximums);
        externalErrors.setPorts(this.getExternalErrorPortsAsArray());
        return externalErrors;
    }

    public void setExternalErrors(ErrStatBean externalErrors) {
        this.externalErrorMaximums = externalErrors.getErrorMaximums();
        this.setExternalErrorPorts(externalErrors.getPorts());
    }

    public ErrSummaryBean getExternalErrorMaximums() {
        return this.externalErrorMaximums;
    }

    public void setExternalErrorMaximums(ErrSummaryBean externalErrorMaximums) {
        this.externalErrorMaximums = externalErrorMaximums;
    }

    public ErrBucketBean[] getExternalErrorPortsAsArray() {
        if (this.externalErrorPorts == null) {
            this.externalErrorPorts = new ArrayList<ErrBucketBean>();
        }
        ErrBucketBean[] ebArray = new ErrBucketBean[this.externalErrorPorts.size()];
        return this.externalErrorPorts.toArray(ebArray);
    }

    public void setExternalErrorPorts(ErrBucketBean[] externalErrorPorts) {
        ArrayList<ErrBucketBean> ebList = new ArrayList<ErrBucketBean>(Arrays.asList(externalErrorPorts));
        this.externalErrorPorts = ebList;
    }

    public List<ErrBucketBean> getExternalErrorPorts() {
        return this.externalErrorPorts;
    }

    public void setExternalErrorPorts(List<ErrBucketBean> externalErrorPorts) {
        this.externalErrorPorts = externalErrorPorts;
    }

    public byte getMaxInternalRate() {
        return this.maxInternalRate;
    }

    public void setMaxInternalRate(byte maxInternalRate) {
        this.maxInternalRate = maxInternalRate;
    }

    public byte getMinInternalRate() {
        return this.minInternalRate;
    }

    public void setMinInternalRate(byte minInternalRate) {
        this.minInternalRate = minInternalRate;
    }

    public byte getMaxExternalRate() {
        return this.maxExternalRate;
    }

    public void setMaxExternalRate(byte maxExternalRate) {
        this.maxExternalRate = maxExternalRate;
    }

    public byte getMinExternalRate() {
        return this.minExternalRate;
    }

    public void setMinExternalRate(byte minExternalRate) {
        this.minExternalRate = minExternalRate;
    }

    public int getMaxInternalMBps() {
        return this.maxInternalMBps;
    }

    public void setMaxInternalMBps(int maxInternalMBps) {
        this.maxInternalMBps = maxInternalMBps;
    }

    public int getMaxExternalMBps() {
        return this.maxExternalMBps;
    }

    public void setMaxExternalMBps(int maxExternalMBps) {
        this.maxExternalMBps = maxExternalMBps;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.groupName == null ? 0 : this.groupName.hashCode());
        result = 31 * result + (this.imageId == null ? 0 : this.imageId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupInfoBean other = (GroupInfoBean)obj;
        if (this.groupName == null ? other.groupName != null : !this.groupName.equals(other.groupName)) {
            return false;
        }
        return !(this.imageId == null ? other.imageId != null : !this.imageId.equals(other.imageId));
    }

    public String toString() {
        return "GroupInfoBean [groupName=" + this.groupName + ", imageId=" + this.imageId + ", numInternalPorts=" + this.numInternalPorts + ", numExternalPorts=" + this.numExternalPorts + ", internalUtilStats=" + this.internalUtilStats + ", sendUtilStats=" + this.sendUtilStats + ", recvUtilStats=" + this.recvUtilStats + ", internalErrors=" + this.getInternalErrors() + ", externalErrors=" + this.getExternalErrors() + ", maxInternalRate=" + this.maxInternalRate + ", minInternalRate=" + this.minInternalRate + ", maxExternalRate=" + this.maxExternalRate + ", minExternalRate=" + this.minExternalRate + ", maxInternalMBps=" + this.maxInternalMBps + ", maxExternalMBps=" + this.maxExternalMBps + "]";
    }
}

