/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.performance;

import com.intel.stl.api.ITimestamped;
import com.intel.stl.api.Utils;
import com.intel.stl.api.performance.ImageIdBean;
import com.intel.stl.api.performance.SMInfoDataBean;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;

public class ImageInfoBean
implements ITimestamped,
Serializable {
    private static final long serialVersionUID = 1L;
    private ImageIdBean imageId;
    private long sweepStart;
    private int sweepDuration;
    private int numHFIPorts;
    private int numSwitchNodes;
    private long numSwitchPorts;
    private long numLinks;
    private int numSMs;
    private int numFailedNodes;
    private long numFailedPorts;
    private int numSkippedNodes;
    private long numSkippedPorts;
    private long numUnexpectedClearPorts;
    private int imageInterval;
    private SMInfoDataBean[] SMInfo;

    public ImageIdBean getImageId() {
        return this.imageId;
    }

    public void setImageId(ImageIdBean imageId) {
        this.imageId = imageId;
    }

    public long getSweepStart() {
        return this.sweepStart;
    }

    public Date getSweepStartDate() {
        return Utils.convertFromUnixTime(this.sweepStart);
    }

    public void setSweepStart(long sweepStart) {
        this.sweepStart = sweepStart;
    }

    public int getSweepDuration() {
        return this.sweepDuration;
    }

    public void setSweepDuration(int sweepDuration) {
        this.sweepDuration = sweepDuration;
    }

    public int getNumHFIPorts() {
        return this.numHFIPorts;
    }

    public void setNumHFIPorts(short numHCAPorts) {
        this.numHFIPorts = numHCAPorts & 0xFFFF;
    }

    public int getNumSwitchNodes() {
        return this.numSwitchNodes;
    }

    public void setNumSwitchNodes(short numSwitchNodes) {
        this.numSwitchNodes = numSwitchNodes & 0xFFFF;
    }

    public long getNumSwitchPorts() {
        return this.numSwitchPorts;
    }

    public void setNumSwitchPorts(long numSwitchPorts) {
        this.numSwitchPorts = numSwitchPorts;
    }

    public void setNumSwitchPorts(int numSwitchPorts) {
        this.numSwitchPorts = Utils.unsignedInt(numSwitchPorts);
    }

    public long getNumLinks() {
        return this.numLinks;
    }

    public void setNumLinks(long numLinks) {
        this.numLinks = numLinks;
    }

    public void setNumLinks(int numLinks) {
        this.numLinks = Utils.unsignedInt(numLinks);
    }

    public int getNumSMs() {
        return this.numSMs;
    }

    public void setNumSMs(int numSMs) {
        this.numSMs = numSMs;
    }

    public int getNumFailedNodes() {
        return this.numFailedNodes;
    }

    public void setNumFailedNodes(int numFailedNodes) {
        this.numFailedNodes = numFailedNodes;
    }

    public long getNumFailedPorts() {
        return this.numFailedPorts;
    }

    public void setNumFailedPorts(long numFailedPorts) {
        this.numFailedPorts = numFailedPorts;
    }

    public void setNumFailedPorts(int numFailedPorts) {
        this.numFailedPorts = Utils.unsignedInt(numFailedPorts);
    }

    public int getNumSkippedNodes() {
        return this.numSkippedNodes;
    }

    public void setNumSkippedNodes(int numSkippedNodes) {
        this.numSkippedNodes = numSkippedNodes;
    }

    public long getNumSkippedPorts() {
        return this.numSkippedPorts;
    }

    public void setNumSkippedPorts(long numSkippedPorts) {
        this.numSkippedPorts = numSkippedPorts;
    }

    public void setNumSkippedPorts(int numSkippedPorts) {
        this.numSkippedPorts = Utils.unsignedInt(numSkippedPorts);
    }

    public long getNumUnexpectedClearPorts() {
        return this.numUnexpectedClearPorts;
    }

    public void setNumUnexpectedClearPorts(long numUnexpectedClearPorts) {
        this.numUnexpectedClearPorts = numUnexpectedClearPorts;
    }

    public void setNumUnexpectedClearPorts(int numUnexpectedClearPorts) {
        this.numUnexpectedClearPorts = Utils.unsignedInt(numUnexpectedClearPorts);
    }

    @Override
    public int getImageInterval() {
        return this.imageInterval;
    }

    @Override
    public void setImageInterval(int imageInterval) {
        this.imageInterval = imageInterval;
    }

    public SMInfoDataBean[] getSMInfo() {
        return this.SMInfo;
    }

    public void setSMInfo(SMInfoDataBean[] sMInfo) {
        this.SMInfo = sMInfo;
    }

    @Override
    public void setTimestamp(long timestamp) {
        this.setSweepStart(timestamp);
    }

    @Override
    public long getTimestamp() {
        return this.sweepStart;
    }

    @Override
    public Date getTimestampDate() {
        return Utils.convertFromUnixTime(this.sweepStart);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.imageId == null ? 0 : this.imageId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImageInfoBean other = (ImageInfoBean)obj;
        return !(this.imageId == null ? other.imageId != null : !this.imageId.equals(other.imageId));
    }

    public String toString() {
        return "ImageInfoBean [imageId=" + this.imageId + ", sweepStart=" + this.sweepStart + ", sweepDuration=" + this.sweepDuration + ", numHCAPorts=" + this.numHFIPorts + ", numSwitchNodes=" + this.numSwitchNodes + ", numSwitchPorts=" + this.numSwitchPorts + ", numLinks=" + this.numLinks + ", numSMs=" + this.numSMs + ", numFailedNodes=" + this.numFailedNodes + ", numFailedPorts=" + this.numFailedPorts + ", numSkippedNodes=" + this.numSkippedNodes + ", numSkippedPorts=" + this.numSkippedPorts + ", numUnexpectedClearPorts=" + this.numUnexpectedClearPorts + ", imageInterval=" + this.imageInterval + ", SMInfo=" + Arrays.toString(this.SMInfo) + "]";
    }

    public boolean hasChange(ImageInfoBean other) {
        if (this == other) {
            return false;
        }
        if (other == null) {
            return true;
        }
        if (this.numFailedNodes != other.numFailedNodes) {
            return true;
        }
        if (this.numFailedPorts != other.numFailedPorts) {
            return true;
        }
        if (this.numHFIPorts != other.numHFIPorts) {
            return true;
        }
        if (this.numLinks != other.numLinks) {
            return true;
        }
        if (this.numSMs != other.numSMs) {
            return true;
        }
        if (this.numSkippedNodes != other.numSkippedNodes) {
            return true;
        }
        if (this.numSkippedPorts != other.numSkippedPorts) {
            return true;
        }
        if (this.numSwitchNodes != other.numSwitchNodes) {
            return true;
        }
        if (this.numSwitchPorts != other.numSwitchPorts) {
            return true;
        }
        if (this.numUnexpectedClearPorts != other.numUnexpectedClearPorts) {
            return true;
        }
        return this.imageInterval != other.imageInterval;
    }
}

