/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.performance;

import com.intel.stl.api.ITimestamped;
import com.intel.stl.api.Utils;
import com.intel.stl.api.performance.ImageIdBean;
import java.io.Serializable;
import java.util.Date;

public class PortCountersBean
implements ITimestamped,
Serializable {
    private static final long serialVersionUID = 1L;
    private int nodeLid;
    private short portNumber;
    private int flags;
    private long portXmitData;
    private long portRcvData;
    private long portXmitPkts;
    private long portRcvPkts;
    private long portMulticastXmitPkts;
    private long portMulticastRcvPkts;
    private long localLinkIntegrityErrors;
    private long fmConfigErrors;
    private long portRcvErrors;
    private long excessiveBufferOverruns;
    private long portRcvConstraintErrors;
    private long portRcvSwitchRelayErrors;
    private long portXmitDiscards;
    private long portXmitConstraintErrors;
    private long portRcvRemotePhysicalErrors;
    private long swPortCongestion;
    private long portXmitWait;
    private long portRcvFECN;
    private long portRcvBECN;
    private long portXmitTimeCong;
    private long portXmitWastedBW;
    private long portXmitWaitData;
    private long portRcvBubble;
    private long portMarkFECN;
    private long linkErrorRecovery;
    private long linkDowned;
    private short uncorrectableErrors;
    private byte numLanesDown;
    private byte linkQualityIndicator;
    private ImageIdBean imageId;
    private long timestamp;
    private int imageInterval;

    public int getNodeLid() {
        return this.nodeLid;
    }

    public void setNodeLid(int nodeLid) {
        this.nodeLid = nodeLid;
    }

    public short getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(short portNumber) {
        this.portNumber = portNumber;
    }

    public void setPortNumber(byte portNumber) {
        this.portNumber = Utils.unsignedByte(portNumber);
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public boolean isDelta() {
        return (this.flags & 1) == 1;
    }

    public boolean hasUnexpectedClear() {
        return (this.flags & 2) == 2;
    }

    public long getPortXmitData() {
        return this.portXmitData;
    }

    public void setPortXmitData(long portXmitData) {
        this.portXmitData = portXmitData;
    }

    public long getPortRcvData() {
        return this.portRcvData;
    }

    public void setPortRcvData(long portRcvData) {
        this.portRcvData = portRcvData;
    }

    public long getPortXmitPkts() {
        return this.portXmitPkts;
    }

    public void setPortXmitPkts(long portXmitPkts) {
        this.portXmitPkts = portXmitPkts;
    }

    public long getPortRcvPkts() {
        return this.portRcvPkts;
    }

    public void setPortRcvPkts(long portRcvPkts) {
        this.portRcvPkts = portRcvPkts;
    }

    public long getPortMulticastXmitPkts() {
        return this.portMulticastXmitPkts;
    }

    public void setPortMulticastXmitPkts(long portMulticastXmitPkts) {
        this.portMulticastXmitPkts = portMulticastXmitPkts;
    }

    public long getPortMulticastRcvPkts() {
        return this.portMulticastRcvPkts;
    }

    public void setPortMulticastRcvPkts(long portMulticastRcvPkts) {
        this.portMulticastRcvPkts = portMulticastRcvPkts;
    }

    public long getLocalLinkIntegrityErrors() {
        return this.localLinkIntegrityErrors;
    }

    public void setLocalLinkIntegrityErrors(long localLinkIntegrityErrors) {
        this.localLinkIntegrityErrors = localLinkIntegrityErrors;
    }

    public long getFmConfigErrors() {
        return this.fmConfigErrors;
    }

    public void setFmConfigErrors(long fmConfigErrors) {
        this.fmConfigErrors = fmConfigErrors;
    }

    public long getPortRcvErrors() {
        return this.portRcvErrors;
    }

    public void setPortRcvErrors(long portRcvErrors) {
        this.portRcvErrors = portRcvErrors;
    }

    public long getExcessiveBufferOverruns() {
        return this.excessiveBufferOverruns;
    }

    public void setExcessiveBufferOverruns(long excessiveBufferOverruns) {
        this.excessiveBufferOverruns = excessiveBufferOverruns;
    }

    public long getPortRcvConstraintErrors() {
        return this.portRcvConstraintErrors;
    }

    public void setPortRcvConstraintErrors(long portRcvConstraintErrors) {
        this.portRcvConstraintErrors = portRcvConstraintErrors;
    }

    public long getPortRcvSwitchRelayErrors() {
        return this.portRcvSwitchRelayErrors;
    }

    public void setPortRcvSwitchRelayErrors(long portRcvSwitchRelayErrors) {
        this.portRcvSwitchRelayErrors = portRcvSwitchRelayErrors;
    }

    public long getPortXmitDiscards() {
        return this.portXmitDiscards;
    }

    public void setPortXmitDiscards(long portXmitDiscards) {
        this.portXmitDiscards = portXmitDiscards;
    }

    public long getPortXmitConstraintErrors() {
        return this.portXmitConstraintErrors;
    }

    public void setPortXmitConstraintErrors(long portXmitConstraintErrors) {
        this.portXmitConstraintErrors = portXmitConstraintErrors;
    }

    public long getPortRcvRemotePhysicalErrors() {
        return this.portRcvRemotePhysicalErrors;
    }

    public void setPortRcvRemotePhysicalErrors(long portRcvRemotePhysicalErrors) {
        this.portRcvRemotePhysicalErrors = portRcvRemotePhysicalErrors;
    }

    public long getSwPortCongestion() {
        return this.swPortCongestion;
    }

    public void setSwPortCongestion(long swPortCongestion) {
        this.swPortCongestion = swPortCongestion;
    }

    public long getPortXmitWait() {
        return this.portXmitWait;
    }

    public void setPortXmitWait(long portXmitWait) {
        this.portXmitWait = portXmitWait;
    }

    public long getPortRcvFECN() {
        return this.portRcvFECN;
    }

    public void setPortRcvFECN(long portRcvFECN) {
        this.portRcvFECN = portRcvFECN;
    }

    public long getPortRcvBECN() {
        return this.portRcvBECN;
    }

    public void setPortRcvBECN(long portRcvBECN) {
        this.portRcvBECN = portRcvBECN;
    }

    public long getPortXmitTimeCong() {
        return this.portXmitTimeCong;
    }

    public void setPortXmitTimeCong(long portXmitTimeCong) {
        this.portXmitTimeCong = portXmitTimeCong;
    }

    public long getPortXmitWastedBW() {
        return this.portXmitWastedBW;
    }

    public void setPortXmitWastedBW(long portXmitWastedBW) {
        this.portXmitWastedBW = portXmitWastedBW;
    }

    public long getPortXmitWaitData() {
        return this.portXmitWaitData;
    }

    public void setPortXmitWaitData(long portXmitWaitData) {
        this.portXmitWaitData = portXmitWaitData;
    }

    public long getPortRcvBubble() {
        return this.portRcvBubble;
    }

    public void setPortRcvBubble(long portRcvBubble) {
        this.portRcvBubble = portRcvBubble;
    }

    public long getPortMarkFECN() {
        return this.portMarkFECN;
    }

    public void setPortMarkFECN(long portMarkFECN) {
        this.portMarkFECN = portMarkFECN;
    }

    public long getLinkErrorRecovery() {
        return this.linkErrorRecovery;
    }

    public void setLinkErrorRecovery(long linkErrorRecovery) {
        this.linkErrorRecovery = linkErrorRecovery;
    }

    public void setLinkErrorRecovery(int linkErrorRecovery) {
        this.linkErrorRecovery = Utils.unsignedInt(linkErrorRecovery);
    }

    public long getLinkDowned() {
        return this.linkDowned;
    }

    public void setLinkDowned(long linkDowned) {
        this.linkDowned = linkDowned;
    }

    public void setLinkDowned(int linkDowned) {
        this.linkDowned = Utils.unsignedInt(linkDowned);
    }

    public short getUncorrectableErrors() {
        return this.uncorrectableErrors;
    }

    public void setUncorrectableErrors(short uncorrectableErrors) {
        this.uncorrectableErrors = uncorrectableErrors;
    }

    public void setUncorrectableErrors(byte uncorrectableErrors) {
        this.uncorrectableErrors = Utils.unsignedByte(uncorrectableErrors);
    }

    public byte getNumLanesDown() {
        return this.numLanesDown;
    }

    public void setNumLanesDown(byte numLanesDown) {
        this.numLanesDown = numLanesDown;
    }

    public byte getLinkQualityIndicator() {
        return this.linkQualityIndicator;
    }

    public void setLinkQualityIndicator(byte linkQualityIndicator) {
        this.linkQualityIndicator = linkQualityIndicator;
    }

    public ImageIdBean getImageId() {
        return this.imageId;
    }

    public void setImageId(ImageIdBean imageId) {
        this.imageId = imageId;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(long sweepTimestamp) {
        this.timestamp = sweepTimestamp;
    }

    @Override
    public Date getTimestampDate() {
        return Utils.convertFromUnixTime(this.timestamp);
    }

    @Override
    public int getImageInterval() {
        return this.imageInterval;
    }

    @Override
    public void setImageInterval(int imageInterval) {
        this.imageInterval = imageInterval;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.imageId == null ? 0 : this.imageId.hashCode());
        result = 31 * result + this.nodeLid;
        result = 31 * result + this.portNumber;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PortCountersBean other = (PortCountersBean)obj;
        if (this.imageId == null ? other.imageId != null : !this.imageId.equals(other.imageId)) {
            return false;
        }
        if (this.nodeLid != other.nodeLid) {
            return false;
        }
        return this.portNumber == other.portNumber;
    }

    public String toString() {
        return "PortCountersBean [nodeLid=" + this.nodeLid + ", portNumber=" + this.portNumber + ", flags=" + this.flags + ", portXmitData=" + this.portXmitData + ", portRcvData=" + this.portRcvData + ", portXmitPkts=" + this.portXmitPkts + ", portRcvPkts=" + this.portRcvPkts + ", portMulticastXmitPkts=" + this.portMulticastXmitPkts + ", portMulticastRcvPkts=" + this.portMulticastRcvPkts + ", localLinkIntegrityErrors=" + this.localLinkIntegrityErrors + ", fmConfigErrors=" + this.fmConfigErrors + ", portRcvErrors=" + this.portRcvErrors + ", excessiveBufferOverruns=" + this.excessiveBufferOverruns + ", portRcvConstraintErrors=" + this.portRcvConstraintErrors + ", portRcvSwitchRelayErrors=" + this.portRcvSwitchRelayErrors + ", portXmitDiscards=" + this.portXmitDiscards + ", portXmitConstraintErrors=" + this.portXmitConstraintErrors + ", portRcvRemotePhysicalErrors=" + this.portRcvRemotePhysicalErrors + ", swPortCongestion=" + this.swPortCongestion + ", portXmitWait=" + this.portXmitWait + ", portRecvFECN=" + this.portRcvFECN + ", portRecvBECN=" + this.portRcvBECN + ", portXmitTimeCong=" + this.portXmitTimeCong + ", portXmitWastedBW=" + this.portXmitWastedBW + ", portXmitWaitData=" + this.portXmitWaitData + ", portRcvBubble=" + this.portRcvBubble + ", portMarkFECN=" + this.portMarkFECN + ", linkErrorRecovery=" + this.linkErrorRecovery + ", linkDowned=" + this.linkDowned + ", uncorrectableErrors=" + this.uncorrectableErrors + ", linkQualityIndicator=" + this.linkQualityIndicator + ", imageId=" + this.imageId + "]";
    }
}

