/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.performance;

import com.intel.stl.api.ITimestamped;
import com.intel.stl.api.StringUtils;
import com.intel.stl.api.Utils;
import com.intel.stl.api.performance.ErrStatBean;
import com.intel.stl.api.performance.ImageIdBean;
import com.intel.stl.api.performance.UtilStatsBean;
import java.io.Serializable;
import java.util.Date;

public class VFInfoBean
implements ITimestamped,
Serializable {
    private static final long serialVersionUID = 1L;
    private String vfName;
    private ImageIdBean imageId;
    private long numPorts;
    private UtilStatsBean internalUtilStats;
    private ErrStatBean internalErrors;
    private byte maxInternalRate;
    private byte minInternalRate;
    private int maxInternalMBps;
    private long timestamp;
    private int imageInterval;

    public String getVfName() {
        return this.vfName;
    }

    public void setVfName(String vfName) {
        if (vfName.length() > 64) {
            throw new IllegalArgumentException("Invalid string length: " + vfName.length() + " > " + 64);
        }
        this.vfName = vfName;
    }

    public ImageIdBean getImageId() {
        return this.imageId;
    }

    public void setImageId(ImageIdBean imageId) {
        this.imageId = imageId;
    }

    public long getNumPorts() {
        return this.numPorts;
    }

    public void setNumPorts(long numPorts) {
        this.numPorts = numPorts;
    }

    public void setNumPorts(int numPorts) {
        this.numPorts = Utils.unsignedInt(numPorts);
    }

    public UtilStatsBean getInternalUtilStats() {
        return this.internalUtilStats;
    }

    public void setInternalUtilStats(UtilStatsBean internalUtilStats) {
        this.internalUtilStats = internalUtilStats;
    }

    public ErrStatBean getInternalErrors() {
        return this.internalErrors;
    }

    public void setInternalErrors(ErrStatBean internalErrors) {
        this.internalErrors = internalErrors;
    }

    public byte getMaxInternalRate() {
        return this.maxInternalRate;
    }

    public void setMaxInternalRate(byte maxInternalRate) {
        this.maxInternalRate = maxInternalRate;
    }

    public byte getMinInternalRate() {
        return this.minInternalRate;
    }

    public void setMinInternalRate(byte minInternalRate) {
        this.minInternalRate = minInternalRate;
    }

    public int getMaxInternalMBps() {
        return this.maxInternalMBps;
    }

    public void setMaxInternalMBps(int maxInternalMBps) {
        this.maxInternalMBps = maxInternalMBps;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(long sweepTimestamp) {
        this.timestamp = sweepTimestamp;
    }

    @Override
    public Date getTimestampDate() {
        return Utils.convertFromUnixTime(this.timestamp);
    }

    @Override
    public int getImageInterval() {
        return this.imageInterval;
    }

    @Override
    public void setImageInterval(int imageInterval) {
        this.imageInterval = imageInterval;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.imageId == null ? 0 : this.imageId.hashCode());
        result = 31 * result + (this.vfName == null ? 0 : this.vfName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VFInfoBean other = (VFInfoBean)obj;
        if (this.imageId == null ? other.imageId != null : !this.imageId.equals(other.imageId)) {
            return false;
        }
        return !(this.vfName == null ? other.vfName != null : !this.vfName.equals(other.vfName));
    }

    public String toString() {
        return "VFInfoBean [vfName=" + this.vfName + ", imageId=" + this.imageId + ", numPorts=" + this.numPorts + ", internalUtilStats=" + this.internalUtilStats + ", internalErrors=" + this.internalErrors + ", maxInternalRate=" + StringUtils.byteHexString(this.maxInternalRate) + ", minInternalRate=" + StringUtils.byteHexString(this.minInternalRate) + ", maxInternalMBps=" + this.maxInternalMBps + "]";
    }
}

