/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.performance.impl;

import com.intel.stl.api.ITimestamped;
import com.intel.stl.api.notice.impl.NoticeProcess;
import com.intel.stl.api.performance.GroupConfigRspBean;
import com.intel.stl.api.performance.VFConfigRspBean;
import com.intel.stl.api.performance.impl.GroupConfCache;
import com.intel.stl.api.performance.impl.PAHelper;
import com.intel.stl.configuration.CacheManager;
import com.intel.stl.configuration.MemoryCache;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupConfCacheImpl
extends MemoryCache<Void>
implements GroupConfCache {
    private static final Logger log = LoggerFactory.getLogger(GroupConfCacheImpl.class);
    private final PAHelper helper;
    private final Map<String, SoftReference<List<GroupConfigRspBean>>> groupConfigs = new HashMap<String, SoftReference<List<GroupConfigRspBean>>>();
    private final Map<String, SoftReference<List<VFConfigRspBean>>> vfConfigs = new HashMap<String, SoftReference<List<VFConfigRspBean>>>();

    public GroupConfCacheImpl(CacheManager cacheMgr) {
        super(cacheMgr);
        this.helper = cacheMgr.getPAHelper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GroupConfigRspBean> getGroupConfig(String name) throws Exception {
        Map<String, SoftReference<List<GroupConfigRspBean>>> map = this.groupConfigs;
        synchronized (map) {
            SoftReference<List<GroupConfigRspBean>> confRef = this.groupConfigs.get(name);
            if (confRef == null || confRef.get() == null) {
                List<GroupConfigRspBean> conf = this.helper.getGroupConfig(name);
                confRef = new SoftReference<List<GroupConfigRspBean>>(conf);
                this.groupConfigs.put(name, confRef);
            }
            return confRef == null ? null : confRef.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<VFConfigRspBean> getVFConfig(String name) throws Exception {
        Map<String, SoftReference<List<VFConfigRspBean>>> map = this.vfConfigs;
        synchronized (map) {
            SoftReference<List<VFConfigRspBean>> confRef = this.vfConfigs.get(name);
            if (confRef == null || confRef.get() == null) {
                List<VFConfigRspBean> conf = this.helper.getVFConfig(name);
                confRef = new SoftReference<List<VFConfigRspBean>>(conf);
                this.vfConfigs.put(name, confRef);
            }
            return confRef == null ? null : confRef.get();
        }
    }

    @Override
    public boolean isCacheReady() {
        return this.cacheReady.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        super.reset();
        Map<String, SoftReference<List<ITimestamped>>> map = this.groupConfigs;
        synchronized (map) {
            this.groupConfigs.clear();
        }
        map = this.vfConfigs;
        synchronized (map) {
            this.vfConfigs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void retrieveObjectForCache() throws Exception {
        Map<String, SoftReference<List<ITimestamped>>> map = this.groupConfigs;
        synchronized (map) {
            this.groupConfigs.clear();
        }
        map = this.vfConfigs;
        synchronized (map) {
            this.vfConfigs.clear();
        }
        return null;
    }

    @Override
    public boolean refreshCache(NoticeProcess notice) throws Exception {
        int lid = notice.getLid();
        this.refreshGroupConf(lid);
        this.refreshVfConf(lid);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshGroupConf(int lid) {
        Map<String, SoftReference<List<GroupConfigRspBean>>> map = this.groupConfigs;
        synchronized (map) {
            boolean found = false;
            block3: for (String group : this.groupConfigs.keySet()) {
                SoftReference<List<GroupConfigRspBean>> ref = this.groupConfigs.get(group);
                List<GroupConfigRspBean> confs = ref.get();
                if (confs == null) continue;
                for (GroupConfigRspBean conf : confs) {
                    if (conf.getPort().getNodeLid() != lid) continue;
                    found = true;
                    ref.clear();
                    log.info("Cleared cache for Device Group '" + group + "'");
                    continue block3;
                }
            }
            if (!found) {
                this.groupConfigs.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshVfConf(int lid) {
        Map<String, SoftReference<List<VFConfigRspBean>>> map = this.vfConfigs;
        synchronized (map) {
            boolean found = false;
            block3: for (String group : this.vfConfigs.keySet()) {
                SoftReference<List<VFConfigRspBean>> ref = this.vfConfigs.get(group);
                List<VFConfigRspBean> confs = ref.get();
                if (confs == null) continue;
                for (VFConfigRspBean conf : confs) {
                    if (conf.getPort().getNodeLid() != lid) continue;
                    found = true;
                    ref.clear();
                    log.info("Cleared cache for Virtual Fabric '" + group + "'");
                    continue block3;
                }
            }
            if (!found) {
                this.vfConfigs.clear();
            }
        }
    }
}

