/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.performance.impl;

import com.intel.stl.api.performance.ImageIdBean;
import com.intel.stl.api.performance.ImageInfoBean;
import com.intel.stl.api.performance.impl.PAHelper;
import com.intel.stl.common.CircularBuffer;
import com.intel.stl.configuration.AsyncTask;
import com.intel.stl.datamanager.DatabaseManager;
import java.util.List;

public class ImageInfoSaveTask
extends AsyncTask<Void> {
    private final DatabaseManager dbMgr;
    private final PAHelper helper;
    private final CircularBuffer<ImageIdBean, ImageInfoBean> imageInfoBuffer;

    public ImageInfoSaveTask(PAHelper helper, DatabaseManager dbMgr, CircularBuffer<ImageIdBean, ImageInfoBean> imageInfoBuffer) {
        this.checkArguments(helper, dbMgr, imageInfoBuffer);
        this.helper = helper;
        this.dbMgr = dbMgr;
        this.imageInfoBuffer = imageInfoBuffer;
    }

    @Override
    public Void process() throws Exception {
        String subnetName = this.helper.getSubnetDescription().getName();
        List<ImageInfoBean> saveList = this.imageInfoBuffer.purgeSaveQueue();
        if (saveList.size() > 0) {
            this.dbMgr.saveImageInfos(subnetName, saveList);
        }
        return null;
    }
}

