/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.subnet;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CableType {
    AOC_VCSEL_850NM(1, 0),
    OT_VCSEL_850NM(2, 0),
    AOC_VCSEL_1310NM(1, 1),
    OT_VCSEL_1310NM(2, 1),
    AOC_VCSEL_1550NM(1, 2),
    OT_VCSEL_1550NM(2, 2),
    AOC_FP_1310NM(1, 3),
    OT_FP_1310NM(2, 3),
    AOC_DFB_1310NM(1, 4),
    OT_DFB_1310NM(2, 4),
    AOC_DFB_1550NM(1, 5),
    OT_DFB_1550NM(2, 5),
    AOC_EML_1310NM(1, 6),
    OT_EML_1310NM(2, 6),
    AOC_EML_1550NM(1, 7),
    OT_EML_1550NM(2, 7),
    OTHER_UNDEFINED(0, 8),
    AOC_DFB_1490NM(1, 9),
    OT_DFB_1490NM(2, 9),
    PASSIVE_COPPER_CABL(0, 10),
    EQUALIZED_PASSIVE_COPPER_CABL(0, 11),
    ACTIVE_COPPER_CABL_TX_RX(0, 12),
    ACTIVE_COPPER_CABL_RX(0, 13),
    ACTIVE_COPPER_CABL_TX(0, 14),
    LINEAR_ACTIVE_COPPER_CABL(0, 15),
    UNDEFINED(0, -1);

    private final int codeXmit;
    private final int connectorId;
    private static Logger log;

    private CableType(int connectorId, int codeXmit) {
        this.connectorId = connectorId;
        this.codeXmit = codeXmit;
    }

    public int getCodeXmit() {
        return this.codeXmit;
    }

    public int getConnectorId() {
        return this.connectorId;
    }

    public static CableType getCableType(int connectorId, int codeXmit) {
        for (CableType ct : CableType.values()) {
            if (ct.getCodeXmit() != codeXmit || ct.getConnectorId() != connectorId) continue;
            return ct;
        }
        log.error("Undefined CableType : connector ID ='" + connectorId + "'" + ", code Xmit ='" + codeXmit + "'");
        return UNDEFINED;
    }

    static {
        log = LoggerFactory.getLogger(CableType.class);
    }
}

