/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.subnet;

import com.intel.stl.api.CertsDescription;
import com.intel.stl.api.IConnectionAssistant;
import com.intel.stl.api.subnet.HostType;
import java.io.Serializable;
import java.net.InetAddress;

public class HostInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String host;
    private HostType hostType;
    private int port = 3245;
    private boolean secureConnect;
    private CertsDescription certsDescription = new CertsDescription();
    private InetAddress inetAddress;
    private IConnectionAssistant connectionAssistant;
    private String sshUserName = "";
    private int sshPortNum = 22;

    public HostInfo() {
    }

    public HostInfo(String host, int port) {
        this.host = host;
        this.port = port;
        this.secureConnect = false;
    }

    public HostInfo(String host, int port, CertsDescription certsDescription) {
        this.host = host;
        this.port = port;
        this.certsDescription = certsDescription;
        this.secureConnect = true;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public HostType getHostType() {
        return this.hostType;
    }

    public void setHostType(HostType hostType) {
        this.hostType = hostType;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isSecureConnect() {
        return this.secureConnect;
    }

    public void setSecureConnect(boolean secureConnect) {
        this.secureConnect = secureConnect;
    }

    public CertsDescription getCertsDescription() {
        return this.certsDescription;
    }

    public void setCertsDescription(CertsDescription certsDescription) {
        this.certsDescription = certsDescription;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public void setInetAddress(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
    }

    public IConnectionAssistant getConnectionAssistant() {
        return this.connectionAssistant;
    }

    public void setConnectionAssistant(IConnectionAssistant connectionAssistant) {
        this.connectionAssistant = connectionAssistant;
    }

    public HostInfo copy() {
        HostInfo newHostInfo = new HostInfo();
        newHostInfo.setHost(this.host);
        newHostInfo.setPort(this.port);
        newHostInfo.setSecureConnect(this.secureConnect);
        if (this.certsDescription != null) {
            CertsDescription newCertsDescription = new CertsDescription(this.certsDescription.getKeyStoreFile(), this.certsDescription.getTrustStoreFile());
            newCertsDescription.setKeyStorePwd(this.certsDescription.getKeyStorePwd());
            newCertsDescription.setTrustStorePwd(this.certsDescription.getTrustStorePwd());
            newHostInfo.setCertsDescription(newCertsDescription);
        } else {
            newHostInfo.setCertsDescription(null);
        }
        newHostInfo.setConnectionAssistant(this.connectionAssistant);
        newHostInfo.setSshUserName(this.sshUserName);
        newHostInfo.setSshPortNum(this.sshPortNum);
        return newHostInfo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.certsDescription == null ? 0 : this.certsDescription.hashCode());
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.secureConnect ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HostInfo other = (HostInfo)obj;
        if (this.certsDescription == null ? other.certsDescription != null : !this.certsDescription.equals(other.certsDescription)) {
            return false;
        }
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return this.secureConnect == other.secureConnect;
    }

    public String toString() {
        return "HostInfo [host=" + this.host + ", hostType=" + (Object)((Object)this.hostType) + ", port=" + this.port + ", secureConnect=" + this.secureConnect + ", certsDescription=" + this.certsDescription + ", sshUserName=" + this.sshUserName + ", sshPortNum=" + this.sshPortNum + "]";
    }

    public String getSshUserName() {
        return this.sshUserName;
    }

    public void setSshUserName(String sslUserName) {
        this.sshUserName = sslUserName;
    }

    public int getSshPortNum() {
        return this.sshPortNum;
    }

    public void setSshPortNum(int sslPortNum) {
        this.sshPortNum = sslPortNum;
    }
}

