/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.subnet.impl;

import com.intel.stl.api.notice.impl.NoticeProcess;
import com.intel.stl.api.subnet.LFTRecordBean;
import com.intel.stl.api.subnet.impl.LFTCache;
import com.intel.stl.api.subnet.impl.SAHelper;
import com.intel.stl.api.subnet.impl.SubnetApi;
import com.intel.stl.configuration.CacheManager;
import com.intel.stl.configuration.MemoryCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LFTCacheImpl
extends MemoryCache<Map<Integer, List<LFTRecordBean>>>
implements LFTCache {
    private final SAHelper helper;

    public LFTCacheImpl(CacheManager cacheMgr) {
        super(cacheMgr);
        this.helper = cacheMgr.getSAHelper();
    }

    @Override
    public List<LFTRecordBean> getLFTs() {
        Map map = (Map)this.getCachedObject();
        List<LFTRecordBean> res = new ArrayList<LFTRecordBean>();
        if (map != null && !map.isEmpty()) {
            for (List lfts : map.values()) {
                for (LFTRecordBean lft : lfts) {
                    res.add(lft);
                }
            }
        }
        if (!res.isEmpty()) {
            return res;
        }
        try {
            res = this.helper.getLFTs();
            if (res != null) {
                this.setCacheReady(false);
            }
            return res;
        }
        catch (Exception e) {
            throw SubnetApi.getSubnetException(e);
        }
    }

    @Override
    public List<LFTRecordBean> getLFT(int lid) {
        Map map = (Map)this.getCachedObject();
        List<Object> res = new ArrayList();
        if (map != null && (res = (List)map.get(lid)) != null && !res.isEmpty()) {
            return res;
        }
        try {
            res = this.helper.getLFTs(lid);
            if (res != null && !res.isEmpty()) {
                this.setCacheReady(false);
            }
        }
        catch (Exception e) {
            log.error("Error getting LFT by lid " + lid, (Throwable)e);
            e.printStackTrace();
            throw SubnetApi.getSubnetException(e);
        }
        return res;
    }

    @Override
    protected Map<Integer, List<LFTRecordBean>> retrieveObjectForCache() throws Exception {
        List<LFTRecordBean> lfts = this.helper.getLFTs();
        log.info("Retrieve " + (lfts == null ? 0 : lfts.size()) + " LFTs from FE");
        HashMap map = null;
        if (lfts != null) {
            map = new HashMap();
            for (LFTRecordBean lft : lfts) {
                int lid = lft.getLid();
                if (map.containsKey(lid)) {
                    ((List)map.get(lid)).add(lft);
                    continue;
                }
                ArrayList<LFTRecordBean> list = new ArrayList<LFTRecordBean>();
                list.add(lft);
                map.put(lft.getLid(), list);
            }
        }
        return map;
    }

    @Override
    public boolean refreshCache(NoticeProcess notice) throws Exception {
        Map map = (Map)this.getCachedObject();
        if (map != null && !map.isEmpty()) {
            map.remove(notice.getLid());
        }
        return true;
    }

    @Override
    protected RuntimeException processRefreshCacheException(Exception e) {
        return SubnetApi.getSubnetException(e);
    }
}

