/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.subnet.impl;

import com.intel.stl.api.notice.impl.NoticeProcess;
import com.intel.stl.api.subnet.SC2VLMTRecordBean;
import com.intel.stl.api.subnet.impl.SAHelper;
import com.intel.stl.api.subnet.impl.SC2VLTMTCache;
import com.intel.stl.api.subnet.impl.SubnetApi;
import com.intel.stl.configuration.CacheManager;
import com.intel.stl.configuration.MemoryCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SC2VLTMTCacheImpl
extends MemoryCache<Map<Integer, List<SC2VLMTRecordBean>>>
implements SC2VLTMTCache {
    private final SAHelper helper;

    public SC2VLTMTCacheImpl(CacheManager cacheMgr) {
        super(cacheMgr);
        this.helper = cacheMgr.getSAHelper();
    }

    @Override
    public List<SC2VLMTRecordBean> getSC2VLTMTs() {
        Map map = (Map)this.getCachedObject();
        List<SC2VLMTRecordBean> res = new ArrayList<SC2VLMTRecordBean>();
        if (map != null && !map.isEmpty()) {
            for (List sc2vlts : map.values()) {
                for (SC2VLMTRecordBean sc2vl : sc2vlts) {
                    res.add(sc2vl);
                }
            }
        }
        if (!res.isEmpty()) {
            return res;
        }
        try {
            res = this.helper.getSC2VLTMTs();
            if (res != null) {
                this.setCacheReady(false);
            }
            return res;
        }
        catch (Exception e) {
            throw SubnetApi.getSubnetException(e);
        }
    }

    @Override
    public List<SC2VLMTRecordBean> getSC2VLTMT(int lid) {
        Map map = (Map)this.getCachedObject();
        List<Object> res = new ArrayList();
        if (map != null) {
            res = (List)map.get(lid);
        }
        if (res != null && !res.isEmpty()) {
            return res;
        }
        try {
            res = this.helper.getSC2VLTMT(lid);
            if (res != null && !res.isEmpty()) {
                this.setCacheReady(false);
            }
        }
        catch (Exception e) {
            log.error("Error getting Cable Infos by lid " + lid, (Throwable)e);
            e.printStackTrace();
            throw SubnetApi.getSubnetException(e);
        }
        return res;
    }

    @Override
    public SC2VLMTRecordBean getSC2VLTMT(int lid, short portNum) {
        List sc2vltmts;
        Map map = (Map)this.getCachedObject();
        if (map != null && (sc2vltmts = (List)map.get(lid)) != null) {
            for (SC2VLMTRecordBean sc2vlt : sc2vltmts) {
                if (sc2vlt.getLid() != lid || sc2vlt.getPort() != portNum) continue;
                return sc2vlt;
            }
        }
        try {
            List<SC2VLMTRecordBean> sc2vltFromFE = this.helper.getSC2VLTMT(lid);
            if (sc2vltFromFE != null && !sc2vltFromFE.isEmpty()) {
                this.setCacheReady(false);
                for (SC2VLMTRecordBean sc2vlt : sc2vltFromFE) {
                    if (sc2vlt.getPort() != portNum) continue;
                    return sc2vlt;
                }
            }
        }
        catch (Exception e) {
            log.error("Error getting SC2VLt Infos by lid " + lid + ", portNum=" + portNum, (Throwable)e);
            e.printStackTrace();
            throw SubnetApi.getSubnetException(e);
        }
        return null;
    }

    @Override
    protected Map<Integer, List<SC2VLMTRecordBean>> retrieveObjectForCache() throws Exception {
        List<SC2VLMTRecordBean> sc2vls = this.helper.getSC2VLTMTs();
        log.info("Retrieve " + (sc2vls == null ? 0 : sc2vls.size()) + " SC2VLTMT Infos from FE");
        HashMap map = null;
        if (sc2vls != null) {
            map = new HashMap();
            for (SC2VLMTRecordBean sc2vl : sc2vls) {
                int lid = sc2vl.getLid();
                if (map.containsKey(lid)) {
                    ((List)map.get(lid)).add(sc2vl);
                    continue;
                }
                ArrayList<SC2VLMTRecordBean> list = new ArrayList<SC2VLMTRecordBean>();
                list.add(sc2vl);
                map.put(sc2vl.getLid(), list);
            }
        }
        return map;
    }

    @Override
    public boolean refreshCache(NoticeProcess notice) throws Exception {
        Map map = (Map)this.getCachedObject();
        if (map != null && !map.isEmpty()) {
            map.remove(notice.getLid());
        }
        return true;
    }

    @Override
    protected RuntimeException processRefreshCacheException(Exception e) {
        return SubnetApi.getSubnetException(e);
    }
}

