/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.configuration;

import com.intel.stl.api.AppContext;
import com.intel.stl.api.FMGui;
import com.intel.stl.api.configuration.impl.AppContextImpl;
import com.intel.stl.api.configuration.impl.MailManager;
import com.intel.stl.common.AppDataUtils;
import com.intel.stl.common.STLMessages;
import com.intel.stl.configuration.AppComponent;
import com.intel.stl.configuration.AppConfigurationException;
import com.intel.stl.configuration.AppSettings;
import com.intel.stl.configuration.AsyncProcessingService;
import com.intel.stl.datamanager.DatabaseManager;
import com.intel.stl.datamanager.impl.DatabaseManagerImpl;
import com.intel.stl.dbengine.impl.HibernateEngine;
import com.intel.stl.fecdriver.adapter.FEAdapter;
import com.intel.stl.fecdriver.network.ssh.impl.JSchSessionFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileLock;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.InvalidPropertiesFormatException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppComponentRegistry {
    public static final String COMPONENT_DATABASE_MANAGER = "dbmgr";
    public static final String COMPONENT_MAIL_MANAGER = "mailmgr";
    public static final String COMPONENT_FEADAPTER = "feadapter";
    public static final String COMPONENT_APPLICATION_CONTEXT = "appcontext";
    public static final String COMPONENT_UI_PLUGIN = "uiplugin";
    public static final String APP_SETTINGS = "appsettings";
    private static final String ENGINE_HIBERNATE = "HIBERNATE";
    private static final String MANIFEST_IMPLEMENTATIONTITLE = "Implementation-Title";
    private static final String MANIFEST_IMPLEMENTATIONVERSION = "Implementation-Version";
    private static final String MANIFEST_SCHEMAVERSION = "Schema-Version";
    private static final String MANIFEST_OPAFM_VERSION = "Intel-OPAFM-Version";
    private static final String MANIFEST_BUILDID = "Intel-Build-Id";
    private static final String MANIFEST_BUILD_DATE = "Intel-Build-Date";
    private static final String APP_DEFAULT_NAME = "Intel Fabric Manager GUI";
    private static final int APP_DEFAULT_VERSION = 10;
    private static final int APP_DEFAULT_RELEASE = 0;
    private static final int APP_DEFAULT_MODLEVEL = 0;
    private static final String NOT_AVAILABLE = "N/A";
    private static final int APP_DEFAULT_SCHEMALEVEL = 1;
    private static final int PROGRESS_DELAY = 500;
    private static Logger log = LoggerFactory.getLogger(AppComponentRegistry.class);
    private final Map<String, AppComponent> components;
    private AppSettings settings = null;
    private FMGui uiComponent;
    private AsyncProcessingService asyncService;
    private final AtomicBoolean appShutDown = new AtomicBoolean(false);

    public AppComponentRegistry() {
        this.components = new LinkedHashMap<String, AppComponent>();
    }

    public void initialize() throws AppConfigurationException {
        log.info(STLMessages.STL10016_INITIALIZING_COMPONENT_REGISTRY.getDescription());
        this.initializeAppSettings();
        this.initializeAppFolders();
        this.createComponents();
        AppContext appContext = this.getAppContext();
        this.initializeUIPlugin(appContext);
        this.uiComponent.setProgress(STLMessages.STL10017_CHECKING_MULTI_APP_INSTANCES.getDescription(), 0);
        if (this.hasRunningApplication()) {
            throw new AppConfigurationException(STLMessages.STL10102_MULTI_INSTANCES.getDescription());
        }
        this.sleep(500L);
        double totalWeight = 5.0;
        for (String componentName : this.components.keySet()) {
            AppComponent component = this.components.get(componentName);
            totalWeight += (double)component.getInitializationWeight();
        }
        double progress = 5.0;
        for (String componentName : this.components.keySet()) {
            double percent = progress / totalWeight * 100.0 + 0.5;
            this.uiComponent.setProgress((int)percent);
            AppComponent component = this.components.get(componentName);
            component.initialize(this.settings, this.uiComponent);
            progress += (double)component.getInitializationWeight();
            this.sleep(500L);
        }
        log.info("Application build id: " + this.settings.getAppBuildId() + " build date: " + this.settings.getAppBuildDate());
        this.sleep(500L);
    }

    public void shutdown() {
        boolean appIsShutDown = this.appShutDown.get();
        if (appIsShutDown) {
            log.info("Shutdown already performed.");
            return;
        }
        if (!this.appShutDown.compareAndSet(false, true)) {
            return;
        }
        double totalWeight = 5.0;
        for (String componentName : this.components.keySet()) {
            AppComponent component = this.components.get(componentName);
            totalWeight += (double)component.getInitializationWeight();
        }
        ArrayList<String> componentName = new ArrayList<String>(this.components.keySet());
        if (this.uiComponent != null) {
            this.uiComponent.shutdown();
        }
        double progress = 5.0;
        for (int i = componentName.size() - 1; i >= 0; --i) {
            double percent = progress / totalWeight * 100.0 + 0.5;
            if (this.uiComponent != null) {
                this.uiComponent.setProgress((int)percent);
            }
            AppComponent component = this.components.get(componentName.get(i));
            try {
                component.shutdown(this.uiComponent);
            }
            catch (Exception e) {
                log.warn("Exception occurred during {} shutdown.", (Object)component.getComponentDescription(), (Object)e);
            }
            progress += (double)component.getInitializationWeight();
            this.sleep(500L);
        }
        try {
            JSchSessionFactory.cleanup();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void createComponents() throws AppConfigurationException {
        this.asyncService = new AsyncProcessingService();
        this.createDatabaseManager();
        this.createMailManager();
        this.createAppContext();
    }

    public AppSettings getAppSettings() {
        return this.settings;
    }

    public FMGui getUIComponent() {
        return this.uiComponent;
    }

    public DatabaseManager getDatabaseManager() throws AppConfigurationException {
        return (DatabaseManager)((Object)this.getComponent(COMPONENT_DATABASE_MANAGER));
    }

    public MailManager getMailManager() throws AppConfigurationException {
        return (MailManager)this.getComponent(COMPONENT_MAIL_MANAGER);
    }

    public AppContext getAppContext() throws AppConfigurationException {
        return (AppContext)((Object)this.getComponent(COMPONENT_APPLICATION_CONTEXT));
    }

    public AppComponent getComponent(String componentName) throws AppConfigurationException {
        AppComponent res = this.components.get(componentName);
        if (res != null) {
            return res;
        }
        String msg = STLMessages.STL10024_NO_COMPONENT_FOUND.getDescription(componentName);
        log.error(msg);
        throw new AppConfigurationException(msg);
    }

    public void registerComponent(String componentName, AppComponent component) {
        this.components.put(componentName, component);
    }

    public void deregisterComponent(String componentName) {
        this.components.remove(componentName);
    }

    private void initializeAppSettings() throws AppConfigurationException {
        try {
            String appName = APP_DEFAULT_NAME;
            Integer appVersion = new Integer(10);
            Integer appRelease = new Integer(0);
            Integer appModLevel = new Integer(0);
            Integer schLevel = new Integer(1);
            String opaFMVersion = NOT_AVAILABLE;
            String appBuildId = NOT_AVAILABLE;
            String appBuildDate = NOT_AVAILABLE;
            this.settings = this.getApplicationSettings();
            Manifest manifest = this.getManifest();
            if (manifest != null) {
                String[] stringArray;
                Attributes attribs = manifest.getMainAttributes();
                Attributes.Name key = new Attributes.Name(MANIFEST_IMPLEMENTATIONTITLE);
                appName = (String)attribs.get(key);
                key = new Attributes.Name(MANIFEST_IMPLEMENTATIONVERSION);
                String strVersion = (String)attribs.get(key);
                if (strVersion == null) {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = "0";
                    stringArray = stringArray2;
                    stringArray2[1] = "0";
                } else {
                    stringArray = strVersion.split("[.]");
                }
                String[] verParts = stringArray;
                appVersion = this.parseInt(verParts[0], appVersion);
                appRelease = this.parseInt(verParts[1], appRelease);
                appModLevel = this.parseInt(verParts[2], appModLevel);
                log.info(appName + " v" + strVersion);
                key = new Attributes.Name(MANIFEST_SCHEMAVERSION);
                String value = (String)attribs.get(key);
                schLevel = this.parseInt(value, schLevel);
                log.info("Schema level: " + schLevel);
                key = new Attributes.Name(MANIFEST_OPAFM_VERSION);
                opaFMVersion = (String)attribs.get(key);
                log.info("OPA FM version: " + opaFMVersion);
                key = new Attributes.Name(MANIFEST_BUILDID);
                appBuildId = (String)attribs.get(key);
                log.info("Build id: " + appBuildId);
                key = new Attributes.Name(MANIFEST_BUILD_DATE);
                appBuildDate = (String)attribs.get(key);
                log.info("Build date: " + appBuildDate);
            }
            this.settings.setConfigOption("app.name", appName);
            this.settings.setConfigOption("app.version", appVersion);
            this.settings.setConfigOption("app.release", appRelease);
            this.settings.setConfigOption("app.modlevel", appModLevel);
            this.settings.setConfigOption("app.opa.fm", opaFMVersion);
            this.settings.setConfigOption("app.build.id", appBuildId);
            this.settings.setConfigOption("app.build.date", appBuildDate);
            this.settings.setConfigOption("app.schema.level", schLevel);
        }
        catch (InvalidPropertiesFormatException e) {
            String msg = STLMessages.STL10001_SETTINGS_FILE_FORMAT_INVALID.getDescription();
            log.error(msg, (Throwable)e);
            AppConfigurationException ace = new AppConfigurationException(msg, e);
            throw ace;
        }
        catch (IOException e) {
            String msg = STLMessages.STL10002_IO_EXCEPTION_READING_SETTINGS.getDescription();
            log.error(msg, (Throwable)e);
            AppConfigurationException ace = new AppConfigurationException(msg, e);
            throw ace;
        }
    }

    private Integer parseInt(String value, Integer defaultValue) {
        Number res;
        try {
            res = NumberFormat.getInstance().parse(value);
        }
        catch (ParseException e) {
            return defaultValue;
        }
        return res.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest getManifest() throws IOException {
        URL registryUrl = AppComponentRegistry.class.getResource(AppComponentRegistry.class.getSimpleName() + ".class");
        URLConnection urlConn = registryUrl.openConnection();
        if (urlConn instanceof JarURLConnection) {
            JarURLConnection jarUrl = (JarURLConnection)urlConn;
            return jarUrl.getManifest();
        }
        Manifest manifest = null;
        Enumeration<URL> manifests = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (manifests.hasMoreElements()) {
            Attributes.Name key;
            try (InputStream is = manifests.nextElement().openStream();){
                manifest = new Manifest(is);
            }
            Attributes attribs = manifest.getMainAttributes();
            if (attribs.get(key = new Attributes.Name(MANIFEST_BUILDID)) == null) continue;
            break;
        }
        return manifest;
    }

    private void initializeAppFolders() throws AppConfigurationException {
        String folder = null;
        try {
            folder = this.getIntelDataPath();
            File intelDir = new File(folder);
            if (!intelDir.exists()) {
                intelDir.mkdir();
            }
            this.settings.setConfigOption("app.intel.path", folder);
            folder = this.getApplicationDataPath();
            File appDir = new File(folder);
            if (!appDir.exists()) {
                appDir.mkdir();
            }
            if (AppDataUtils.isPostSetupNeeded()) {
                this.executePostSetup();
            }
            this.settings.setConfigOption("app.data.path", folder);
            folder = this.getDatabaseDataPath();
            File dbDir = new File(folder);
            if (!dbDir.exists()) {
                dbDir.mkdir();
            }
            this.settings.setConfigOption("app.db.path", folder);
        }
        catch (SecurityException e) {
            String msg = STLMessages.STL10004_SECURITY_EXCEPTION_IN_FOLDER.getDescription(folder);
            log.error(msg, (Throwable)e);
            AppConfigurationException ace = new AppConfigurationException(msg, e);
            throw ace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executePostSetup() {
        String script = AppDataUtils.getPostSetupScript();
        if (script == null) {
            return;
        }
        log.info("Invoking post setup script {}", (Object)script);
        File scriptFile = new File(script);
        if (scriptFile.exists()) {
            ProcessBuilder pb = new ProcessBuilder(script);
            pb.redirectErrorStream(true);
            InputStream is = null;
            try {
                Process proc = pb.start();
                is = proc.getInputStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String line = null;
                while ((line = br.readLine()) != null) {
                    log.info("PostSetup: " + line);
                }
                proc.waitFor();
            }
            catch (IOException e) {
                log.error("IOException while reading output from post setup script", (Throwable)e);
            }
            catch (InterruptedException e) {
                log.error("Post setup script was interrupted", (Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        log.error("IOException while closing output from post setup script", (Throwable)e);
                    }
                }
            }
        } else {
            log.error("Post setup script not found.");
        }
    }

    private void initializeUIPlugin(AppContext appContext) throws AppConfigurationException {
        String pluginClass = this.settings.getConfigOption("app.ui.plugin");
        try {
            this.uiComponent = (FMGui)Class.forName(pluginClass).newInstance();
            this.uiComponent.init(appContext);
        }
        catch (Exception e) {
            AppConfigurationException ace = new AppConfigurationException("Class load error", e);
            throw ace;
        }
    }

    protected boolean hasRunningApplication() {
        String file = this.getLockFilePath();
        final AppLock appLock = new AppLock(file);
        boolean locked = appLock.getLock();
        if (locked) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    appLock.releaseLock();
                }
            });
        }
        return !locked;
    }

    private void createDatabaseManager() throws AppConfigurationException {
        String engineType = this.settings.getConfigOption("db.persistence.provider.name");
        if (!ENGINE_HIBERNATE.equalsIgnoreCase(engineType)) {
            String errMsg = STLMessages.STL10005_DATABASE_ENGINE_NOTSUPPORTED.getDescription(engineType);
            AppConfigurationException ace = new AppConfigurationException(errMsg);
            throw ace;
        }
        HibernateEngine engine = new HibernateEngine(this.settings);
        DatabaseManagerImpl dbMgr = new DatabaseManagerImpl(engine);
        this.registerComponent(COMPONENT_DATABASE_MANAGER, dbMgr);
    }

    private void createMailManager() throws AppConfigurationException {
        MailManager mailMgr = new MailManager(this.getDatabaseManager());
        this.registerComponent(COMPONENT_MAIL_MANAGER, mailMgr);
    }

    private void createAppContext() throws AppConfigurationException {
        FEAdapter feAdapter = new FEAdapter(this.getDatabaseManager(), this.asyncService);
        this.registerComponent(COMPONENT_FEADAPTER, feAdapter);
        FEAdapter adapter = feAdapter;
        AppContextImpl appContext = new AppContextImpl(adapter, this.getDatabaseManager(), this.getMailManager(), this.asyncService);
        this.registerComponent(COMPONENT_APPLICATION_CONTEXT, appContext);
    }

    protected AppSettings getApplicationSettings() throws InvalidPropertiesFormatException, IOException {
        return AppDataUtils.getApplicationSettings();
    }

    protected String getIntelDataPath() {
        return AppDataUtils.getIntelDataPath();
    }

    protected String getApplicationDataPath() {
        return AppDataUtils.getApplicationDataPath();
    }

    protected String getDatabaseDataPath() {
        return AppDataUtils.getDatabaseDataPath();
    }

    protected String getLockFilePath() {
        return AppDataUtils.getLockFilePath();
    }

    protected AsyncProcessingService getAsyncProcessingService() {
        return this.asyncService;
    }

    private class AppLock {
        private final File lockFile;
        private RandomAccessFile randomAccessFile;
        private FileLock fileLock;

        public AppLock(String lockFile) {
            this.lockFile = new File(lockFile);
            this.lockFile.deleteOnExit();
        }

        public boolean getLock() {
            try {
                this.randomAccessFile = new RandomAccessFile(this.lockFile, "rw");
                this.fileLock = this.randomAccessFile.getChannel().tryLock();
                if (this.fileLock != null) {
                    return true;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void releaseLock() {
            try {
                this.fileLock.release();
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            finally {
                try {
                    this.randomAccessFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    this.lockFile.delete();
                }
            }
        }
    }
}

