/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.configuration;

import com.intel.stl.configuration.AsyncTask;
import com.intel.stl.configuration.BaseProcessingService;
import com.intel.stl.configuration.ProcessingServiceThreadFactory;
import com.intel.stl.configuration.ResultHandler;
import com.intel.stl.configuration.SerialProcessingService;
import com.intel.stl.configuration.SerialServiceThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AsyncProcessingService
extends BaseProcessingService
implements SerialProcessingService {
    private static final int DEFAULT_POOL_SIZE = 2;
    private static final long SERIAL_SHUTDOWN_TIMEOUT = 10000L;
    private static final int SERIAL_POOL_SIZE = 1;
    private final ExecutorService serialService;

    public AsyncProcessingService() {
        super(Executors.newFixedThreadPool(2, new ProcessingServiceThreadFactory()));
        SerialServiceThreadFactory pssThreadFactory = new SerialServiceThreadFactory();
        this.serialService = Executors.newFixedThreadPool(1, pssThreadFactory);
    }

    @Override
    public <T> void submitSerial(AsyncTask<T> task, ResultHandler<T> handler) {
        if (this.serialService.isShutdown()) {
            return;
        }
        this.executeTask(task, handler, this.serialService);
    }

    @Override
    public void shutdown() {
        this.shutdownService(this.serialService, 10000L);
        super.shutdown();
    }

    @Override
    public void shutdown(long timeout) {
        this.shutdownService(this.serialService, timeout);
        super.shutdown(timeout);
    }
}

