/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.datamanager.impl;

import com.intel.stl.api.DatabaseException;
import com.intel.stl.api.FMException;
import com.intel.stl.api.IMessage;
import com.intel.stl.api.StringUtils;
import com.intel.stl.common.STLMessages;
import com.intel.stl.datamanager.DatabaseCall;
import com.intel.stl.datamanager.Result;
import com.intel.stl.datamanager.impl.DatabaseCallException;
import com.intel.stl.datamanager.impl.ResultImpl;
import com.intel.stl.dbengine.DatabaseContext;
import com.intel.stl.dbengine.DatabaseServer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.hibernate.HibernateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatabaseCallImpl<R>
implements DatabaseCall<R> {
    private static Logger log = LoggerFactory.getLogger(DatabaseCallImpl.class);
    private DatabaseServer server;
    private Exception clientTrace;
    private Future<R> future;

    @Override
    public R call() throws Exception {
        if (this.server == null) {
            DatabaseException dbe = new DatabaseException(STLMessages.STL30021_DATABASE_SERVER_NOT_INITIALIZED);
            throw dbe;
        }
        boolean exceptionProcessed = false;
        String contextName = this.getContextName();
        DatabaseContext ctx = this.server.getDatabaseContext(contextName);
        try {
            R result;
            R r = result = this.execute(ctx);
            return r;
        }
        catch (HibernateException he) {
            exceptionProcessed = true;
            this.checkTransaction(ctx);
            this.server.addDatabaseContext(contextName);
            ctx = this.server.getDatabaseContext(contextName);
            this.addClientTrace(he);
            throw he;
        }
        catch (Exception e) {
            exceptionProcessed = true;
            this.checkTransaction(ctx);
            this.addClientTrace(e);
            throw e;
        }
        finally {
            EntityTransaction tx;
            EntityManager em = ctx.getEntityManager();
            if (!exceptionProcessed && (tx = em.getTransaction()) != null && tx.isActive()) {
                tx.rollback();
                DatabaseCallException dce = new DatabaseCallException(STLMessages.STL30068_TRANSACTION_ACTIVE.getDescription());
                throw dce;
            }
            em.clear();
            if (!em.isOpen()) {
                this.server.addDatabaseContext(contextName);
                DatabaseCallException dce = new DatabaseCallException(STLMessages.STL30020_ENTITY_MANAGER_CLOSED.getDescription());
                throw dce;
            }
        }
    }

    @Override
    public void setFuture(Future<R> future) {
        this.future = future;
    }

    @Override
    public void setDatabaseServer(DatabaseServer server) {
        this.server = server;
    }

    @Override
    public void setClientTrace(Exception e) {
        this.clientTrace = e;
    }

    @Override
    public R getResult() {
        R result = null;
        try {
            result = this.future.get();
        }
        catch (InterruptedException e) {
            throw this.getResultInterruptedError(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DatabaseException) {
                DatabaseException dbe = (DatabaseException)cause;
                throw dbe;
            }
            throw this.getResultError(cause);
        }
        return result;
    }

    @Override
    public <E extends FMException> R getResult(Class<E> allowedException) throws E {
        R result = null;
        try {
            result = this.future.get();
        }
        catch (InterruptedException e) {
            throw this.getResultInterruptedError(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DatabaseException) {
                throw (DatabaseException)cause;
            }
            if (cause instanceof FMException && allowedException.isInstance(cause)) {
                throw (FMException)allowedException.cast(cause);
            }
            throw this.getResultError(cause);
        }
        return result;
    }

    @Override
    public <E extends FMException, F extends FMException> R getResult(Class<E> allowedException1, Class<F> allowedException2) throws E, F {
        R result = null;
        try {
            result = this.future.get();
        }
        catch (InterruptedException e) {
            throw this.getResultInterruptedError(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DatabaseException) {
                throw (DatabaseException)cause;
            }
            if (cause instanceof FMException) {
                if (allowedException1.isInstance(cause)) {
                    throw (FMException)allowedException1.cast(cause);
                }
                if (allowedException2.isInstance(cause)) {
                    throw (FMException)allowedException2.cast(cause);
                }
            }
            throw this.getResultError(cause);
        }
        return result;
    }

    @Override
    public Result<R> getResultAsync() {
        ResultImpl<R> result = new ResultImpl<R>(this.future);
        return result;
    }

    @Override
    public abstract R execute(DatabaseContext var1) throws Exception;

    protected String getContextName() {
        return Thread.currentThread().getName();
    }

    private void checkTransaction(DatabaseContext dbCtx) {
        EntityManager em = dbCtx.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        if (tx != null && tx.isActive()) {
            tx.rollback();
        }
    }

    private DatabaseException getResultError(Throwable cause) {
        DatabaseException dbe = new DatabaseException((IMessage)STLMessages.STL30014_DATABASE_CALL_EXECUTION_EXCEPTION, cause, cause.getClass().getSimpleName(), StringUtils.getErrorMessage(cause));
        log.error(StringUtils.getErrorMessage(dbe), cause);
        return dbe;
    }

    private DatabaseException getResultInterruptedError(InterruptedException e) {
        DatabaseException dbe = new DatabaseException((IMessage)STLMessages.STL30015_DATABASE_CALL_INTERRUPTION_EXCEPTION, (Throwable)e);
        log.debug(StringUtils.getErrorMessage(dbe), (Throwable)e);
        return dbe;
    }

    private void addClientTrace(Throwable t) {
        if (this.clientTrace != null) {
            t.addSuppressed(this.clientTrace);
        }
    }
}

