/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.datamanager.impl;

import com.intel.stl.api.DatabaseException;
import com.intel.stl.api.StartupProgressObserver;
import com.intel.stl.api.StringUtils;
import com.intel.stl.api.configuration.AppInfo;
import com.intel.stl.api.configuration.EventRule;
import com.intel.stl.api.configuration.UserNotFoundException;
import com.intel.stl.api.configuration.UserSettings;
import com.intel.stl.api.notice.NoticeBean;
import com.intel.stl.api.notice.impl.NoticeProcess;
import com.intel.stl.api.performance.GroupConfigRspBean;
import com.intel.stl.api.performance.GroupInfoBean;
import com.intel.stl.api.performance.GroupListBean;
import com.intel.stl.api.performance.ImageInfoBean;
import com.intel.stl.api.performance.PerformanceDataNotFoundException;
import com.intel.stl.api.performance.PortConfigBean;
import com.intel.stl.api.subnet.LinkRecordBean;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.api.subnet.SubnetDataNotFoundException;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.common.STLMessages;
import com.intel.stl.configuration.AppComponent;
import com.intel.stl.configuration.AppConfigurationException;
import com.intel.stl.configuration.AppSettings;
import com.intel.stl.datamanager.DatabaseManager;
import com.intel.stl.datamanager.DatabaseRecord;
import com.intel.stl.datamanager.GroupConfigId;
import com.intel.stl.datamanager.NoticeStatus;
import com.intel.stl.datamanager.SubnetRecord;
import com.intel.stl.datamanager.TopologyRecord;
import com.intel.stl.datamanager.UserRecord;
import com.intel.stl.datamanager.impl.DatabaseCallImpl;
import com.intel.stl.datamanager.impl.DatabaseMigrationHelper;
import com.intel.stl.dbengine.ConfigurationDAO;
import com.intel.stl.dbengine.DatabaseContext;
import com.intel.stl.dbengine.DatabaseEngine;
import com.intel.stl.dbengine.GroupDAO;
import com.intel.stl.dbengine.NoticeDAO;
import com.intel.stl.dbengine.PerformanceDAO;
import com.intel.stl.dbengine.Scheduler;
import com.intel.stl.dbengine.SubnetDAO;
import com.intel.stl.dbengine.impl.DatabaseServerImpl;
import com.intel.stl.dbengine.impl.DatabaseUtils;
import com.intel.stl.dbengine.impl.SchedulerImpl;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseManagerImpl
implements DatabaseManager,
AppComponent {
    private static final String DATABASEMANAGER_COMPONENT = STLMessages.STL10018_DATABASE_COMPONENT.getDescription();
    private static final String PROGRESS_MESSAGE = STLMessages.STL10025_STARTING_COMPONENT.getDescription(DATABASEMANAGER_COMPONENT);
    private static final String SHUTDOWN_MESSAGE = STLMessages.STL10026_STOPPING_COMPONENT.getDescription(DATABASEMANAGER_COMPONENT);
    protected static int THREAD_POOL_SIZE = 2;
    private static Logger log = LoggerFactory.getLogger(DatabaseManagerImpl.class);
    private final Scheduler scheduler;
    private final DatabaseEngine engine;
    private boolean compactNeeded = false;

    public DatabaseManagerImpl(DatabaseEngine engine) {
        this.engine = engine;
        DatabaseServerImpl server = new DatabaseServerImpl(engine);
        this.scheduler = new SchedulerImpl(server, THREAD_POOL_SIZE);
    }

    @Override
    public void initialize(AppSettings settings, StartupProgressObserver observer) throws AppConfigurationException {
        if (observer != null) {
            observer.setProgress(PROGRESS_MESSAGE);
        }
        log.info(STLMessages.STL30001_STARTING_DATABASE_ENGINE.getDescription(this.engine.getEngineName(), this.engine.getEngineVersion()));
        try {
            this.engine.start();
            AppInfo appInfo = this.engine.getAppInfo();
            if (appInfo == null || appInfo.getAppSchemaLevel() < settings.getAppSchemaLevel()) {
                this.updateSchema(settings, appInfo);
            } else if (!appInfo.getAppBuildId().equals(settings.getAppBuildId()) || !appInfo.getAppBuildDate().equals(settings.getAppBuildDate())) {
                this.saveAppInfo(appInfo, settings);
            }
        }
        catch (DatabaseException e) {
            String errMsg = STLMessages.STL10006_ERROR_STARTING_DATABASE_ENGINE.getDescription(this.engine.getEngineName(), this.engine.getEngineVersion(), StringUtils.getErrorMessage(e));
            log.error(errMsg, (Throwable)e);
            AppConfigurationException ace = new AppConfigurationException(errMsg, e);
            throw ace;
        }
        log.info("Database initialization finished");
    }

    @Override
    public String getComponentDescription() {
        return DATABASEMANAGER_COMPONENT;
    }

    @Override
    public int getInitializationWeight() {
        return 80;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(StartupProgressObserver observer) {
        if (observer != null) {
            observer.setProgress(SHUTDOWN_MESSAGE);
        }
        try {
            if (this.scheduler != null) {
                this.scheduler.shutdown();
            }
        }
        finally {
            if (this.engine != null) {
                if (observer != null && this.compactNeeded) {
                    observer.setProgress(STLMessages.STL10028_COMPACTING_DATABASE.getDescription());
                }
                try {
                    this.engine.stop(this.compactNeeded);
                }
                catch (DatabaseException e) {
                    log.error("Error during DatabaseEngine stop: ", (Throwable)e);
                }
            }
        }
    }

    @Override
    public AppInfo getAppInfo() {
        return this.engine.getAppInfo();
    }

    @Override
    public void saveAppProperties(Map<String, Properties> appProperties) {
        AppInfo appInfo = this.engine.getAppInfo();
        appInfo.setPropertiesMap(appProperties);
        this.engine.saveAppInfo(appInfo);
    }

    @Override
    public List<SubnetDescription> getSubnets() {
        DatabaseCallImpl<List<SubnetDescription>> call = new DatabaseCallImpl<List<SubnetDescription>>(){

            @Override
            public List<SubnetDescription> execute(DatabaseContext ctx) throws Exception {
                SubnetDAO subnetDao = ctx.getSubnetDAO();
                return subnetDao.getSubnets();
            }
        };
        this.scheduler.enqueue(call);
        return (List)call.getResult();
    }

    @Override
    public SubnetDescription getSubnet(final String subnetName) {
        DatabaseCallImpl<SubnetDescription> call = new DatabaseCallImpl<SubnetDescription>(){

            @Override
            public SubnetDescription execute(DatabaseContext ctx) throws Exception {
                SubnetDAO subnetDao = ctx.getSubnetDAO();
                SubnetRecord record = subnetDao.getSubnet(subnetName);
                if (record == null) {
                    return null;
                }
                return record.getSubnetDescription();
            }
        };
        this.scheduler.enqueue(call);
        return (SubnetDescription)call.getResult();
    }

    @Override
    public SubnetDescription getSubnet(final long subnetId) {
        DatabaseCallImpl<SubnetDescription> call = new DatabaseCallImpl<SubnetDescription>(){

            @Override
            public SubnetDescription execute(DatabaseContext ctx) throws Exception {
                SubnetDAO subnetDao = ctx.getSubnetDAO();
                SubnetRecord record = subnetDao.getSubnet(subnetId);
                if (record == null || !record.getUniqueName().startsWith("1")) {
                    return null;
                }
                return record.getSubnetDescription();
            }
        };
        this.scheduler.enqueue(call);
        return (SubnetDescription)call.getResult();
    }

    @Override
    public SubnetDescription defineSubnet(final SubnetDescription subnet) {
        DatabaseCallImpl<SubnetDescription> call = new DatabaseCallImpl<SubnetDescription>(){

            @Override
            public SubnetDescription execute(DatabaseContext ctx) throws Exception {
                SubnetDAO subnetDao = ctx.getSubnetDAO();
                return subnetDao.defineSubnet(subnet);
            }
        };
        this.scheduler.enqueue(call);
        return (SubnetDescription)call.getResult();
    }

    @Override
    public void updateSubnet(final SubnetDescription subnet) throws SubnetDataNotFoundException {
        DatabaseCallImpl<Void> call = new DatabaseCallImpl<Void>(){

            @Override
            public Void execute(DatabaseContext ctx) throws Exception {
                SubnetDAO subnetDao = ctx.getSubnetDAO();
                subnetDao.updateSubnet(subnet);
                return null;
            }
        };
        this.scheduler.enqueue(call);
        call.getResult(SubnetDataNotFoundException.class);
    }

    @Override
    public void removeSubnet(final long subnetId) throws SubnetDataNotFoundException {
        DatabaseCallImpl<Void> call = new DatabaseCallImpl<Void>(){

            @Override
            public Void execute(DatabaseContext ctx) throws Exception {
                SubnetDAO subnetDao = ctx.getSubnetDAO();
                subnetDao.removeSubnet(subnetId);
                return null;
            }
        };
        this.scheduler.enqueue(call);
        call.getResult(SubnetDataNotFoundException.class);
    }

    @Override
    public List<NodeRecordBean> getNodes(final String subnetName) throws SubnetDataNotFoundException {
        DatabaseCallImpl<List<NodeRecordBean>> call = new DatabaseCallImpl<List<NodeRecordBean>>(){

            @Override
            public List<NodeRecordBean> execute(DatabaseContext ctx) throws Exception {
                SubnetDAO subnetDao = ctx.getSubnetDAO();
                return subnetDao.getNodes(subnetName);
            }
        };
        this.scheduler.enqueue(call);
        return (List)call.getResult(SubnetDataNotFoundException.class);
    }

    @Override
    public NodeRecordBean getNode(final String subnetName, final long nodeGUID) throws SubnetDataNotFoundException {
        DatabaseCallImpl<NodeRecordBean> call = new DatabaseCallImpl<NodeRecordBean>(){

            @Override
            public NodeRecordBean execute(DatabaseContext ctx) throws Exception {
                SubnetDAO subnetDao = ctx.getSubnetDAO();
                return subnetDao.getNode(subnetName, nodeGUID);
            }
        };
        this.scheduler.enqueue(call);
        return (NodeRecordBean)call.getResult(SubnetDataNotFoundException.class);
    }

    @Override
    public NodeRecordBean getNode(final String subnetName, final int lid) throws SubnetDataNotFoundException {
        DatabaseCallImpl<NodeRecordBean> call = new DatabaseCallImpl<NodeRecordBean>(){

            @Override
            public NodeRecordBean execute(DatabaseContext ctx) throws Exception {
                SubnetDAO subnetDao = ctx.getSubnetDAO();
                return subnetDao.getNode(subnetName, lid);
            }
        };
        this.scheduler.enqueue(call);
        return (NodeRecordBean)call.getResult(SubnetDataNotFoundException.class);
    }

    @Override
    public NodeRecordBean getNodeByPortGUID(final String subnetName, final long portGuid) throws SubnetDataNotFoundException {
        DatabaseCallImpl<NodeRecordBean> call = new DatabaseCallImpl<NodeRecordBean>(){

            @Override
            public NodeRecordBean execute(DatabaseContext ctx) throws Exception {
                SubnetDAO subnetDao = ctx.getSubnetDAO();
                return subnetDao.getNodeByPortGUID(subnetName, portGuid);
            }
        };
        this.scheduler.enqueue(call);
        return (NodeRecordBean)call.getResult(SubnetDataNotFoundException.class);
    }

    @Override
    public List<LinkRecordBean> getLinks(final String subnetName) throws SubnetDataNotFoundException {
        DatabaseCallImpl<List<LinkRecordBean>> call = new DatabaseCallImpl<List<LinkRecordBean>>(){

            @Override
            public List<LinkRecordBean> execute(DatabaseContext ctx) throws Exception {
                SubnetDAO subnetDao = ctx.getSubnetDAO();
                return subnetDao.getLinks(subnetName);
            }
        };
        this.scheduler.enqueue(call);
        return (List)call.getResult(SubnetDataNotFoundException.class);
    }

    @Override
    public List<LinkRecordBean> getLinks(final String subnetName, final int lid) throws SubnetDataNotFoundException {
        DatabaseCallImpl<List<LinkRecordBean>> call = new DatabaseCallImpl<List<LinkRecordBean>>(){

            @Override
            public List<LinkRecordBean> execute(DatabaseContext ctx) throws Exception {
                SubnetDAO subnetDao = ctx.getSubnetDAO();
                return subnetDao.getLinks(subnetName, lid);
            }
        };
        this.scheduler.enqueue(call);
        return (List)call.getResult(SubnetDataNotFoundException.class);
    }

    @Override
    public LinkRecordBean getLinkBySource(final String subnetName, final int lid, final short portNum) throws SubnetDataNotFoundException {
        DatabaseCallImpl<LinkRecordBean> call = new DatabaseCallImpl<LinkRecordBean>(){

            @Override
            public LinkRecordBean execute(DatabaseContext ctx) throws Exception {
                SubnetDAO subnetDao = ctx.getSubnetDAO();
                return subnetDao.getLinkBySource(subnetName, lid, portNum);
            }
        };
        this.scheduler.enqueue(call);
        return (LinkRecordBean)call.getResult(SubnetDataNotFoundException.class);
    }

    @Override
    public LinkRecordBean getLinkByDestination(final String subnetName, final int lid, final short portNum) throws SubnetDataNotFoundException {
        DatabaseCallImpl<LinkRecordBean> call = new DatabaseCallImpl<LinkRecordBean>(){

            @Override
            public LinkRecordBean execute(DatabaseContext ctx) throws Exception {
                SubnetDAO subnetDao = ctx.getSubnetDAO();
                return subnetDao.getLinkByDestination(subnetName, lid, portNum);
            }
        };
        this.scheduler.enqueue(call);
        return (LinkRecordBean)call.getResult(SubnetDataNotFoundException.class);
    }

    @Override
    public EnumMap<NodeType, Integer> getNodeTypeDist(final String subnetName) throws SubnetDataNotFoundException {
        DatabaseCallImpl<EnumMap<NodeType, Integer>> call = new DatabaseCallImpl<EnumMap<NodeType, Integer>>(){

            @Override
            public EnumMap<NodeType, Integer> execute(DatabaseContext ctx) throws Exception {
                SubnetDAO subnetDao = ctx.getSubnetDAO();
                EnumMap<NodeType, Integer> nodeTypeDist = new EnumMap<NodeType, Integer>(NodeType.class);
                TopologyRecord topology = subnetDao.getTopology(subnetName);
                nodeTypeDist.put(NodeType.HFI, (int)topology.getNumCAs());
                nodeTypeDist.put(NodeType.ROUTER, topology.getNumRouters());
                nodeTypeDist.put(NodeType.SWITCH, (int)topology.getNumSwitches());
                nodeTypeDist.put(NodeType.UNKNOWN, topology.getNumUnknown());
                return nodeTypeDist;
            }
        };
        this.scheduler.enqueue(call);
        return (EnumMap)call.getResult(SubnetDataNotFoundException.class);
    }

    @Override
    public void saveEventRules(final List<EventRule> rules) {
        DatabaseCallImpl<Void> call = new DatabaseCallImpl<Void>(){

            @Override
            public Void execute(DatabaseContext ctx) throws Exception {
                ConfigurationDAO configDao = ctx.getConfigurationDAO();
                configDao.saveEventRules(rules);
                return null;
            }
        };
        this.scheduler.enqueue(call);
        call.getResult();
    }

    @Override
    public List<EventRule> getEventRules() {
        DatabaseCallImpl<List<EventRule>> call = new DatabaseCallImpl<List<EventRule>>(){

            @Override
            public List<EventRule> execute(DatabaseContext ctx) throws Exception {
                ConfigurationDAO configDao = ctx.getConfigurationDAO();
                return configDao.getEventRules();
            }
        };
        this.scheduler.enqueue(call);
        return (List)call.getResult();
    }

    @Override
    public void saveTopology(final String subnetName, final List<NodeRecordBean> nodes, final List<LinkRecordBean> links) throws SubnetDataNotFoundException {
        DatabaseCallImpl<Void> call = new DatabaseCallImpl<Void>(){

            @Override
            public Void execute(DatabaseContext ctx) throws Exception {
                SubnetDAO subnetDao = ctx.getSubnetDAO();
                subnetDao.saveTopology(subnetName, nodes, links);
                return null;
            }
        };
        this.scheduler.enqueue(call);
        call.getResult(SubnetDataNotFoundException.class);
    }

    @Override
    public long getTopologyId(final String subnetName) throws SubnetDataNotFoundException {
        DatabaseCallImpl<Long> call = new DatabaseCallImpl<Long>(){

            @Override
            public Long execute(DatabaseContext ctx) throws Exception {
                SubnetDAO subnetDao = ctx.getSubnetDAO();
                return subnetDao.getTopology(subnetName).getId();
            }
        };
        this.scheduler.enqueue(call);
        return (Long)call.getResult(SubnetDataNotFoundException.class);
    }

    @Override
    public UserSettings getUserSettings(final String subnetName, final String userName) throws UserNotFoundException {
        DatabaseCallImpl<UserSettings> call = new DatabaseCallImpl<UserSettings>(){

            @Override
            public UserSettings execute(DatabaseContext ctx) throws Exception {
                ConfigurationDAO configDao = ctx.getConfigurationDAO();
                SubnetDAO subnetDao = ctx.getSubnetDAO();
                SubnetRecord subnet = subnetDao.getSubnet(subnetName);
                return configDao.getUserSettings(subnet, userName);
            }
        };
        this.scheduler.enqueue(call);
        return (UserSettings)call.getResult(UserNotFoundException.class);
    }

    @Override
    public void saveUserSettings(final String subnetName, final UserSettings userSettings) {
        DatabaseCallImpl<DatabaseRecord> call = new DatabaseCallImpl<DatabaseRecord>(){

            @Override
            public DatabaseRecord execute(DatabaseContext ctx) throws Exception {
                ConfigurationDAO configDao = ctx.getConfigurationDAO();
                configDao.saveUserSettings(ctx.getSubnet(subnetName), userSettings);
                return null;
            }
        };
        this.scheduler.enqueue(call);
        call.getResult();
    }

    @Override
    public void saveGroupConfig(final String subnetName, final String groupName, final List<PortConfigBean> ports) {
        DatabaseCallImpl<Void> call = new DatabaseCallImpl<Void>(){

            @Override
            public Void execute(DatabaseContext ctx) throws Exception {
                GroupDAO groupDao = ctx.getGroupDAO();
                groupDao.saveGroupConfig(ctx.getSubnet(subnetName), groupName, ports);
                return null;
            }
        };
        this.scheduler.enqueue(call);
        call.getResult();
    }

    @Override
    public void saveGroupList(final String subnetName, final List<GroupListBean> groupList) {
        DatabaseCallImpl<Void> call = new DatabaseCallImpl<Void>(){

            @Override
            public Void execute(DatabaseContext ctx) throws Exception {
                GroupDAO groupDao = ctx.getGroupDAO();
                groupDao.saveGroupList(ctx.getSubnet(subnetName), groupList);
                return null;
            }
        };
        this.scheduler.enqueue(call);
        call.getResult();
    }

    @Override
    public List<GroupConfigRspBean> getGroupConfig(final String subnetName, final String groupName) throws PerformanceDataNotFoundException {
        DatabaseCallImpl<List<GroupConfigRspBean>> call = new DatabaseCallImpl<List<GroupConfigRspBean>>(){

            @Override
            public List<GroupConfigRspBean> execute(DatabaseContext ctx) throws Exception {
                GroupDAO groupDao = ctx.getGroupDAO();
                SubnetRecord subnet = ctx.getSubnet(subnetName);
                GroupConfigId configId = new GroupConfigId();
                configId.setFabricId(subnet.getId());
                configId.setSubnetGroup(groupName);
                List<PortConfigBean> ports = groupDao.getGroupConfig(configId);
                ArrayList<GroupConfigRspBean> res = new ArrayList<GroupConfigRspBean>(ports.size());
                for (PortConfigBean port : ports) {
                    GroupConfigRspBean gcRspBean = new GroupConfigRspBean();
                    gcRspBean.setPort(port);
                    res.add(gcRspBean);
                }
                return res;
            }
        };
        this.scheduler.enqueue(call);
        return (List)call.getResult(PerformanceDataNotFoundException.class);
    }

    @Override
    public List<PortConfigBean> getPortConfig(final String subnetName) throws PerformanceDataNotFoundException {
        DatabaseCallImpl<List<PortConfigBean>> call = new DatabaseCallImpl<List<PortConfigBean>>(){

            @Override
            public List<PortConfigBean> execute(DatabaseContext ctx) throws Exception {
                GroupDAO groupDao = ctx.getGroupDAO();
                return groupDao.getPortConfig(ctx.getSubnet(subnetName));
            }
        };
        this.scheduler.enqueue(call);
        return (List)call.getResult(PerformanceDataNotFoundException.class);
    }

    @Override
    public void saveGroupInfos(final String subnetName, final List<GroupInfoBean> groupInfoBeans) {
        DatabaseCallImpl<Void> call = new DatabaseCallImpl<Void>(){

            @Override
            public Void execute(DatabaseContext ctx) throws Exception {
                GroupDAO groupDao = ctx.getGroupDAO();
                groupDao.saveGroupInfos(ctx.getSubnet(subnetName), groupInfoBeans);
                return null;
            }
        };
        this.scheduler.enqueue(call);
        call.getResult();
    }

    @Override
    public int purgeGroupInfos(final String subnetName, final long ago) {
        DatabaseCallImpl<Integer> call = new DatabaseCallImpl<Integer>(){

            @Override
            public Integer execute(DatabaseContext ctx) throws Exception {
                GroupDAO groupDao = ctx.getGroupDAO();
                int deleted = groupDao.purgeGroupInfos(ctx.getSubnet(subnetName), ago);
                return deleted;
            }
        };
        this.scheduler.enqueue(call);
        int count = (Integer)call.getResult();
        this.compactNeeded = true;
        return count;
    }

    @Override
    public void saveImageInfos(final String subnetName, final List<ImageInfoBean> imageInfoBeans) {
        DatabaseCallImpl<Void> call = new DatabaseCallImpl<Void>(){

            @Override
            public Void execute(DatabaseContext ctx) throws Exception {
                PerformanceDAO performanceDao = ctx.getPerformanceDAO();
                performanceDao.saveImageInfos(ctx.getSubnet(subnetName), imageInfoBeans);
                return null;
            }
        };
        this.scheduler.enqueue(call);
        call.getResult();
    }

    @Override
    public List<GroupInfoBean> getGroupInfo(final String subnetName, final String groupName, final long startTime, final long stopTime) throws PerformanceDataNotFoundException {
        DatabaseCallImpl<List<GroupInfoBean>> call = new DatabaseCallImpl<List<GroupInfoBean>>(){

            @Override
            public List<GroupInfoBean> execute(DatabaseContext ctx) throws Exception {
                GroupDAO groupDao = ctx.getGroupDAO();
                return groupDao.getGroupInfoList(ctx.getSubnet(subnetName), groupName, startTime, stopTime);
            }
        };
        this.scheduler.enqueue(call);
        return (List)call.getResult(PerformanceDataNotFoundException.class);
    }

    @Override
    public void saveNotices(final String subnetName, final NoticeBean[] notices) {
        DatabaseCallImpl<Void> call = new DatabaseCallImpl<Void>(){

            @Override
            public Void execute(DatabaseContext ctx) throws Exception {
                NoticeDAO noticeDao = ctx.getNoticeDAO();
                noticeDao.saveNotices(ctx.getSubnet(subnetName), notices);
                return null;
            }
        };
        this.scheduler.enqueue(call);
        call.getResult();
    }

    @Override
    public Future<Boolean> processNotices(final String subnetName, final List<NoticeProcess> notices) {
        DatabaseCallImpl<Boolean> call = new DatabaseCallImpl<Boolean>(){

            @Override
            public Boolean execute(DatabaseContext ctx) throws Exception {
                NoticeDAO noticeDao = ctx.getNoticeDAO();
                return noticeDao.processNotices(ctx.getSubnet(subnetName), notices);
            }
        };
        return this.scheduler.enqueue(call);
    }

    @Override
    public List<NoticeBean> getNotices(final String subnetName, final NoticeStatus status) {
        DatabaseCallImpl<List<NoticeBean>> call = new DatabaseCallImpl<List<NoticeBean>>(){

            @Override
            public List<NoticeBean> execute(DatabaseContext ctx) throws Exception {
                NoticeDAO noticeDao = ctx.getNoticeDAO();
                return noticeDao.getNotices(ctx.getSubnet(subnetName), status);
            }
        };
        this.scheduler.enqueue(call);
        return (List)call.getResult();
    }

    @Override
    public List<NoticeBean> getNotices(final String subnetName, final NoticeStatus status, final NoticeStatus newStatus) {
        DatabaseCallImpl<List<NoticeBean>> call = new DatabaseCallImpl<List<NoticeBean>>(){

            @Override
            public List<NoticeBean> execute(DatabaseContext ctx) throws Exception {
                NoticeDAO noticeDao = ctx.getNoticeDAO();
                return noticeDao.getNotices(ctx.getSubnet(subnetName), status, newStatus);
            }
        };
        this.scheduler.enqueue(call);
        return (List)call.getResult();
    }

    @Override
    public void resetNotices(final String subnetName) {
        DatabaseCallImpl<Void> call = new DatabaseCallImpl<Void>(){

            @Override
            public Void execute(DatabaseContext ctx) throws Exception {
                NoticeDAO noticeDao = ctx.getNoticeDAO();
                noticeDao.resetNotices(ctx.getSubnet(subnetName));
                return null;
            }
        };
        this.scheduler.enqueue(call);
        call.getResult();
    }

    @Override
    public void updateNotice(final String subnetName, final long noticeId, final NoticeStatus noticeStatus) {
        DatabaseCallImpl<Void> call = new DatabaseCallImpl<Void>(){

            @Override
            public Void execute(DatabaseContext ctx) throws Exception {
                NoticeDAO noticeDao = ctx.getNoticeDAO();
                noticeDao.updateNotice(ctx.getSubnet(subnetName), noticeId, noticeStatus);
                return null;
            }
        };
        this.scheduler.enqueue(call);
        call.getResult();
    }

    private void updateSchema(AppSettings settings, AppInfo appInfo) throws AppConfigurationException {
        EntityManager em;
        int schemaLevel = settings.getAppSchemaLevel();
        log.info(STLMessages.STL30010_STARTING_SCHEMA_UPDATE.getDescription(schemaLevel));
        if (appInfo == null) {
            appInfo = new AppInfo();
        }
        List<SubnetRecord> subnets = null;
        List<UserRecord> users = null;
        try {
            em = this.engine.getEntityManager();
            subnets = DatabaseMigrationHelper.getSubnetRecords(em);
            users = DatabaseMigrationHelper.getUserRecords(em);
            em.clear();
            em.close();
        }
        catch (Exception e) {
            log.error("Could not retrieve previous database definitions: " + StringUtils.getErrorMessage(e));
        }
        try {
            this.engine.updateSchema();
            DatabaseUtils.populateRequiredTables(this.engine.getEntityManager());
            this.saveAppInfo(appInfo, settings);
        }
        catch (AppConfigurationException ace) {
            throw ace;
        }
        catch (Exception e) {
            String msg = STLMessages.STL30011_ERROR_UPDATING_SCHEMA.getDescription(schemaLevel);
            log.error(msg, (Throwable)e);
            AppConfigurationException ace = new AppConfigurationException(msg, e);
            throw ace;
        }
        try {
            em = this.engine.getEntityManager();
            if (subnets != null) {
                for (SubnetRecord subnet : subnets) {
                    long id = subnet.getId();
                    subnet.setId(0L);
                    subnet.setTopology(null);
                    SubnetRecord newRec = DatabaseMigrationHelper.insertSubnetRecord(em, subnet);
                    if (users == null) continue;
                    for (UserRecord user : users) {
                        if (user.getId().getFabricId() != id) continue;
                        user.getId().setFabricId(newRec.getId());
                        DatabaseMigrationHelper.insertUserRecord(em, user);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Could not save previous database definitions: " + StringUtils.getErrorMessage(e), (Throwable)e);
        }
        log.info("Schema updated.");
    }

    private void saveAppInfo(AppInfo appInfo, AppSettings settings) throws AppConfigurationException {
        log.info("Save AppSettings: " + settings.getAppName() + " " + settings.getAppVersion() + " " + settings.getAppBuildId() + " " + settings.getAppBuildDate());
        appInfo.setAppName(settings.getAppName());
        appInfo.setAppVersion(settings.getAppVersion());
        appInfo.setAppRelease(settings.getAppRelease());
        appInfo.setAppModLevel(settings.getAppModLevel());
        appInfo.setOpaFmVersion(settings.getOpaFmVersion());
        appInfo.setAppBuildId(settings.getAppBuildId());
        appInfo.setAppBuildDate(settings.getAppBuildDate());
        appInfo.setAppSchemaLevel(settings.getAppSchemaLevel());
        this.engine.saveAppInfo(appInfo);
    }
}

