/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.dbengine.impl;

import com.intel.stl.api.DatabaseException;
import com.intel.stl.api.IMessage;
import com.intel.stl.api.StringUtils;
import com.intel.stl.api.configuration.EventRule;
import com.intel.stl.api.configuration.EventRuleAction;
import com.intel.stl.api.configuration.UserSettings;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.common.AppDataUtils;
import com.intel.stl.common.STLMessages;
import com.intel.stl.datamanager.EventActionRecord;
import com.intel.stl.datamanager.EventRuleRecord;
import com.intel.stl.datamanager.SubnetRecord;
import com.intel.stl.datamanager.UserId;
import com.intel.stl.datamanager.UserRecord;
import com.intel.stl.dbengine.ConfigurationDAO;
import com.intel.stl.dbengine.DatabaseContext;
import com.intel.stl.dbengine.impl.BaseDAO;
import com.intel.stl.xml.UserOptions;
import com.intel.stl.xml.UserOptionsMarshaller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EntityTransaction;
import javax.persistence.TypedQuery;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationDAOImpl
extends BaseDAO
implements ConfigurationDAO {
    private static Logger log = LoggerFactory.getLogger(ConfigurationDAOImpl.class);

    public ConfigurationDAOImpl(EntityManager entityManager) {
        super(entityManager);
    }

    public ConfigurationDAOImpl(EntityManager entityManager, DatabaseContext databaseCtx) {
        super(entityManager, databaseCtx);
    }

    @Override
    public void saveEventRule(EventRule rule) {
        EventRuleRecord dbRule = (EventRuleRecord)this.em.find(EventRuleRecord.class, (Object)rule.getEventName());
        EntityTransaction tx = this.em.getTransaction();
        tx.begin();
        if (dbRule == null) {
            this.persistEventRule(rule);
        } else {
            this.mergeEventRule(dbRule, rule);
        }
        try {
            tx.commit();
        }
        catch (Exception e) {
            DatabaseException dbe = new DatabaseException((IMessage)STLMessages.STL30013_ERROR_SAVING_ENTITY, "EventRule", rule.getEventName(), StringUtils.getErrorMessage(e));
            log.error(StringUtils.getErrorMessage(dbe), (Throwable)e);
            log.error(rule.toString());
            throw dbe;
        }
    }

    @Override
    public void saveEventRules(List<EventRule> rules) {
        List<EventRuleRecord> currRules = this.getEventRuleRecords();
        EntityTransaction tx = this.em.getTransaction();
        tx.begin();
        for (EventRuleRecord eventRuleRecord : currRules) {
            if (rules.contains(eventRuleRecord.getEventRule())) continue;
            this.em.remove((Object)eventRuleRecord);
        }
        for (EventRule eventRule : rules) {
            EventRuleRecord ruleRec = new EventRuleRecord(eventRule);
            int x = currRules.indexOf(ruleRec);
            if (x >= 0) {
                EventRuleRecord dbRule = currRules.get(x);
                this.mergeEventRule(dbRule, eventRule);
                continue;
            }
            this.persistEventRule(eventRule);
        }
        try {
            tx.commit();
        }
        catch (Exception e) {
            DatabaseException databaseException = new DatabaseException((IMessage)STLMessages.STL30013_ERROR_SAVING_ENTITY, "EventRule", "@log", StringUtils.getErrorMessage(e));
            log.error(StringUtils.getErrorMessage(databaseException), (Throwable)e);
            log.error(Arrays.toString(rules.toArray()));
            throw databaseException;
        }
    }

    @Override
    public List<EventRule> getEventRules() {
        ArrayList<EventRule> rules = new ArrayList<EventRule>();
        List<EventRuleRecord> ruleRecs = this.getEventRuleRecords();
        for (EventRuleRecord ruleRec : ruleRecs) {
            rules.add(ruleRec.getEventRule());
        }
        return rules;
    }

    private List<EventRuleRecord> getEventRuleRecords() {
        TypedQuery query = this.em.createNamedQuery("EventRule.All", EventRuleRecord.class);
        return query.getResultList();
    }

    @Override
    public EventRule getEventRule(String ruleName) {
        EventRuleRecord record = (EventRuleRecord)this.em.find(EventRuleRecord.class, (Object)ruleName);
        if (record == null) {
            return null;
        }
        return record.getEventRule();
    }

    private void persistEventRule(EventRule rule) throws DatabaseException {
        EventRuleRecord ruleRec = new EventRuleRecord(rule);
        HashSet<SubnetRecord> managedSubnets = new HashSet<SubnetRecord>();
        Set<SubnetDescription> eventSubnets = rule.getEventSubnets();
        if (eventSubnets != null) {
            for (SubnetDescription subnet : eventSubnets) {
                this.addSubnetToSet(managedSubnets, subnet);
            }
        }
        ruleRec.setEventSubnets(managedSubnets);
        HashSet<EventActionRecord> managedActions = new HashSet<EventActionRecord>();
        List<EventRuleAction> eventActions = rule.getEventActions();
        if (eventActions != null) {
            for (EventRuleAction action : eventActions) {
                EventActionRecord actionRec = new EventActionRecord();
                actionRec.setId(action.name());
                managedActions.add(actionRec);
            }
        }
        ruleRec.setEventActions(managedActions);
        this.em.persist((Object)ruleRec);
    }

    private void mergeEventRule(EventRuleRecord ruleRec, EventRule newRule) throws DatabaseException {
        ruleRec.setEventRule(newRule);
        Set<SubnetRecord> newSubnets = this.getEventSubnets(newRule);
        Set<SubnetRecord> dbSubnets = ruleRec.getEventSubnets();
        dbSubnets.retainAll(newSubnets);
        newSubnets.removeAll(dbSubnets);
        for (SubnetRecord subnet : newSubnets) {
            this.addSubnetToSet(dbSubnets, subnet.getSubnetDescription());
        }
        this.em.merge((Object)ruleRec);
    }

    private void addSubnetToSet(Set<SubnetRecord> set, SubnetDescription subnet) throws DatabaseException {
        try {
            set.add((SubnetRecord)this.em.getReference(SubnetRecord.class, (Object)subnet.getSubnetId()));
        }
        catch (EntityNotFoundException enf) {
            DatabaseException dbe = new DatabaseException((IMessage)STLMessages.STL30012_ENTITY_NOT_FOUND, (Throwable)enf, "SubnetDescription", subnet.getName());
            throw dbe;
        }
    }

    private Set<SubnetRecord> getEventSubnets(EventRule rule) {
        HashSet<SubnetRecord> subnets = new HashSet<SubnetRecord>();
        Set<SubnetDescription> newSubnets = rule.getEventSubnets();
        for (SubnetDescription subnet : newSubnets) {
            SubnetRecord subnetRec = new SubnetRecord(subnet);
            subnets.add(subnetRec);
        }
        return subnets;
    }

    @Override
    public UserSettings getUserSettings(SubnetRecord subnet, String userName) {
        if (subnet == null) {
            subnet = new SubnetRecord();
        }
        UserId userId = new UserId();
        userId.setFabricId(subnet.getId());
        userId.setUserName(userName);
        UserRecord user = (UserRecord)this.em.find(UserRecord.class, (Object)userId);
        if (user == null) {
            user = new UserRecord();
            user.setId(userId);
            user.setUserDescription("Default User");
            user.setUserOptionsXml(AppDataUtils.getDefaultUserOptions());
        }
        UserSettings settings = new UserSettings();
        settings.setUserName(user.getId().getUserName());
        settings.setUserDescription(user.getUserDescription());
        String userOptions = user.getUserOptionsXml();
        if (userOptions == null) {
            userOptions = AppDataUtils.getDefaultUserOptions();
        }
        try {
            UserOptions options = UserOptionsMarshaller.unmarshal(userOptions);
            settings.setPreferences(options.getPreferences());
            settings.setEventRules(options.getEventRules());
            settings.setPropertiesDisplayOptions(options.getPropertiesDisplay());
        }
        catch (JAXBException e) {
            DatabaseException dbe = this.createUserOptionsXmlException(userName, (Exception)((Object)e));
            throw dbe;
        }
        return settings;
    }

    @Override
    public void saveUserSettings(SubnetRecord subnet, UserSettings userSettings) {
        UserId userId = new UserId();
        userId.setFabricId(subnet.getId());
        userId.setUserName(userSettings.getUserName());
        UserRecord dbUser = (UserRecord)this.em.find(UserRecord.class, (Object)userId);
        EntityTransaction tx = this.em.getTransaction();
        tx.begin();
        if (dbUser == null) {
            UserRecord user = new UserRecord();
            user.setId(userId);
            this.mergeUserSettings(user, userSettings);
            this.em.persist((Object)user);
        } else {
            this.mergeUserSettings(dbUser, userSettings);
            this.em.merge((Object)dbUser);
        }
        try {
            tx.commit();
        }
        catch (Exception e) {
            DatabaseException dbe = new DatabaseException((IMessage)STLMessages.STL30013_ERROR_SAVING_ENTITY, "UserRecord", userSettings.getUserName(), StringUtils.getErrorMessage(e));
            log.error(StringUtils.getErrorMessage(dbe), (Throwable)e);
            log.error(userSettings.toString());
            throw dbe;
        }
    }

    private void mergeUserSettings(UserRecord record, UserSettings settings) {
        record.setUserDescription(settings.getUserDescription());
        UserOptions options = new UserOptions();
        options.setPreferences(settings.getPreferences());
        options.setEventRules(settings.getEventRules());
        options.setPropertiesDisplay(settings.getPropertiesDisplayOptions());
        String strOptions = null;
        try {
            strOptions = UserOptionsMarshaller.marshal(options);
        }
        catch (JAXBException e) {
            DatabaseException dbe = this.createUserOptionsXmlException(settings.getUserName(), (Exception)((Object)e));
            throw dbe;
        }
        record.setUserOptionsXml(strOptions);
    }

    private DatabaseException createUserOptionsXmlException(String userName, Exception e) {
        DatabaseException dbe = new DatabaseException((IMessage)STLMessages.STL30071_INVALID_USEROPTIONS_XML, (Throwable)e, userName, StringUtils.getErrorMessage(e));
        log.error(StringUtils.getErrorMessage(dbe), (Throwable)e);
        return dbe;
    }
}

