/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.dbengine.impl;

import com.intel.stl.api.configuration.ConfigurationException;
import com.intel.stl.api.failure.IFailureManagement;
import com.intel.stl.common.STLMessages;
import com.intel.stl.datamanager.SubnetRecord;
import com.intel.stl.dbengine.ConfigurationDAO;
import com.intel.stl.dbengine.DatabaseContext;
import com.intel.stl.dbengine.GroupDAO;
import com.intel.stl.dbengine.NoticeDAO;
import com.intel.stl.dbengine.PerformanceDAO;
import com.intel.stl.dbengine.SubnetDAO;
import com.intel.stl.dbengine.impl.ConfigurationDAOImpl;
import com.intel.stl.dbengine.impl.GroupDAOImpl;
import com.intel.stl.dbengine.impl.NoticeDAOImpl;
import com.intel.stl.dbengine.impl.PerformanceDAOImpl;
import com.intel.stl.dbengine.impl.SubnetDAOImpl;
import javax.persistence.EntityManager;

public class DatabaseContextImpl
implements DatabaseContext {
    private final EntityManager em;
    private ConfigurationDAO configurationDAO;
    private GroupDAO groupDAO;
    private NoticeDAO noticeDAO;
    private final SubnetDAO subnetDAO;
    private final PerformanceDAO performanceDAO;
    private final IFailureManagement failureMgr;
    private long lastUsed;

    public DatabaseContextImpl(EntityManager em, IFailureManagement failureMgr) {
        this.em = em;
        this.failureMgr = failureMgr;
        this.subnetDAO = new SubnetDAOImpl(em, this);
        this.performanceDAO = new PerformanceDAOImpl(em, this);
    }

    @Override
    public EntityManager getEntityManager() {
        return this.em;
    }

    @Override
    public IFailureManagement getFailureManagement() {
        return this.failureMgr;
    }

    @Override
    public SubnetRecord getSubnet(String subnetName) {
        SubnetRecord subnet = this.subnetDAO.getSubnet(subnetName);
        if (subnet == null) {
            ConfigurationException ce = new ConfigurationException(STLMessages.STL30022_SUBNET_NOT_FOUND, subnetName);
            throw ce;
        }
        return subnet;
    }

    @Override
    public ConfigurationDAO getConfigurationDAO() {
        if (this.configurationDAO == null) {
            this.configurationDAO = new ConfigurationDAOImpl(this.em, this);
        }
        return this.configurationDAO;
    }

    @Override
    public GroupDAO getGroupDAO() {
        if (this.groupDAO == null) {
            this.groupDAO = new GroupDAOImpl(this.em, this);
        }
        return this.groupDAO;
    }

    @Override
    public NoticeDAO getNoticeDAO() {
        if (this.noticeDAO == null) {
            this.noticeDAO = new NoticeDAOImpl(this.em, this);
        }
        return this.noticeDAO;
    }

    @Override
    public SubnetDAO getSubnetDAO() {
        return this.subnetDAO;
    }

    @Override
    public PerformanceDAO getPerformanceDAO() {
        return this.performanceDAO;
    }

    protected long getLastUsed() {
        return this.lastUsed;
    }

    protected void setLastUsed(long lastUsed) {
        this.lastUsed = lastUsed;
    }
}

