/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.dbengine.impl;

import com.intel.stl.api.DatabaseException;
import com.intel.stl.api.IMessage;
import com.intel.stl.api.performance.ImageInfoBean;
import com.intel.stl.api.performance.PerformanceDataNotFoundException;
import com.intel.stl.common.STLMessages;
import com.intel.stl.datamanager.ImageInfoId;
import com.intel.stl.datamanager.ImageInfoRecord;
import com.intel.stl.datamanager.SubnetRecord;
import com.intel.stl.dbengine.DatabaseContext;
import com.intel.stl.dbengine.PerformanceDAO;
import com.intel.stl.dbengine.impl.BaseDAO;
import com.intel.stl.dbengine.impl.DatabaseUtils;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceDAOImpl
extends BaseDAO
implements PerformanceDAO {
    private static Logger log = LoggerFactory.getLogger((String)"org.hibernate.SQL");

    public PerformanceDAOImpl(EntityManager entityManager) {
        super(entityManager);
    }

    public PerformanceDAOImpl(EntityManager entityManager, DatabaseContext databaseCtx) {
        super(entityManager, databaseCtx);
    }

    @Override
    public void saveImageInfos(SubnetRecord subnet, List<ImageInfoBean> imageInfos) {
        StringBuffer keys = new StringBuffer();
        keys.append(subnet.getSubnetDescription().getName());
        int separator = 124;
        this.startTransaction();
        long subnetId = subnet.getId();
        for (ImageInfoBean imageInfo : imageInfos) {
            ImageInfoId id = new ImageInfoId();
            id.setFabricId(subnetId);
            long sweepTimestamp = imageInfo.getSweepStart();
            id.setSweepTimestamp(sweepTimestamp);
            ImageInfoRecord imageRecord = (ImageInfoRecord)this.em.find(ImageInfoRecord.class, (Object)id);
            if (imageRecord == null) {
                imageRecord = new ImageInfoRecord(subnetId, imageInfo);
                this.em.persist((Object)imageRecord);
            } else {
                imageRecord.setImageInfo(imageInfo);
                this.em.merge((Object)imageRecord);
            }
            keys.append((char)separator);
            keys.append(sweepTimestamp);
            separator = 44;
        }
        try {
            this.commitTransaction();
        }
        catch (Exception e) {
            DatabaseException dbe = DatabaseUtils.createPersistDatabaseException(e, ImageInfoRecord.class, keys);
            log.error(dbe.getMessage(), (Throwable)e);
            throw dbe;
        }
    }

    @Override
    public List<ImageInfoBean> getImageInfo(SubnetRecord subnet, long imageNumber) throws PerformanceDataNotFoundException {
        TypedQuery query = this.em.createNamedQuery("ImageInfo.findByImageNum", ImageInfoBean.class);
        query.setParameter("subnetId", (Object)subnet.getId());
        query.setParameter("imageNumber", (Object)imageNumber);
        List imageInfos = query.getResultList();
        if (imageInfos == null || imageInfos.size() == 0) {
            PerformanceDataNotFoundException pdnf = new PerformanceDataNotFoundException((IMessage)STLMessages.STL30070_IMAGE_NUMBER_NOT_FOUND, imageNumber, subnet.getSubnetDescription().getName());
            throw pdnf;
        }
        return imageInfos;
    }

    @Override
    public ImageInfoBean getLastImageInfo(SubnetRecord subnet) throws PerformanceDataNotFoundException {
        TypedQuery query = this.em.createNamedQuery("ImageInfo.findLatest", Long.class);
        query.setParameter("subnetId", (Object)subnet.getId());
        Long latestSweepstart = (Long)query.getSingleResult();
        if (latestSweepstart == null) {
            PerformanceDataNotFoundException pdnf = new PerformanceDataNotFoundException((IMessage)STLMessages.STL30069_NO_IMAGEINFO, subnet.getSubnetDescription().getName());
            throw pdnf;
        }
        ImageInfoId id = new ImageInfoId();
        id.setFabricId(subnet.getId());
        id.setSweepTimestamp(latestSweepstart);
        ImageInfoRecord latest = (ImageInfoRecord)this.em.find(ImageInfoRecord.class, (Object)id);
        return latest.getImageInfo();
    }
}

