/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.adapter;

import com.intel.stl.api.CertsDescription;
import com.intel.stl.api.ICertsAssistant;
import com.intel.stl.api.ISecurityHandler;
import com.intel.stl.api.StartupProgressObserver;
import com.intel.stl.api.Utils;
import com.intel.stl.api.failure.BaseFailureEvaluator;
import com.intel.stl.api.failure.FailureManager;
import com.intel.stl.api.failure.IFailureEvaluator;
import com.intel.stl.api.failure.IFailureManagement;
import com.intel.stl.api.subnet.HostInfo;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.common.STLMessages;
import com.intel.stl.configuration.AppComponent;
import com.intel.stl.configuration.AppConfigurationException;
import com.intel.stl.configuration.AppSettings;
import com.intel.stl.configuration.AsyncTask;
import com.intel.stl.configuration.ResultHandler;
import com.intel.stl.configuration.SerialProcessingService;
import com.intel.stl.datamanager.DatabaseManager;
import com.intel.stl.fecdriver.IFailoverHelper;
import com.intel.stl.fecdriver.IFailoverManager;
import com.intel.stl.fecdriver.adapter.IAdapter;
import com.intel.stl.fecdriver.adapter.ISMEventListener;
import com.intel.stl.fecdriver.dispatcher.IConnectionEventListener;
import com.intel.stl.fecdriver.dispatcher.IRequestDispatcher;
import com.intel.stl.fecdriver.dispatcher.ITempRequestDispatcher;
import com.intel.stl.fecdriver.dispatcher.SMFailoverManager;
import com.intel.stl.fecdriver.dispatcher.SubnetRequestDispatcher;
import com.intel.stl.fecdriver.dispatcher.TempRequestDispatcher;
import com.intel.stl.fecdriver.session.ISession;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FEAdapter
implements AppComponent,
IAdapter,
IFailoverHelper {
    private static Logger log = LoggerFactory.getLogger(FEAdapter.class);
    private static final String ADAPTER_COMPONENT = STLMessages.STL10027_FE_ADAPTER.getDescription();
    private static final String PROGRESS_MESSAGE = STLMessages.STL10025_STARTING_COMPONENT.getDescription(ADAPTER_COMPONENT);
    private static final String SHUTDOWN_MESSAGE = STLMessages.STL10026_STOPPING_COMPONENT.getDescription(ADAPTER_COMPONENT);
    private final ConcurrentHashMap<SubnetDescription, IRequestDispatcher> cachedDispatchers = new ConcurrentHashMap();
    public static String SM_FAILOVER_TIMEOUT = "120";
    private long failoverTimeout = 120000L;
    private final Map<String, KeyManagerFactory> cachedKeyFactories = new HashMap<String, KeyManagerFactory>();
    private final Map<String, TrustManagerFactory> cachedTrustFactories = new HashMap<String, TrustManagerFactory>();
    private final AtomicReference<ITempRequestDispatcher> tempreqDispatcher = new AtomicReference();
    private final IFailureManagement failureMgr;
    private final BaseFailureEvaluator failureEvaluator;
    private final DatabaseManager dbMgr;
    private final SerialProcessingService procService;

    public FEAdapter(DatabaseManager dbMgr, SerialProcessingService procService) {
        this.dbMgr = dbMgr;
        this.procService = procService;
        this.failureEvaluator = new BaseFailureEvaluator();
        this.failureEvaluator.setRecoverableErrors(IOException.class, RuntimeException.class);
        this.failureEvaluator.setUnrecoverableErrors(ClosedChannelException.class, SSLHandshakeException.class);
        this.failureMgr = FailureManager.getManager();
    }

    @Override
    public void initialize(AppSettings settings, StartupProgressObserver observer) throws AppConfigurationException {
        if (observer != null) {
            observer.setProgress(PROGRESS_MESSAGE);
        }
        String foTimeoutStr = settings.getConfigOption("app.failover.timeout", SM_FAILOVER_TIMEOUT);
        try {
            this.failoverTimeout = Integer.parseInt(foTimeoutStr) * 1000;
        }
        catch (NumberFormatException e) {
            log.error("Failover timeout value '{}' is invalid; defaulting to: {} seconds", (Object)foTimeoutStr, (Object)SM_FAILOVER_TIMEOUT);
            this.failoverTimeout = Integer.parseInt(SM_FAILOVER_TIMEOUT) * 1000;
        }
        String debug = settings.getConfigOption("app.net.debug", null);
        if (debug != null) {
            System.setProperty("javax.net.debug", debug);
            log.info("FEAdapter network debug set to '" + debug + "'");
        }
        log.info("FE Adapter initialization finished");
    }

    @Override
    public void registerCertsAssistant(ICertsAssistant assistant) {
    }

    @Override
    public void registerSecurityHandler(ISecurityHandler securityHandler) {
    }

    @Override
    public SSLEngine getSSLEngine(HostInfo hostInfo) throws Exception {
        String host = hostInfo.getHost();
        int port = hostInfo.getPort();
        CertsDescription certs = hostInfo.getCertsDescription();
        String keyFile = certs.getKeyStoreFile();
        String trustFile = certs.getTrustStoreFile();
        KeyManagerFactory kmf = this.cachedKeyFactories.get(keyFile);
        TrustManagerFactory tmf = this.cachedTrustFactories.get(trustFile);
        if (kmf != null && tmf != null) {
            return Utils.createSSLEngine(host, port, kmf, tmf);
        }
        return null;
    }

    @Override
    public SSLEngine getSSLEngine(HostInfo hostInfo, CertsDescription certs) throws Exception {
        String host = hostInfo.getHost();
        int port = hostInfo.getPort();
        String keyFile = certs.getKeyStoreFile();
        KeyManagerFactory kmf = Utils.createKeyManagerFactory(keyFile, certs.getKeyStorePwd());
        this.cachedKeyFactories.put(keyFile, kmf);
        String trustFile = certs.getTrustStoreFile();
        TrustManagerFactory tmf = Utils.createTrustManagerFactory(trustFile, certs.getTrustStorePwd());
        this.cachedTrustFactories.put(trustFile, tmf);
        return Utils.createSSLEngine(host, port, kmf, tmf);
    }

    @Override
    public ISession createSession(SubnetDescription subnet) throws IOException {
        return this.createSession(subnet, null);
    }

    @Override
    public ISession createSession(SubnetDescription subnet, ISMEventListener listener) throws IOException {
        SubnetRequestDispatcher tmpDispatcher;
        IRequestDispatcher dispatcher = this.cachedDispatchers.get(subnet);
        if (dispatcher == null && (dispatcher = this.cachedDispatchers.putIfAbsent(subnet, tmpDispatcher = new SubnetRequestDispatcher(subnet, this, this.dbMgr))) == null) {
            dispatcher = tmpDispatcher;
            log.info("Starting SubnetRequestDispatcher for subnet {}...", (Object)subnet.getName());
            dispatcher.start();
        }
        return dispatcher.createSession(listener);
    }

    @Override
    public ISession createTemporarySession(HostInfo host, IConnectionEventListener listener) throws IOException {
        ITempRequestDispatcher tmpDispatcher = this.tempreqDispatcher.get();
        if (tmpDispatcher == null) {
            tmpDispatcher = new TempRequestDispatcher(this);
            if (this.tempreqDispatcher.compareAndSet(null, tmpDispatcher)) {
                log.info("Starting TemporaryRequestDispatcher...");
                tmpDispatcher.start();
            } else {
                tmpDispatcher = this.tempreqDispatcher.get();
            }
        }
        return tmpDispatcher.createTemporarySession(host, listener);
    }

    @Override
    public int getNumInitialConnections() {
        return SubnetRequestDispatcher.MIN_CONN_POOL_SIZE;
    }

    @Override
    public long getFailoverTimeout() {
        return this.failoverTimeout;
    }

    @Override
    public <R> void submitTask(AsyncTask<R> task, ResultHandler<R> handler) {
        this.procService.submit(task, handler);
    }

    @Override
    public void shutdownSubnet(SubnetDescription subnet) {
        IRequestDispatcher cachedDispatcher = this.cachedDispatchers.get(subnet);
        if (cachedDispatcher != null) {
            log.info("Shutting down SubnetRequestDispatcher for subnet {}.", (Object)subnet.getName());
            this.cachedDispatchers.remove(subnet);
            cachedDispatcher.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(StartupProgressObserver observer) {
        block13: {
            if (observer != null) {
                observer.setProgress(SHUTDOWN_MESSAGE);
            }
            try {
                ITempRequestDispatcher tmpDispatcher = this.tempreqDispatcher.get();
                if (tmpDispatcher == null) break block13;
                tmpDispatcher.shutdown();
            }
            catch (Exception e) {
                log.warn("Exception shutting temporary dispatcher.", (Throwable)e);
            }
            finally {
                for (SubnetDescription subnet : this.cachedDispatchers.keySet()) {
                    try {
                        IRequestDispatcher dispatcher = this.cachedDispatchers.get(subnet);
                        dispatcher.shutdown();
                    }
                    catch (Exception e) {
                        log.warn("Exception shutting down subnet {}", (Object)subnet.getName(), (Object)e);
                    }
                }
            }
        }
    }

    @Override
    public SocketChannel createChannel() {
        try {
            return SocketChannel.open();
        }
        catch (IOException e) {
            log.error("Error creating channel", (Throwable)e);
            return null;
        }
    }

    @Override
    public IFailoverManager getFailoverManager() {
        return new SMFailoverManager(this);
    }

    @Override
    public IFailureManagement getFailureManager() {
        return this.failureMgr;
    }

    @Override
    public IFailureEvaluator getFailureEvaluator() {
        return this.failureEvaluator;
    }

    @Override
    public String getComponentDescription() {
        return ADAPTER_COMPONENT;
    }

    @Override
    public int getInitializationWeight() {
        return 10;
    }

    @Override
    public void refreshSubnetDescription(SubnetDescription subnet) {
        IRequestDispatcher cachedDispatcher = this.cachedDispatchers.get(subnet);
        if (cachedDispatcher != null) {
            cachedDispatcher.refreshSubnetDescription(subnet);
        }
    }

    @Override
    public void startSimulatedFailover(String subnetName) {
    }
}

