/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.dispatcher;

import com.intel.stl.api.StringUtils;
import com.intel.stl.api.performance.ImageInfoBean;
import com.intel.stl.api.performance.PMConfigBean;
import com.intel.stl.api.performance.impl.PAHelper;
import com.intel.stl.api.subnet.HostInfo;
import com.intel.stl.api.subnet.SMRecordBean;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.api.subnet.impl.SAHelper;
import com.intel.stl.common.STLMessages;
import com.intel.stl.fecdriver.ApplicationEvent;
import com.intel.stl.fecdriver.IFailoverHelper;
import com.intel.stl.fecdriver.IFailoverManager;
import com.intel.stl.fecdriver.IFailoverProgressListener;
import com.intel.stl.fecdriver.IStatement;
import com.intel.stl.fecdriver.dispatcher.Connection;
import com.intel.stl.fecdriver.dispatcher.IConnectionEventListener;
import com.intel.stl.fecdriver.dispatcher.SMFailoverException;
import com.intel.stl.fecdriver.session.ISession;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMFailoverManager
implements IFailoverManager,
IConnectionEventListener {
    private static final Logger log = LoggerFactory.getLogger(SMFailoverManager.class);
    private static final String FO_TIMER_THREAD_PREFIX = "failover-";
    protected static final int CONNECTION_WAIT = 500;
    private static final int SM_CONN_PERCENTAGE = 34;
    private static final int SM_SMCHECK_PERCENTAGE = 25;
    private static final int SM_PMCHECK_PERCENTAGE = 33;
    private static final int SM_MINNUMCONNCHECK_PERCENTAGE = 8;
    protected static int FO_CONN_RETRY_DELAY = 5000;
    protected static int FO_CHECK_SM_DELAY = 50;
    protected static int FO_CHECK_PM_DELAY = 50;
    protected static int FO_CHECK_MINNUMCONN_DELAY = 50;
    private final AtomicInteger threadCount = new AtomicInteger(1);
    private BlockingQueue<ConnectionResult> queue;
    private Map<HostInfo, HostStatus> sessions;
    private final IFailoverHelper helper;
    private long failoverTimeout;
    private boolean doNotClearSessions = false;

    public SMFailoverManager(IFailoverHelper helper) {
        this.helper = helper;
        log.debug("SMFailoverManager constructor called.");
    }

    @Override
    public long getFailoverTimeout() {
        return this.helper.getFailoverTimeout();
    }

    @Override
    public void stopFailover() {
    }

    @Override
    public SubnetDescription connectionLost(SubnetDescription subnet, IFailoverProgressListener listener) {
        HostStatus status;
        long ellapsedTimeout = this.getFailoverTimeout();
        log.debug("SMFailoverManager connectionLost called. Timeout set to {} ms.", (Object)ellapsedTimeout);
        int numConn = this.helper.getNumInitialConnections();
        if (numConn <= 0) {
            numConn = 1;
        }
        List<HostInfo> feList = subnet.getFEList();
        int queueSize = feList.size();
        this.queue = new ArrayBlockingQueue<ConnectionResult>(queueSize);
        this.sessions = new HashMap<HostInfo, HostStatus>();
        for (int i = 0; i < queueSize; ++i) {
            HostInfo host = feList.get(i);
            try {
                String msg = STLMessages.STL64005_SM_FAILOVER_ATTEMPTING_CONNECTION.getDescription(host.getHost());
                this.notifyListener(listener, msg);
                log.info("Starting session with host {}", (Object)host);
                status = new HostStatus(i, host, subnet, numConn, ellapsedTimeout);
                this.sessions.put(host, status);
                log.debug("Failover session created for host: " + host);
                continue;
            }
            catch (IOException e) {
                log.error("IOException creating session for host {}", (Object)host, (Object)e);
            }
        }
        this.failoverTimeout = System.currentTimeMillis() + ellapsedTimeout;
        try {
            while (true) {
                ConnectionResult result;
                if ((result = this.queue.poll(500L, TimeUnit.MILLISECONDS)) == null) {
                    this.checkTimeout(listener);
                    continue;
                }
                HostInfo hostInfo = result.getHostInfo();
                Throwable t = result.getError();
                status = this.sessions.get(hostInfo);
                if (status == null) continue;
                if (t == null) {
                    this.checkStatus(status, listener);
                    if (status.getState() == STATE.SUCCESSFUL) {
                        subnet.setCurrentFEIndex(status.getIndex());
                        this.cleanup(listener);
                        log.info("Failover successful for host: " + hostInfo + " index: " + status.getIndex());
                        return subnet;
                    }
                    this.checkTimeout(listener);
                    continue;
                }
                status.setLastError(t);
                this.checkError(status, listener);
                if (status.getState() == STATE.UNSUCCESSFUL) {
                    this.removeHost(status);
                    if (this.sessions.size() == 0) {
                        this.cleanup(listener);
                        SMFailoverException foe = new SMFailoverException(STLMessages.STL64000_SM_FAILOVER_UNSUCCESSFUL);
                        log.info("Failover failed - no remaining hosts to process.");
                        throw foe;
                    }
                }
                this.checkTimeout(listener);
            }
        }
        catch (InterruptedException e) {
            log.error("InterruptedException in FailoverManager.");
            this.cleanup(listener);
            SMFailoverException foe = new SMFailoverException(STLMessages.STL64000_SM_FAILOVER_UNSUCCESSFUL);
            throw foe;
        }
    }

    @Override
    public void onConnectionComplete(Connection conn) {
        HostInfo hostInfo = conn.getHostInfo();
        log.debug("Connection completed for host {}", (Object)hostInfo);
        ConnectionResult result = new ConnectionResult(hostInfo, null);
        this.putResult(result);
    }

    @Override
    public void onConnectionError(Connection conn, Throwable t) {
        HostInfo hostInfo = conn.getHostInfo();
        log.debug("Connection error in host {}: {}", (Object)hostInfo, (Object)StringUtils.getErrorMessage(t));
        ConnectionResult result = new ConnectionResult(hostInfo, t);
        this.putResult(result);
    }

    private ISession createSession(HostInfo hostInfo) throws IOException {
        return this.helper.createTemporarySession(hostInfo, this);
    }

    private void putResult(ConnectionResult result) {
        try {
            this.queue.put(result);
        }
        catch (InterruptedException e) {
            log.warn("Interrupted exception while putting connection result", (Throwable)e);
        }
    }

    private void checkTimeout(IFailoverProgressListener listener) {
        long now = System.currentTimeMillis();
        if (now > this.failoverTimeout) {
            log.info("Failover unsuccessful due to timeout: {} ms over", (Object)(now - this.failoverTimeout));
            this.cleanup(listener);
            SMFailoverException foe = new SMFailoverException(STLMessages.STL64000_SM_FAILOVER_UNSUCCESSFUL);
            throw foe;
        }
    }

    private void checkStatus(HostStatus status, IFailoverProgressListener listener) {
        log.debug("SMFailoverManager checkStatus called for host: " + status.getHostInfo() + " state: " + (Object)((Object)status.getState()));
        switch (status.getState()) {
            case NOT_CONNECTED: {
                status.setState(STATE.CONNECTED);
                int maxRetries = status.getMaxConnRetries();
                int retries = status.getConnRetries();
                status.setConnRetries(retries + 1);
                int percent = 34 / (maxRetries + 1);
                double increment = status.setProgress(percent);
                this.notifyListener(listener, increment);
                CheckSMAvailabilityTask task = new CheckSMAvailabilityTask(status);
                status.getTimer().schedule((TimerTask)task, FO_CHECK_SM_DELAY);
                break;
            }
            case CONNECTED: {
                status.setState(STATE.SM_LIST_CHECKED);
                int maxRetries = status.getMaxSMCheckRetries();
                int retries = status.getSMCheckRetries();
                status.setSMCheckRetries(retries + 1);
                int percent = 25 / (maxRetries + 1);
                double increment = status.setProgress(percent);
                this.notifyListener(listener, increment);
                CheckPMAvailabilityTask task = new CheckPMAvailabilityTask(status);
                status.getTimer().schedule((TimerTask)task, FO_CHECK_PM_DELAY);
                break;
            }
            case SM_LIST_CHECKED: {
                status.setState(STATE.PM_CHECKED);
                int maxRetries = status.getMaxPMCheckRetries();
                int retries = status.getPMCheckRetries();
                status.setPMCheckRetries(retries + 1);
                int percent = 33 / (maxRetries + 1);
                double increment = status.setProgress(percent);
                this.notifyListener(listener, increment);
                CheckMinNumConnTask task = new CheckMinNumConnTask(status);
                status.getTimer().schedule((TimerTask)task, FO_CHECK_MINNUMCONN_DELAY);
                break;
            }
            case PM_CHECKED: {
                int remainderPercent = this.calculateRemainderPercentage(34, status.getMaxConnRetries(), status.getConnRetries());
                double increment = status.setProgress(remainderPercent);
                this.notifyListener(listener, increment);
                int maxRetries = status.getMaxSMCheckRetries();
                remainderPercent = this.calculateRemainderPercentage(25, maxRetries, status.getSMCheckRetries());
                increment = status.setProgress(remainderPercent);
                this.notifyListener(listener, increment);
                maxRetries = status.getMaxPMCheckRetries();
                remainderPercent = this.calculateRemainderPercentage(33, maxRetries, status.getPMCheckRetries());
                increment = status.setProgress(remainderPercent);
                this.notifyListener(listener, increment);
                increment = status.setProgress(8);
                this.notifyListener(listener, increment);
                status.setState(STATE.SUCCESSFUL);
                break;
            }
            case SUCCESSFUL: {
                break;
            }
        }
    }

    private void checkError(HostStatus status, IFailoverProgressListener listener) {
        TimerTask task = null;
        int maxRetries = 0;
        double percent = 0.0;
        long delay = FO_CONN_RETRY_DELAY;
        String msg = null;
        HostInfo hostInfo = status.getHostInfo();
        String host = hostInfo.getHost();
        log.debug("SMFailoverManager checkError called for host: " + status.getHostInfo() + " state: " + (Object)((Object)status.getState()) + " error: " + status.getLastError());
        if (!status.isRetryInProgress()) {
            int retries = 0;
            String cause = "";
            ISession session = status.getSession().get();
            switch (status.getState()) {
                case NOT_CONNECTED: {
                    delay = FO_CONN_RETRY_DELAY;
                    maxRetries = status.getMaxConnRetries();
                    retries = status.getConnRetries();
                    status.setConnRetries(retries + 1);
                    percent = 34 / (maxRetries + 1);
                    msg = STLMessages.STL64004_SM_FAILOVER_CONNECTION_RETRY.getDescription(host, retries + 1);
                    session.close();
                    task = new ConnectionRetryTask(status);
                    cause = "Connection attempt";
                    break;
                }
                case CONNECTED: {
                    delay = FO_CONN_RETRY_DELAY;
                    maxRetries = status.getMaxSMCheckRetries();
                    retries = status.getSMCheckRetries();
                    status.setSMCheckRetries(retries + 1);
                    percent = 25 / (maxRetries + 1);
                    msg = STLMessages.STL64008_SM_FAILOVER_GET_SM_RETRY.getDescription(host, retries + 1);
                    session.close();
                    status.setState(STATE.NOT_CONNECTED);
                    task = new ConnectionRetryTask(status);
                    cause = "SM availability check attempt";
                    break;
                }
                case SM_LIST_CHECKED: {
                    delay = FO_CONN_RETRY_DELAY;
                    maxRetries = status.getMaxPMCheckRetries();
                    retries = status.getPMCheckRetries();
                    status.setPMCheckRetries(retries + 1);
                    percent = 33 / (maxRetries + 1);
                    msg = STLMessages.STL64009_SM_FAILOVER_GET_PM_RETRY.getDescription(host, retries + 1);
                    task = new CheckPMAvailabilityTask(status);
                    session.close();
                    status.setState(STATE.NOT_CONNECTED);
                    task = new ConnectionRetryTask(status);
                    cause = "PM availability check attempt";
                    break;
                }
                case PM_CHECKED: {
                    delay = FO_CHECK_MINNUMCONN_DELAY;
                    task = new ConnectionRetryTask(status);
                    maxRetries = 0;
                    retries = 1;
                    break;
                }
                case SUCCESSFUL: {
                    break;
                }
            }
            if (task != null) {
                if (retries < maxRetries) {
                    Throwable t = status.getLastError();
                    log.warn("{} {}/{} to host {}:{} failed due to error: {}", new Object[]{cause, ++retries, maxRetries, host, hostInfo.getPort(), StringUtils.getErrorMessage(t)});
                    double increment = status.setProgress((int)percent);
                    this.notifyListener(listener, increment);
                    this.notifyListener(listener, msg);
                    status.setIsRetryInProgress(true);
                    status.getTimer().schedule(task, delay);
                } else {
                    this.connectionUnsuccessful(status, listener);
                }
            }
        }
    }

    private int calculateRemainderPercentage(int totalPercentage, int maxRetries, int retries) {
        double sofar = totalPercentage / (maxRetries + 1) * retries;
        int percent = (int)((double)totalPercentage - sofar);
        return percent;
    }

    private void removeHost(HostStatus status) {
        HostInfo host = status.getHostInfo();
        this.sessions.remove(host);
        status.getTimer().cancel();
        this.closeSession(status);
    }

    private void closeSession(HostStatus status) {
        AtomicReference<ISession> sessionRef = status.getSession();
        ISession session = sessionRef.get();
        session.close();
        while (!sessionRef.compareAndSet(session, null)) {
            session = sessionRef.get();
            session.close();
        }
    }

    private void connectionUnsuccessful(HostStatus status, IFailoverProgressListener listener) {
        HostInfo hostInfo = status.getHostInfo();
        String host = hostInfo.getHost() + ":" + hostInfo.getPort();
        String msg = STLMessages.STL64003_SM_FAILOVER_CONNECTION_FAILED.getDescription(host);
        this.notifyListener(listener, msg);
        double increment = status.setProgress(100);
        this.notifyListener(listener, increment);
        status.setState(STATE.UNSUCCESSFUL);
    }

    private void cleanup(IFailoverProgressListener listener) {
        for (HostStatus status : this.sessions.values()) {
            try {
                double increment = status.setProgress(100);
                if (increment > 0.0) {
                    this.notifyListener(listener, increment);
                }
                if (status.timer != null) {
                    status.getTimer().cancel();
                }
                this.closeSession(status);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!this.doNotClearSessions) {
            this.sessions.clear();
        }
    }

    private void notifyListener(IFailoverProgressListener listener, double increment) {
        ApplicationEvent event = new ApplicationEvent(increment);
        listener.onFailoverProgress(event);
    }

    private void notifyListener(IFailoverProgressListener listener, String message) {
        ApplicationEvent event = new ApplicationEvent(message);
        listener.onFailoverProgress(event);
    }

    private ISession checkSession(HostStatus status) {
        ISession session = status.getSession().get();
        if (session == null) {
            RuntimeException rte = new RuntimeException("Session closed for host " + status.getHostInfo().getHost());
            throw rte;
        }
        return session;
    }

    protected boolean isCorrectSubnet(List<SMRecordBean> origSmRecords, List<SMRecordBean> smRecords) {
        boolean isFound = false;
        if (origSmRecords != null && !origSmRecords.isEmpty()) {
            if (smRecords != null && !smRecords.isEmpty()) {
                ArrayList smRecordsAL = (ArrayList)smRecords;
                Iterator smRecordsALIterator = smRecordsAL.iterator();
                block0: while (smRecordsALIterator.hasNext() && !isFound) {
                    SMRecordBean smRecordsALBean = (SMRecordBean)smRecordsALIterator.next();
                    for (SMRecordBean subnetManagerRecordsBean : origSmRecords) {
                        if (smRecordsALBean.getSmInfo().getPortGuid() != subnetManagerRecordsBean.getSmInfo().getPortGuid()) continue;
                        isFound = true;
                        continue block0;
                    }
                }
            }
        } else {
            isFound = true;
        }
        return isFound;
    }

    private int calculateConnRetries(long failoverTimeout) {
        return (int)(failoverTimeout / (long)(FO_CONN_RETRY_DELAY + 100));
    }

    private int calculateSMCheckRetries(long failoverTimeout) {
        return (int)(failoverTimeout / (long)(FO_CONN_RETRY_DELAY + FO_CHECK_SM_DELAY + 400));
    }

    private int calculatePMCheckRetries(long failoverTimeout) {
        return (int)(failoverTimeout / (long)(FO_CONN_RETRY_DELAY + FO_CHECK_SM_DELAY + FO_CHECK_PM_DELAY + 700));
    }

    protected Map<HostInfo, HostStatus> getSessions() {
        return this.sessions;
    }

    protected void setDoNotClearSessions(boolean doNotClearSessions) {
        this.doNotClearSessions = doNotClearSessions;
    }

    protected HostStatus getHostStatusFor(HostInfo hostInfo) {
        return this.sessions.get(hostInfo);
    }

    private class ConnectionResult {
        private final HostInfo hostInfo;
        private final Throwable error;

        public ConnectionResult(HostInfo hostInfo, Throwable t) {
            this.hostInfo = hostInfo;
            this.error = t;
        }

        public HostInfo getHostInfo() {
            return this.hostInfo;
        }

        public Throwable getError() {
            return this.error;
        }
    }

    private class CheckMinNumConnTask
    extends TimerTask {
        private final HostStatus status;

        public CheckMinNumConnTask(HostStatus status) {
            this.status = status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HostInfo hostInfo = this.status.getHostInfo();
            log.info("Checking minimum number of connections available thru host {}:{}", (Object)hostInfo.getHost(), (Object)hostInfo.getPort());
            int minNumConn = this.status.getNumConnections();
            final Exchanger<Object> connXchgr = new Exchanger<Object>();
            IConnectionEventListener listener = new IConnectionEventListener(){

                @Override
                public void onConnectionComplete(Connection conn) {
                    try {
                        connXchgr.exchange(null, 1000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException | TimeoutException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onConnectionError(Connection conn, Throwable t) {
                    try {
                        connXchgr.exchange(t, 1000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException | TimeoutException e) {
                        e.printStackTrace();
                    }
                }
            };
            ArrayList<ISession> tempSessions = new ArrayList<ISession>(--minNumConn);
            try {
                for (int i = 0; i < minNumConn; ++i) {
                    ISession tmpSession = SMFailoverManager.this.helper.createTemporarySession(hostInfo, listener);
                    tempSessions.add(tmpSession);
                    Exception error = connXchgr.exchange(null, 5000L, TimeUnit.MILLISECONDS);
                    if (error == null) continue;
                    throw error;
                }
                ConnectionResult result = new ConnectionResult(hostInfo, null);
                SMFailoverManager.this.putResult(result);
            }
            catch (Exception e) {
                ConnectionResult result = new ConnectionResult(hostInfo, e);
                log.warn("Exception occured while checking minimum number of connection thru host {}:{}: {}", new Object[]{hostInfo.getHost(), hostInfo.getPort(), StringUtils.getErrorMessage(e)});
                SMFailoverManager.this.putResult(result);
            }
            finally {
                for (ISession tmpSession : tempSessions) {
                    try {
                        tmpSession.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    private class CheckPMAvailabilityTask
    extends TimerTask {
        private final HostStatus status;

        public CheckPMAvailabilityTask(HostStatus status) {
            this.status = status;
        }

        @Override
        public void run() {
            HostInfo hostInfo = this.status.getHostInfo();
            log.info("Checking PM availability thru host {}:{}", (Object)hostInfo.getHost(), (Object)hostInfo.getPort());
            try {
                ConnectionResult result;
                ISession session = SMFailoverManager.this.checkSession(this.status);
                IStatement statement = session.createStatement();
                PAHelper paHelper = new PAHelper(statement);
                ImageInfoBean img = paHelper.getImageInfo(0L, 0);
                PMConfigBean pmConfig = paHelper.getPMConfig();
                if (pmConfig != null && img != null) {
                    result = new ConnectionResult(hostInfo, null);
                    log.debug("CheckPMAvailability successful on host: " + hostInfo + " pmconfig: " + pmConfig);
                } else {
                    result = new ConnectionResult(hostInfo, new SMFailoverException(STLMessages.STL64007_SM_FAILOVER_GET_PM_ERROR));
                    log.debug("CheckPMAvailability could noy verify PM on host: " + hostInfo);
                }
                SMFailoverManager.this.putResult(result);
            }
            catch (Exception e) {
                ConnectionResult result = new ConnectionResult(hostInfo, e);
                log.warn("Exception occurred while checking PM availability thru host {}:{}: {}", new Object[]{hostInfo.getHost(), hostInfo.getPort(), StringUtils.getErrorMessage(e)});
                SMFailoverManager.this.putResult(result);
            }
        }
    }

    private class CheckSMAvailabilityTask
    extends TimerTask {
        private final HostStatus status;

        public CheckSMAvailabilityTask(HostStatus status) {
            this.status = status;
        }

        @Override
        public void run() {
            HostInfo hostInfo = this.status.getHostInfo();
            String host = hostInfo.getHost();
            log.info("Checking SM availability thru host {}:{}", (Object)host, (Object)hostInfo.getPort());
            try {
                ConnectionResult result;
                ISession session = SMFailoverManager.this.checkSession(this.status);
                IStatement statement = session.createStatement();
                SAHelper helper = new SAHelper(statement);
                List<SMRecordBean> sms = helper.getSMs();
                if (SMFailoverManager.this.isCorrectSubnet(this.status.getOriginalSMList(), sms)) {
                    result = new ConnectionResult(hostInfo, null);
                    log.debug("CheckSMAvailability successful on host: " + hostInfo);
                } else {
                    result = new ConnectionResult(hostInfo, new SMFailoverException(STLMessages.STL64006_SM_FAILOVER_GET_SM_ERROR));
                    log.debug("CheckSMAvailability could noy verify SM on host: " + hostInfo);
                }
                SMFailoverManager.this.putResult(result);
            }
            catch (Exception e) {
                ConnectionResult result = new ConnectionResult(hostInfo, e);
                log.warn("Exception occurred while checking SM availability thru host {}:{}: {}", new Object[]{hostInfo.getHost(), hostInfo.getPort(), StringUtils.getErrorMessage(e)});
                SMFailoverManager.this.putResult(result);
            }
        }
    }

    private class ConnectionRetryTask
    extends TimerTask {
        private final HostStatus status;

        public ConnectionRetryTask(HostStatus status) {
            this.status = status;
        }

        @Override
        public void run() {
            HostInfo hostInfo = this.status.getHostInfo();
            log.info("Attempting to connect to host {}:{}, attempt {}", new Object[]{hostInfo.getHost(), hostInfo.getPort(), this.status.getConnRetries() + 1});
            try {
                AtomicReference<ISession> sessionRef = this.status.getSession();
                ISession currSession = sessionRef.get();
                if (currSession != null) {
                    ISession session = SMFailoverManager.this.createSession(hostInfo);
                    while (!sessionRef.compareAndSet(currSession, session)) {
                        currSession = sessionRef.get();
                        if (currSession == null) {
                            session.close();
                            break;
                        }
                        currSession.close();
                    }
                }
                this.status.setIsRetryInProgress(false);
            }
            catch (Exception e) {
                ConnectionResult result = new ConnectionResult(hostInfo, e);
                this.status.setIsRetryInProgress(false);
                SMFailoverManager.this.putResult(result);
            }
        }
    }

    protected class HostStatus {
        private final int index;
        private final HostInfo hostInfo;
        private final AtomicReference<ISession> session;
        private final int numConn;
        private final int maxConnRetries;
        private final int maxSMCheckRetries;
        private final int maxPMCheckRetries;
        private double remainder;
        private int connRetries = 0;
        private int smCheckRetries = 0;
        private int pmCheckRetries = 0;
        private Throwable lastError = null;
        private STATE state = STATE.NOT_CONNECTED;
        private Timer timer;
        private boolean isRetryInProgress;
        private final SubnetDescription subnet;

        public HostStatus(int index, HostInfo hostInfo, SubnetDescription subnet, int numConn, long failoverTimeout) throws IOException {
            this.index = index;
            this.hostInfo = hostInfo;
            ISession session = SMFailoverManager.this.createSession(hostInfo);
            this.session = new AtomicReference<ISession>(session);
            this.numConn = numConn;
            this.maxConnRetries = SMFailoverManager.this.calculateConnRetries(failoverTimeout);
            this.maxSMCheckRetries = SMFailoverManager.this.calculateSMCheckRetries(failoverTimeout);
            this.maxPMCheckRetries = SMFailoverManager.this.calculatePMCheckRetries(failoverTimeout);
            this.remainder = 1.0;
            this.subnet = subnet;
        }

        public List<SMRecordBean> getOriginalSMList() {
            return this.subnet.getSMList();
        }

        public void setIsRetryInProgress(boolean isRetryInProgress) {
            this.isRetryInProgress = isRetryInProgress;
        }

        public boolean isRetryInProgress() {
            return this.isRetryInProgress;
        }

        public int getIndex() {
            return this.index;
        }

        public HostInfo getHostInfo() {
            return this.hostInfo;
        }

        public AtomicReference<ISession> getSession() {
            return this.session;
        }

        public int getNumConnections() {
            return this.numConn;
        }

        public int getMaxConnRetries() {
            return this.maxConnRetries;
        }

        public int getMaxSMCheckRetries() {
            return this.maxSMCheckRetries;
        }

        public int getMaxPMCheckRetries() {
            return this.maxPMCheckRetries;
        }

        public STATE getState() {
            return this.state;
        }

        public void setState(STATE state) {
            this.state = state;
        }

        public int getConnRetries() {
            return this.connRetries;
        }

        public void setConnRetries(int connRetries) {
            this.connRetries = connRetries;
        }

        public int getSMCheckRetries() {
            return this.smCheckRetries;
        }

        public void setSMCheckRetries(int smCheckRetries) {
            this.smCheckRetries = smCheckRetries;
        }

        public int getPMCheckRetries() {
            return this.pmCheckRetries;
        }

        public void setPMCheckRetries(int pmCheckRetries) {
            this.pmCheckRetries = pmCheckRetries;
        }

        public Throwable getLastError() {
            return this.lastError;
        }

        public void setLastError(Throwable lastError) {
            this.lastError = lastError;
        }

        public double setProgress(int percentage) {
            double progress;
            if (percentage < 0) {
                percentage = 0;
            }
            if (percentage > 100) {
                percentage = 100;
            }
            if ((progress = 1.0 * (double)percentage / 100.0) > this.remainder) {
                progress = this.remainder;
                this.remainder = 0.0;
            } else {
                this.remainder -= progress;
            }
            return progress;
        }

        public Timer getTimer() {
            if (this.timer == null) {
                this.timer = new Timer(SMFailoverManager.FO_TIMER_THREAD_PREFIX + SMFailoverManager.this.threadCount.incrementAndGet());
            }
            return this.timer;
        }
    }

    protected static enum STATE {
        NOT_CONNECTED,
        CONNECTED,
        SM_LIST_CHECKED,
        PM_CHECKED,
        SUCCESSFUL,
        UNSUCCESSFUL;

    }
}

