/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.messages.adapter.pa;

import com.intel.stl.api.performance.ErrBucketBean;
import com.intel.stl.api.performance.ErrStatBean;
import com.intel.stl.api.performance.ErrSummaryBean;
import com.intel.stl.api.performance.GroupInfoBean;
import com.intel.stl.api.performance.ImageIdBean;
import com.intel.stl.api.performance.UtilStatsBean;
import com.intel.stl.common.StringUtils;
import com.intel.stl.fecdriver.messages.adapter.SimpleDatagram;
import java.util.ArrayList;

public class GroupInfo
extends SimpleDatagram<GroupInfoBean> {
    public GroupInfo() {
        super(684);
    }

    public void setGroupName(String name) {
        StringUtils.setString(name, this.buffer, 0, 64);
    }

    public void setImageNumber(long num) {
        this.buffer.putLong(64, num);
    }

    public void setImageOffset(int offset) {
        this.buffer.putInt(72, offset);
    }

    private UtilStatsBean getUtilStatsBean(int position) {
        this.buffer.position(position);
        UtilStatsBean bean = new UtilStatsBean();
        bean.setTotalMBps(this.buffer.getLong());
        bean.setTotalKPps(this.buffer.getLong());
        bean.setAvgMBps(this.buffer.getInt());
        bean.setMinMBps(this.buffer.getInt());
        bean.setMaxMBps(this.buffer.getInt());
        bean.setNumBWBuckets(this.buffer.getInt());
        ArrayList<Integer> buckets = new ArrayList<Integer>(10);
        for (int i = 0; i < 10; ++i) {
            buckets.add(this.buffer.getInt());
        }
        bean.setBwBuckets(buckets);
        bean.setAvgKPps(this.buffer.getInt());
        bean.setMinKPps(this.buffer.getInt());
        bean.setMaxKPps(this.buffer.getInt());
        bean.setPmaFailedPorts(this.buffer.getShort());
        bean.setTopoFailedPorts(this.buffer.getShort());
        return bean;
    }

    private ErrStatBean getErrStatBean(int position) {
        this.buffer.position(position);
        ErrSummaryBean esBean = new ErrSummaryBean();
        esBean.setIntegrityErrors(this.buffer.getInt());
        esBean.setCongestionErrors(this.buffer.getInt());
        esBean.setSmaCongestionErrors(this.buffer.getInt());
        esBean.setBubbleErrors(this.buffer.getInt());
        esBean.setSecurityErrors(this.buffer.getInt());
        esBean.setRoutingErrors(this.buffer.getInt());
        esBean.setUtilizationPct10(this.buffer.getShort() & 0xFFFF);
        esBean.setDiscardsPct10(this.buffer.getShort() & 0xFFFF);
        this.buffer.getInt();
        this.buffer.getInt();
        this.buffer.getInt();
        ErrBucketBean[] ebBeans = new ErrBucketBean[5];
        for (int i = 0; i < ebBeans.length; ++i) {
            ebBeans[i] = new ErrBucketBean();
            ebBeans[i].setIntegrityErrors(this.buffer.getInt());
            ebBeans[i].setCongestionErrors(this.buffer.getInt());
            ebBeans[i].setSmaCongestionErrors(this.buffer.getInt());
            ebBeans[i].setBubbleErrors(this.buffer.getInt());
            ebBeans[i].setSecurityErrors(this.buffer.getInt());
            ebBeans[i].setRoutingErrors(this.buffer.getInt());
        }
        ErrStatBean bean = new ErrStatBean(esBean, ebBeans);
        return bean;
    }

    @Override
    public GroupInfoBean toObject() {
        this.buffer.clear();
        GroupInfoBean bean = new GroupInfoBean();
        byte[] byteArray = new byte[64];
        this.buffer.get(byteArray);
        bean.setGroupName(StringUtils.toString(byteArray, 0, 64));
        ImageIdBean imageId = new ImageIdBean(this.buffer.getLong(), this.buffer.getInt());
        bean.setImageId(imageId);
        this.buffer.position(80);
        bean.setNumInternalPorts(this.buffer.getInt());
        bean.setNumExternalPorts(this.buffer.getInt());
        UtilStatsBean utilStat = this.getUtilStatsBean(88);
        bean.setInternalUtilStats(utilStat);
        utilStat = this.getUtilStatsBean(176);
        bean.setSendUtilStats(utilStat);
        utilStat = this.getUtilStatsBean(264);
        bean.setRecvUtilStats(utilStat);
        ErrStatBean errStatBean = this.getErrStatBean(352);
        bean.setInternalErrors(errStatBean);
        errStatBean = this.getErrStatBean(512);
        bean.setExternalErrors(errStatBean);
        this.buffer.position(672);
        bean.setMaxInternalRate(this.buffer.get());
        bean.setMinInternalRate(this.buffer.get());
        bean.setMaxExternalRate(this.buffer.get());
        bean.setMinExternalRate(this.buffer.get());
        bean.setMaxInternalMBps(this.buffer.getInt());
        bean.setMaxExternalMBps(this.buffer.getInt());
        return bean;
    }
}

