/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.messages.adapter.pa;

import com.intel.stl.api.performance.ImageIdBean;
import com.intel.stl.api.performance.ImageInfoBean;
import com.intel.stl.api.performance.SMInfoDataBean;
import com.intel.stl.common.StringUtils;
import com.intel.stl.fecdriver.messages.adapter.SimpleDatagram;

public class ImageInfo
extends SimpleDatagram<ImageInfoBean> {
    public ImageInfo() {
        super(232);
    }

    public void setImageNumber(long imageNumber) {
        this.buffer.putLong(0, imageNumber);
    }

    public void setImageOffset(int imageOffset) {
        this.buffer.putInt(8, imageOffset);
    }

    private SMInfoDataBean getSMInfoBean(int position) {
        this.buffer.position(position);
        SMInfoDataBean bean = new SMInfoDataBean();
        bean.setLid(this.buffer.getInt());
        byte byteVal = this.buffer.get();
        bean.setPriority((byte)(byteVal >>> 4 & 0xF));
        bean.setState((byte)(byteVal & 0xF));
        bean.setPortNumber(this.buffer.get());
        bean.setSmPortGuid(this.buffer.getLong(position + 8));
        byte[] raw = new byte[64];
        this.buffer.position(position + 16);
        this.buffer.get(raw);
        String name = StringUtils.toString(raw, 0, 64);
        bean.setSmNodeDesc(name);
        return bean;
    }

    @Override
    public ImageInfoBean toObject() {
        this.buffer.clear();
        ImageInfoBean bean = new ImageInfoBean();
        bean.setImageId(new ImageIdBean(this.buffer.getLong(), this.buffer.getInt()));
        this.buffer.position(16);
        bean.setSweepStart(this.buffer.getLong());
        bean.setSweepDuration(this.buffer.getInt());
        bean.setNumHFIPorts(this.buffer.getShort());
        this.buffer.getShort();
        this.buffer.getShort();
        bean.setNumSwitchNodes(this.buffer.getShort());
        bean.setNumSwitchPorts(this.buffer.getInt());
        bean.setNumLinks(this.buffer.getInt());
        bean.setNumSMs(this.buffer.getInt());
        bean.setNumFailedNodes(this.buffer.getInt());
        bean.setNumFailedPorts(this.buffer.getInt());
        bean.setNumSkippedNodes(this.buffer.getInt());
        bean.setNumSkippedPorts(this.buffer.getInt());
        bean.setNumUnexpectedClearPorts(this.buffer.getInt());
        bean.setImageInterval(this.buffer.getInt());
        SMInfoDataBean[] smInfo = new SMInfoDataBean[]{this.getSMInfoBean(72), this.getSMInfoBean(152)};
        bean.setSMInfo(smInfo);
        return bean;
    }
}

