/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.messages.adapter.sa;

import com.intel.stl.api.subnet.FlitControlBean;
import com.intel.stl.fecdriver.messages.adapter.SimpleDatagram;

public class FlitControl
extends SimpleDatagram<FlitControlBean> {
    public FlitControl() {
        super(10);
    }

    public void setInterleave(short level) {
        this.buffer.putShort(0, level);
    }

    public void setMinInitial(short minInitial) {
        this.buffer.putShort(2, minInitial);
    }

    public void setMinTail(short minTail) {
        this.buffer.putShort(4, minTail);
    }

    public void setLargePktLimit(byte size) {
        this.buffer.put(6, size);
    }

    public void setSmallPktLimit(byte size) {
        this.buffer.put(7, size);
    }

    public void setMaxSmallPktLimit(byte size) {
        this.buffer.put(8, size);
    }

    public void setPreemptionLimit(byte size) {
        this.buffer.put(9, size);
    }

    @Override
    public FlitControlBean toObject() {
        this.buffer.clear();
        short val = this.buffer.getShort();
        byte distanceSupported = (byte)(val >>> 12 & 3);
        byte distanceEnabled = (byte)(val >>> 10 & 3);
        byte maxNestLevelTxEnabled = (byte)(val >>> 5 & 0x1F);
        byte maxNestLevelRxSupported = (byte)(val & 0x1F);
        FlitControlBean bean = new FlitControlBean(distanceSupported, distanceEnabled, maxNestLevelTxEnabled, maxNestLevelRxSupported, this.buffer.getShort(), this.buffer.getShort(), this.buffer.get(), this.buffer.get(), this.buffer.get(), this.buffer.get());
        return bean;
    }
}

