/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.messages.adapter.sa;

import com.intel.stl.api.subnet.LFTRecordBean;
import com.intel.stl.fecdriver.messages.adapter.SimpleDatagram;

public class LFTRecord
extends SimpleDatagram<LFTRecordBean> {
    public LFTRecord() {
        super(72);
    }

    public void setLID(int lid) {
        this.buffer.putInt(0, lid);
    }

    public void setBlockNum(int num) {
        this.buffer.putInt(4, num & 0x3FFFF);
    }

    public void setLinearFdbData(byte[] data) {
        if (data.length != 64) {
            throw new IllegalArgumentException("Invalid array length. Expect 64, got" + data.length);
        }
        this.buffer.position(8);
        this.buffer.put(data);
    }

    @Override
    public LFTRecordBean toObject() {
        this.buffer.clear();
        int lid = this.buffer.getInt();
        int blockNum = this.buffer.getInt() & 0x3FFFF;
        byte[] data = new byte[64];
        this.buffer.get(data);
        LFTRecordBean bean = new LFTRecordBean(lid, blockNum, data);
        return bean;
    }
}

