/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.messages.adapter.sa;

import com.intel.stl.api.notice.NoticeBean;
import com.intel.stl.fecdriver.messages.adapter.ComposedDatagram;
import com.intel.stl.fecdriver.messages.adapter.SimpleDatagram;
import com.intel.stl.fecdriver.messages.adapter.sa.GID;
import com.intel.stl.fecdriver.messages.adapter.sa.NoticeAttr;
import java.nio.ByteBuffer;

public class Notice
extends ComposedDatagram<NoticeBean> {
    private final SimpleDatagram<Void> header = new SimpleDatagram(96);
    private SimpleDatagram<Void> classData;

    public Notice() {
        this.addDatagram(this.header);
    }

    @Override
    public int wrap(byte[] data, int offset) {
        int pos = this.header.wrap(data, offset);
        int size = data.length - offset;
        this.classData = new SimpleDatagram(size - this.header.getLength());
        pos = this.classData.wrap(data, pos);
        this.addDatagram(this.classData);
        return pos;
    }

    @Override
    public NoticeBean toObject() {
        NoticeAttr attr;
        boolean isGeneric;
        NoticeBean bean = new NoticeBean(true);
        ByteBuffer buffer = this.header.getByteBuffer();
        buffer.clear();
        int intVal = buffer.getInt();
        boolean bl = isGeneric = (intVal & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        if (isGeneric) {
            attr = new NoticeAttr.Generic();
            attr.wrap(buffer.array(), buffer.arrayOffset());
            bean.setAttributes(((NoticeAttr.Generic)attr).toObject());
        } else {
            attr = new NoticeAttr.Vendor();
            attr.wrap(buffer.array(), buffer.arrayOffset());
            bean.setAttributes(((NoticeAttr.Vendor)attr).toObject());
        }
        buffer.position(6);
        short shortVal = buffer.getShort();
        bean.setToggle((shortVal & 0x8000) == 32768);
        bean.setNoticeCount((short)(shortVal & Short.MAX_VALUE));
        bean.setIssuerLID(buffer.getInt());
        GID.Global gid = new GID.Global();
        gid.wrap(buffer.array(), buffer.arrayOffset() + 16);
        bean.setIssuerGID(gid.toObject());
        buffer.position(32);
        byte[] byteArray = new byte[64];
        buffer.get(byteArray);
        bean.setData(byteArray);
        buffer = this.classData.getByteBuffer();
        buffer.clear();
        byteArray = new byte[this.classData.getLength()];
        buffer.get(byteArray);
        bean.setClassData(byteArray);
        return bean;
    }
}

