/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.messages.adapter.sa;

import com.intel.stl.api.subnet.SC2SLMTRecordBean;
import com.intel.stl.fecdriver.messages.adapter.SimpleDatagram;

public class SC2SLMTRecord
extends SimpleDatagram<SC2SLMTRecordBean> {
    public SC2SLMTRecord() {
        super(40);
    }

    public void setLID(int lid) {
        this.buffer.putInt(0, lid);
    }

    public void setSC2SLMTData(byte[] data) {
        if (data.length != 32) {
            throw new IllegalArgumentException("Invalid data length. Expect 32, got " + data.length);
        }
        this.buffer.position(8);
        for (byte val : data) {
            this.buffer.put(val);
        }
    }

    @Override
    public SC2SLMTRecordBean toObject() {
        this.buffer.clear();
        int lid = this.buffer.getInt();
        this.buffer.position(8);
        byte[] data = new byte[32];
        this.buffer.get(data);
        SC2SLMTRecordBean bean = new SC2SLMTRecordBean(lid, data);
        return bean;
    }
}

