/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.session;

import com.intel.stl.api.FMGuiPlugin;
import com.intel.stl.api.StatementClosedException;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.fecdriver.ICommand;
import com.intel.stl.fecdriver.IResponse;
import com.intel.stl.fecdriver.IStatement;
import com.intel.stl.fecdriver.MultipleResponseCommand;
import com.intel.stl.fecdriver.SingleResponseCommand;
import com.intel.stl.fecdriver.messages.adapter.OobPacket;
import com.intel.stl.fecdriver.messages.adapter.RmppMad;
import com.intel.stl.fecdriver.session.Session;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Statement
implements IStatement {
    private static Logger log = LoggerFactory.getLogger(Statement.class);
    private static boolean DEBUG = false;
    protected static final int DEFAULT_TIMEOUT = 30000;
    private int timeout = 30000;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Session session;

    public Statement(Session session) {
        this.session = session;
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void close() {
        boolean isClosed = this.isClosed();
        if (!isClosed && this.closed.compareAndSet(isClosed, true)) {
            this.session.removeStatement(this);
        }
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(int milliseconds) {
        this.timeout = milliseconds;
    }

    @Override
    public SubnetDescription getSubnetDescription() {
        return this.session.getSubnetDescription();
    }

    @Override
    public <F, E extends IResponse<F>> List<F> execute(MultipleResponseCommand<F, E> cmd) throws Exception {
        if (FMGuiPlugin.IS_DEV && SwingUtilities.isEventDispatchThread()) {
            new Exception("Query FM from EDT!").printStackTrace();
        }
        List<F> result = null;
        this.submit(cmd);
        try {
            result = cmd.getResults(this.getTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException toe) {
            if (this.processTimeout(cmd)) {
                result = cmd.getResults(this.getTimeout(), TimeUnit.MILLISECONDS);
            }
            throw toe;
        }
        this.debugResponse(cmd);
        return result;
    }

    @Override
    public <F, E extends IResponse<F>> F execute(SingleResponseCommand<F, E> cmd) throws Exception {
        if (FMGuiPlugin.IS_DEV && SwingUtilities.isEventDispatchThread()) {
            new Exception("Query FM from EDT!").printStackTrace();
        }
        F result = null;
        this.submit(cmd);
        try {
            result = cmd.getResult(this.getTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException toe) {
            if (this.processTimeout(cmd)) {
                result = cmd.getResult(this.getTimeout(), TimeUnit.MILLISECONDS);
            }
            throw toe;
        }
        this.debugResponse(cmd);
        return result;
    }

    @Override
    public <E extends IResponse<F>, F> void submit(ICommand<E, F> cmd) throws Exception {
        if (this.isClosed()) {
            StatementClosedException rte = new StatementClosedException();
            cmd.getResponse().setError(rte);
            throw rte;
        }
        this.prepareCommand(cmd);
        log.debug("submit cmd " + cmd + " with argument " + cmd.getInput());
        this.session.submitCmd(cmd);
    }

    public <E extends IResponse<F>, F> void submitCommand(ICommand<E, F> cmd) {
        this.session.submitCmd(cmd);
    }

    public <E extends IResponse<F>, F> void prepareCommand(ICommand<E, F> cmd) {
        OobPacket sendPacket = this.createSendPacket(cmd);
        cmd.setPacket(sendPacket);
        cmd.setStatement(this);
    }

    protected boolean processTimeout(ICommand<?, ?> cmd) {
        log.info("Timeout waiting for response for cmd " + cmd);
        this.session.fireOnRequestTimeout(new TimeoutException("Timeout waiting for response for command " + cmd.getClass().getSimpleName() + " with id " + cmd.getMessageID()));
        return true;
    }

    private <E extends IResponse<F>, F> OobPacket createSendPacket(ICommand<E, F> cmd) {
        OobPacket sendPacket = new OobPacket();
        sendPacket.build(true);
        RmppMad rmppMad = cmd.prepareMad();
        sendPacket.setRmppMad(rmppMad);
        sendPacket.fillPayloadSize();
        sendPacket.setExpireTime(System.currentTimeMillis() + (long)(this.timeout * 1000));
        return sendPacket;
    }

    private <E extends IResponse<F>, F> void debugResponse(ICommand<E, F> cmd) {
        E response = cmd.getResponse();
        try {
            List<F> results = response.get();
            if (DEBUG && results != null) {
                for (int i = 0; i < results.size(); ++i) {
                    System.out.println(i + " " + results.get(i));
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

