/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.impl.applications;

import com.intel.stl.api.management.IManagementApi;
import com.intel.stl.api.management.applications.Application;
import com.intel.stl.api.management.applications.MGID;
import com.intel.stl.api.management.applications.MGIDRange;
import com.intel.stl.api.management.applications.ServiceID;
import com.intel.stl.api.management.applications.ServiceIDRange;
import com.intel.stl.api.management.virtualfabrics.ApplicationName;
import com.intel.stl.api.management.virtualfabrics.VirtualFabric;
import com.intel.stl.api.management.virtualfabrics.VirtualFabricException;
import com.intel.stl.ui.admin.ChangeState;
import com.intel.stl.ui.admin.Item;
import com.intel.stl.ui.admin.impl.ValidationTask;
import com.intel.stl.ui.admin.view.ValidationDialog;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.ValidationItem;
import com.intel.stl.ui.common.ValidationModel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public class AppValidationTask
extends ValidationTask<Application> {
    private final IManagementApi mgmtApi;

    public AppValidationTask(ValidationDialog dialog, ValidationModel<Application> model, List<Item<Application>> items, Item<Application> toCheck, IManagementApi mgmtApi) {
        super(dialog, model, items, toCheck);
        this.mgmtApi = mgmtApi;
    }

    @Override
    protected Integer doInBackground() throws Exception {
        ValidationItem<Application> vi;
        if (this.toCheck.getState() == ChangeState.NONE) {
            return 0;
        }
        int count = 0;
        if (this.toCheck.getState() == ChangeState.UPDATE || this.toCheck.getState() == ChangeState.ADD) {
            this.dialog.reportProgress(STLConstants.K2124_NAME_CHECK.getValue() + "...");
            vi = this.uniqueNameCheck(this.toCheck);
            if (vi != null) {
                this.publish(vi);
                ++count;
            }
            count += this.valueCheck(this.toCheck);
        }
        if (this.toCheck.getState() != ChangeState.ADD) {
            this.dialog.reportProgress(STLConstants.K2127_REF_CHECK.getValue() + "...");
            vi = this.appReferenceCheck(this.toCheck);
            if (vi != null) {
                this.publish(vi);
                ++count;
            }
        }
        if (this.toCheck.getState() != ChangeState.ADD) {
            this.dialog.reportProgress(STLConstants.K2127_REF_CHECK.getValue() + "...");
            vi = this.vfReferenceCheck(this.toCheck);
            if (vi != null) {
                this.publish(vi);
                ++count;
            }
        }
        return count;
    }

    protected ValidationItem<Application> uniqueNameCheck(Item<Application> app) {
        long id = app.getId();
        String name = app.getObj().getName();
        for (Item item : this.items) {
            if (item.getId() == id || !((Application)item.getObj()).getName().equals(name)) continue;
            return new ValidationItem<Application>(STLConstants.K2124_NAME_CHECK.getValue(), UILabels.STL81001_DUP_NAME.getDescription(), UILabels.STL81002_DUP_NAME_SUG.getDescription());
        }
        return null;
    }

    protected int valueCheck(Item<Application> item) {
        List<MGID> mgids;
        this.dialog.reportProgress(STLConstants.K2125_VALUE_CHECK.getValue() + "...");
        int count = 0;
        Application app = item.getObj();
        List<ServiceID> sids = app.getServiceIDs();
        if (sids != null) {
            for (ServiceID sid : sids) {
                ValidationItem<Application> vi;
                if (!(sid instanceof ServiceIDRange) || (vi = this.rangeCheck((ServiceIDRange)sid)) == null) continue;
                this.publish(vi);
                ++count;
            }
        }
        if ((mgids = app.getMgids()) != null) {
            for (MGID mgid : mgids) {
                ValidationItem<Application> vi;
                if (!(mgid instanceof MGIDRange) || (vi = this.rangeCheck((MGIDRange)mgid)) == null) continue;
                this.publish(vi);
                ++count;
            }
        }
        return count;
    }

    protected ValidationItem<Application> rangeCheck(ServiceIDRange range) {
        if (!this.unsignedRangeCheck(range.getMin(), range.getMax())) {
            return new ValidationItem<Application>(STLConstants.K2125_VALUE_CHECK.getValue(), UILabels.STL81006_INVALID_IDRANGE.getDescription(range.toString()), UILabels.STL81002_DUP_NAME_SUG.getDescription());
        }
        return null;
    }

    protected ValidationItem<Application> rangeCheck(MGIDRange range) {
        boolean invalid = true;
        if (this.unsignedRangeCheck(range.getMinLower(), range.getMaxLower())) {
            invalid = false;
        } else if (range.getMinLower() == range.getMaxLower()) {
            boolean bl = invalid = !this.unsignedRangeCheck(range.getMinUpper(), range.getMaxUpper());
        }
        if (invalid) {
            return new ValidationItem<Application>(STLConstants.K2125_VALUE_CHECK.getValue(), UILabels.STL81008_INVALID_GIDRANGE.getDescription(range.toString()), UILabels.STL81009_CHANGE_GID.getDescription());
        }
        return null;
    }

    protected boolean unsignedRangeCheck(long min, long max) {
        if (min >= 0L) {
            return max < 0L || max > min;
        }
        return max < 0L && max < min;
    }

    protected ValidationItem<Application> appReferenceCheck(Item<Application> app) {
        Callable<Application[]> quickFix;
        ValidationItem<Application> res;
        final String oldName = this.getApplication(app.getId()).getName();
        final String newName = app.getObj().getName();
        if (app.getState() != ChangeState.REMOVE && oldName.equals(newName)) {
            return null;
        }
        final List<Application> refs = this.getRelatedApps(oldName);
        if (refs.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(STLConstants.K2101_ADM_APPS.getValue());
        sb.append(" ");
        for (Application ref : refs) {
            if (sb.length() == 0) {
                sb.append("'" + ref.getName() + "'");
                continue;
            }
            sb.append(", '" + ref.getName() + "'");
        }
        if (app.getState() == ChangeState.REMOVE) {
            res = new ValidationItem<Application>(STLConstants.K2127_REF_CHECK.getValue(), UILabels.STL81003_REF_CONF.getDescription(sb.toString()), UILabels.STL81004_REMOVE_REF.getDescription());
            quickFix = new Callable<Application[]>(){

                @Override
                public Application[] call() throws Exception {
                    Application[] newApps = new Application[refs.size()];
                    for (int i = 0; i < refs.size(); ++i) {
                        Application app = ((Application)refs.get(i)).copy();
                        app.removeIncludeApplication(oldName);
                    }
                    AppValidationTask.this.fixedIssue(res);
                    return newApps;
                }
            };
            res.setQuickFix((Callable<E[]>)quickFix);
            return res;
        }
        if (app.getState() == ChangeState.UPDATE) {
            res = new ValidationItem(STLConstants.K2127_REF_CHECK.getValue(), UILabels.STL81003_REF_CONF.getDescription(sb.toString()), UILabels.STL81005_UPDATE_REF.getDescription());
            quickFix = new Callable<Application[]>(){

                @Override
                public Application[] call() throws Exception {
                    Application[] newApps = new Application[refs.size()];
                    for (int i = 0; i < refs.size(); ++i) {
                        Application app = ((Application)refs.get(i)).copy();
                        int index = app.indexOfIncludeApplication(oldName);
                        app.removeIncludeApplication(oldName);
                        app.insertIncludeApplication(index, newName);
                    }
                    AppValidationTask.this.fixedIssue(res);
                    return newApps;
                }
            };
            res.setQuickFix(quickFix);
            return res;
        }
        return null;
    }

    private ValidationItem<Application> vfReferenceCheck(Item<Application> app) {
        ValidationItem<Application> res;
        String oldName = this.getApplication(app.getId()).getName();
        String newName = app.getObj().getName();
        if (app.getState() != ChangeState.REMOVE && oldName.equals(newName)) {
            return null;
        }
        List<VirtualFabric> refs = this.getRelatedVfs(oldName);
        if (refs.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(STLConstants.K2105_ADM_VFS.getValue());
        sb.append(" ");
        String sep = "'";
        for (VirtualFabric ref : refs) {
            sb.append(sep);
            sb.append(ref.getName());
            sb.append("'");
            sep = ", '";
        }
        if (app.getState() == ChangeState.REMOVE) {
            res = new ValidationItem<Application>(STLConstants.K2127_REF_CHECK.getValue(), UILabels.STL81003_REF_CONF.getDescription(sb.toString()), UILabels.STL81004_REMOVE_REF.getDescription());
            return res;
        }
        if (app.getState() == ChangeState.UPDATE) {
            res = new ValidationItem(STLConstants.K2127_REF_CHECK.getValue(), UILabels.STL81003_REF_CONF.getDescription(sb.toString()), UILabels.STL81005_UPDATE_REF.getDescription());
            return res;
        }
        return null;
    }

    private List<VirtualFabric> getRelatedVfs(String appName) {
        ArrayList<VirtualFabric> relVfs = new ArrayList<VirtualFabric>();
        try {
            List<VirtualFabric> vfs = this.mgmtApi.getVirtualFabrics();
            block2: for (VirtualFabric vf : vfs) {
                List<ApplicationName> vfApps = vf.getApplications();
                for (ApplicationName name : vfApps) {
                    if (!name.getValue().equals(appName)) continue;
                    relVfs.add(vf);
                    continue block2;
                }
            }
        }
        catch (VirtualFabricException e) {
            e.printStackTrace();
        }
        return relVfs;
    }

    protected Application getApplication(long id) {
        for (Item item : this.items) {
            if (item.getId() != id) continue;
            return (Application)item.getObj();
        }
        throw new IllegalArgumentException("Couldn't find item by id=" + id);
    }

    protected List<Application> getRelatedApps(String name) {
        ArrayList<Application> res = new ArrayList<Application>();
        for (Item item : this.items) {
            Application app = (Application)item.getObj();
            if (!app.doesIncludeApplication(name)) continue;
            res.add(app);
            break;
        }
        return res;
    }
}

