/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.impl.devicegroups;

import com.intel.stl.api.management.IAttribute;
import com.intel.stl.api.management.NumberNode;
import com.intel.stl.api.management.devicegroups.DGSelect;
import com.intel.stl.api.management.devicegroups.DeviceGroup;
import com.intel.stl.api.management.devicegroups.IncludeGroup;
import com.intel.stl.api.management.devicegroups.NodeDesc;
import com.intel.stl.api.management.devicegroups.NodeGUID;
import com.intel.stl.api.management.devicegroups.NodeTypeAttr;
import com.intel.stl.api.management.devicegroups.PortGUID;
import com.intel.stl.api.management.devicegroups.SystemImageGUID;
import com.intel.stl.ui.admin.Item;
import com.intel.stl.ui.admin.impl.devicegroups.DevicesSelector;
import com.intel.stl.ui.admin.impl.devicegroups.IResourceSelector;
import com.intel.stl.ui.admin.impl.devicegroups.IncludeSelector;
import com.intel.stl.ui.admin.impl.devicegroups.SelectSelector;
import com.intel.stl.ui.admin.view.devicegroups.DevicegroupSelectionPanel;
import com.intel.stl.ui.admin.view.devicegroups.DevicesPanel;
import com.intel.stl.ui.admin.view.devicegroups.ListPanel;
import com.intel.stl.ui.main.Context;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DevicegroupSelectionController {
    private final DevicegroupSelectionPanel view;
    private final Map<String, IResourceSelector> selectors = new LinkedHashMap<String, IResourceSelector>();
    private final Map<Class<? extends IAttribute>, Set<IResourceSelector>> typeSelectors = new HashMap<Class<? extends IAttribute>, Set<IResourceSelector>>();
    private DevicesSelector devicesSelector;
    private SelectSelector selectSelector;
    private IncludeSelector includeSelector;

    public DevicegroupSelectionController(DevicegroupSelectionPanel view) {
        this.view = view;
        this.installSelectors();
        view.setSelectors(this.selectors.values());
    }

    protected void installSelectors() {
        this.selectors.clear();
        DevicesPanel dp = new DevicesPanel();
        this.devicesSelector = new DevicesSelector(dp);
        this.registerSelector(this.devicesSelector, SystemImageGUID.class, NodeGUID.class, PortGUID.class, NodeDesc.class, NodeTypeAttr.class);
        ListPanel<DGSelect> selectView = new ListPanel<DGSelect>();
        this.selectSelector = new SelectSelector(selectView);
        this.registerSelector(this.selectSelector, DGSelect.class);
        ListPanel<IncludeGroup> includeView = new ListPanel<IncludeGroup>();
        this.includeSelector = new IncludeSelector(includeView);
        this.registerSelector(this.includeSelector, IncludeGroup.class);
    }

    protected void registerSelector(IResourceSelector selector, Class<? extends IAttribute> ... types) {
        this.selectors.put(selector.getName(), selector);
        for (Class<? extends IAttribute> type : types) {
            Set<IResourceSelector> selectors = this.typeSelectors.get(type);
            if (selectors == null) {
                selectors = new HashSet<IResourceSelector>();
                this.typeSelectors.put(type, selectors);
            }
            selectors.add(selector);
        }
    }

    protected void registerSelector(Class<? extends IAttribute> type, IResourceSelector selector) {
        Set<IResourceSelector> selectors = this.typeSelectors.get(type);
        if (selectors == null) {
            selectors = new HashSet<IResourceSelector>();
            this.typeSelectors.put(type, selectors);
        }
        selectors.add(selector);
    }

    public void setContext(Context context) {
        for (IResourceSelector selector : this.selectors.values()) {
            selector.setContext(context, null);
        }
    }

    public void clear() {
        this.devicesSelector.clear();
        this.selectSelector.clear();
        this.includeSelector.clear();
        this.includeSelector.setGroups(new ArrayList<IncludeGroup>());
    }

    public void setItem(Item<DeviceGroup> item, Item<DeviceGroup>[] items) {
        List<NodeTypeAttr> types;
        List<NodeDesc> descs;
        DeviceGroup dg = item.getObj();
        this.devicesSelector.clear();
        List<NumberNode> ids = dg.getIDs();
        if (ids != null) {
            this.fireAddAttrs(ids, this.devicesSelector);
        }
        if ((descs = dg.getNodeDesc()) != null) {
            this.fireAddAttrs(descs, this.devicesSelector);
        }
        if ((types = dg.getNodeTypes()) != null) {
            this.fireAddAttrs(types, this.devicesSelector);
        }
        this.selectSelector.clear();
        List<DGSelect> sels = dg.getSelects();
        if (sels != null) {
            this.fireAddAttrs(sels, this.selectSelector);
        }
        this.includeSelector.clear();
        ArrayList<IncludeGroup> allGroups = new ArrayList<IncludeGroup>(items.length);
        for (int i = 0; i < items.length; ++i) {
            allGroups.add(new IncludeGroup(items[i].getName()));
        }
        this.includeSelector.setGroups(allGroups);
        List<IncludeGroup> includeGroups = dg.getIncludeGroups();
        if (includeGroups != null) {
            this.fireAddAttrs(includeGroups, this.includeSelector);
        }
    }

    public void includeGroupNameChanged(String oldName, String newName) {
        this.includeSelector.groupNameChanged(oldName, newName);
    }

    protected void fireAddAttrs(List<? extends IAttribute> attr, IResourceSelector ... selectors) {
        for (IResourceSelector selector : selectors) {
            selector.setModelSelections(attr);
        }
    }

    public List<IAttribute> getSelections(String selectorName) {
        IResourceSelector selector = this.selectors.get(selectorName);
        if (selector != null) {
            return selector.getViewSelections();
        }
        throw new IllegalArgumentException("Couldn't find ResourceSelector '" + selectorName + "'");
    }

    public void addSelections(String selectorName, List<IAttribute> attrs) {
        IResourceSelector selector = this.selectors.get(selectorName);
        if (selector == null) {
            throw new IllegalArgumentException("Couldn't find ResourceSelector '" + selectorName + "'");
        }
        this.fireAddAttrs(attrs, selector);
    }

    public void removeSelection(IAttribute attr) {
        Set<IResourceSelector> selectors = this.typeSelectors.get(attr.getClass());
        if (selectors != null) {
            this.fireRemoveAttrs(attr, selectors.toArray(new IResourceSelector[0]));
        }
    }

    protected void fireRemoveAttrs(IAttribute attr, IResourceSelector ... selectors) {
        for (IResourceSelector selector : selectors) {
            selector.removeModelSelection(attr);
        }
    }

    public void clearViewSelections(String selectorName) {
        IResourceSelector selector = this.selectors.get(selectorName);
        if (selector != null) {
            selector.clearViewSelections();
        }
    }
}

